/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.theory.AxiomaticDefinitionBlock;
import de.prob.model.eventb.theory.DataType;
import de.prob.model.eventb.theory.DataTypeConstructor;
import de.prob.model.eventb.theory.DataTypeDestructor;
import de.prob.model.eventb.theory.DirectDefinition;
import de.prob.model.eventb.theory.IOperatorDefinition;
import de.prob.model.eventb.theory.Operator;
import de.prob.model.eventb.theory.OperatorArgument;
import de.prob.model.eventb.theory.RecursiveDefinitionCase;
import de.prob.model.eventb.theory.RecursiveOperatorDefinition;
import de.prob.model.eventb.theory.Theory;
import de.prob.model.eventb.theory.Type;
import de.prob.model.representation.ModelElementList;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.tmparser.OperatorMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FreeIdentifier;

public class TheoryTranslator {
    private final List<Theory> theories = new ArrayList<Theory>();

    public TheoryTranslator(ModelElementList<Theory> theories) {
        for (Theory theory : theories) {
            if (this.theories.contains(theory)) continue;
            for (Theory t : theory.getImported()) {
                if (this.theories.contains(t)) continue;
                this.theories.add(t);
            }
            this.theories.add(theory);
        }
    }

    public void toProlog(IPrologTermOutput pto) {
        for (Theory theory : this.theories) {
            pto.openTerm("theory");
            this.printTheoryName(theory, pto);
            this.printListOfImportedTheories(theory.getImported(), pto);
            this.printTypeParameters(theory.getTypeParameters(), pto);
            this.printDataTypes(theory.getDataTypes(), pto);
            this.printOperatorDefs(theory.getOperators(), pto);
            this.printAxiomaticDefintionBlocks(theory.getAxiomaticDefinitionBlocks(), pto);
            this.printMappings(theory.getProBMappings(), pto);
            pto.closeTerm();
        }
    }

    public void printTheoryName(Theory t, IPrologTermOutput pto) {
        pto.openTerm("theory_name");
        pto.printAtom(t.getParentDirectoryName());
        pto.printAtom(t.getName());
        pto.closeTerm();
    }

    private void printListOfImportedTheories(ModelElementList<Theory> imported, IPrologTermOutput pto) {
        pto.openList();
        for (Theory theory : imported) {
            this.printTheoryName(theory, pto);
        }
        pto.closeList();
    }

    private void printTypeParameters(ModelElementList<Type> typeParameters, IPrologTermOutput pto) {
        pto.openList();
        for (Type t : typeParameters) {
            pto.printAtom(t.toString());
        }
        pto.closeList();
    }

    private void printDataTypes(ModelElementList<DataType> dataTypes, IPrologTermOutput pto) {
        pto.openList();
        for (DataType dataType : dataTypes) {
            this.printDataType(dataType, pto);
        }
        pto.closeList();
    }

    private void printDataType(DataType dataType, IPrologTermOutput pto) {
        pto.openTerm("datatype");
        pto.printAtom(dataType.toString());
        pto.openList();
        for (Type arg : dataType.getTypeArguments()) {
            this.printType(arg, pto);
        }
        pto.closeList();
        pto.openList();
        for (DataTypeConstructor cons : dataType.getDataTypeConstructors()) {
            this.printConstructor(cons, pto);
        }
        pto.closeList();
        pto.closeTerm();
    }

    private void printType(Type type, IPrologTermOutput pto) {
        this.printEventBElement(type.getIdentifier(), pto);
    }

    private void printConstructor(DataTypeConstructor cons, IPrologTermOutput pto) {
        pto.openTerm("constructor");
        pto.printAtom(cons.toString());
        pto.openList();
        for (DataTypeDestructor arg : cons.getDestructors()) {
            this.printTypedIdentifier("destructor", arg.getUnicodeIdentifier(), arg.getType(), pto);
        }
        pto.closeList();
        pto.closeTerm();
    }

    private void printTypedIdentifier(String functor, String idString, EventB type, IPrologTermOutput pto) {
        pto.openTerm(functor);
        pto.printAtom(idString);
        this.printEventBElement(type, pto);
        pto.closeTerm();
    }

    private void printEventBElement(EventB eventB, IPrologTermOutput pto) {
        eventB.getAst().apply((Switch)new ASTProlog(pto, null));
    }

    private void printOperatorDefs(ModelElementList<Operator> operators, IPrologTermOutput pto) {
        pto.openList();
        for (Operator operator : operators) {
            this.printOperator(operator, pto);
        }
        pto.closeList();
    }

    private void printOperator(Operator operator, IPrologTermOutput pto) {
        pto.openTerm("operator");
        pto.printAtom(operator.toString());
        this.printOperatorArguments(operator.getArguments(), pto);
        this.printEventBElement(operator.getWD(), pto);
        this.processDefinition(operator.getDefinition(), pto);
        pto.closeTerm();
    }

    private void processDefinition(IOperatorDefinition definition, IPrologTermOutput pto) {
        if (definition instanceof DirectDefinition) {
            this.printDirectDefinition((DirectDefinition)definition, pto);
            pto.openList();
            pto.closeList();
        }
        if (definition instanceof RecursiveOperatorDefinition) {
            pto.openList();
            pto.closeList();
            this.printRecursiveDefinition((RecursiveOperatorDefinition)definition, pto);
        }
    }

    private void printRecursiveDefinition(RecursiveOperatorDefinition definition, IPrologTermOutput pto) {
        EventB inductiveArgument = definition.getInductiveArgument();
        pto.openList();
        ModelElementList<RecursiveDefinitionCase> cases = definition.getCases();
        for (RecursiveDefinitionCase c : cases) {
            this.printRecursiveCase(inductiveArgument, c, pto);
        }
        pto.closeList();
    }

    private void printRecursiveCase(EventB inductiveArgument, RecursiveDefinitionCase c, IPrologTermOutput pto) {
        c.getExpression();
        c.getFormula();
        pto.openTerm("case");
        pto.printAtom(inductiveArgument.getCode());
        pto.openList();
        Expression expression = c.getExpression().getRodinParsedResult().getParsedExpression();
        for (FreeIdentifier fi : expression.getFreeIdentifiers()) {
            pto.printAtom(fi.getName());
        }
        pto.closeList();
        this.printEventBElement(c.getExpression(), pto);
        this.printEventBElement(c.getFormula(), pto);
        pto.closeTerm();
    }

    private void printDirectDefinition(DirectDefinition definition, IPrologTermOutput pto) {
        pto.openList();
        this.printEventBElement((EventB)definition.getFormula(), pto);
        pto.closeList();
    }

    private void printOperatorArguments(List<OperatorArgument> arguments, IPrologTermOutput pto) {
        pto.openList();
        for (OperatorArgument argument : arguments) {
            this.printTypedIdentifier("argument", argument.getIdentifier().toString(), argument.getType(), pto);
        }
        pto.closeList();
    }

    private void printAxiomaticDefintionBlocks(ModelElementList<AxiomaticDefinitionBlock> axiomaticDefinitionBlocks, IPrologTermOutput pto) {
        pto.openList();
        for (AxiomaticDefinitionBlock block : axiomaticDefinitionBlocks) {
            this.printAxiomaticDefinitonBlock(block, pto);
        }
        pto.closeList();
    }

    private void printAxiomaticDefinitonBlock(AxiomaticDefinitionBlock block, IPrologTermOutput pto) {
        pto.openTerm("axiomatic_def_block");
        pto.printAtom(block.getName());
        this.printTypeParameters(block.getTypeParameters(), pto);
        pto.openList();
        for (Operator operator : block.getOperators()) {
            this.printAxiomaticOperator(operator, pto);
        }
        pto.closeList();
        pto.openList();
        for (EventBAxiom axiom : block.getAxioms()) {
            this.printEventBElement((EventB)axiom.getPredicate(), pto);
        }
        pto.closeList();
        pto.closeTerm();
    }

    private void printAxiomaticOperator(Operator operator, IPrologTermOutput pto) {
        pto.openTerm("opdef");
        pto.printAtom(operator.toString());
        this.printOperatorArguments(operator.getArguments(), pto);
        pto.openList();
        this.printEventBElement(operator.getWD(), pto);
        pto.closeList();
        pto.closeTerm();
    }

    private void printMappings(Collection<OperatorMapping> proBMappings, IPrologTermOutput pto) {
        pto.openList();
        for (OperatorMapping mapping : proBMappings) {
            pto.openTerm("tag");
            pto.printAtom(mapping.getOperatorName());
            pto.printAtom(mapping.getSpec());
            pto.closeTerm();
        }
        pto.closeList();
    }
}

