/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.ModelCheckingStepCommand;
import de.prob.check.CheckInterrupted;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.ModelCheckingOptions;
import de.prob.check.NotYetFinished;
import de.prob.check.StateSpaceStats;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public class ModelCheckingJob
extends AbstractCommand {
    private static final int TIME = 500;
    private final String jobId;
    private ModelCheckingOptions options;
    private ModelCheckingStepCommand cmd;
    private IModelCheckingResult res;
    private StateSpaceStats stats;
    private final IModelCheckListener ui;
    private long time = -1L;

    public ModelCheckingJob(ModelCheckingOptions options, String jobId, IModelCheckListener ui) {
        this.options = options;
        this.jobId = jobId;
        this.ui = ui;
        this.completed = false;
        this.cmd = new ModelCheckingStepCommand(500, options);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        if (this.time == -1L) {
            this.time = System.currentTimeMillis();
        }
        this.cmd.writeCommand(pto);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.cmd.processResult(bindings);
        this.res = this.cmd.getResult();
        this.stats = this.cmd.getStats();
        if (this.ui != null && this.res != null && this.stats != null) {
            this.ui.updateStats(this.jobId, System.currentTimeMillis() - this.time, this.res, this.stats);
        }
        this.completed = !(this.res instanceof NotYetFinished) || this.res == null;
        this.options = this.options.recheckExisting(false);
        this.cmd = new ModelCheckingStepCommand(500, this.options);
    }

    public IModelCheckingResult getResult() {
        return this.res == null && this.interrupted ? new CheckInterrupted() : this.res;
    }

    @Override
    public boolean blockAnimator() {
        return true;
    }

    public StateSpaceStats getStats() {
        return this.stats;
    }
}

