/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.typecheck;

import java.util.Arrays;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BooleanType;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.GivenType;
import org.eventb.core.ast.IntegerType;
import org.eventb.core.ast.ParametricType;
import org.eventb.core.ast.PowerSetType;
import org.eventb.core.ast.ProblemKind;
import org.eventb.core.ast.ProductType;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.extension.IExpressionExtension;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeVariable;

public class TypeUnifier {
    private FormulaFactory factory;
    private TypeCheckResult result;

    public TypeUnifier(TypeCheckResult result) {
        this.factory = result.getFormulaFactory();
        this.result = result;
    }

    private static boolean tom_equal_term_char(char t1, char t2) {
        return t1 == t2;
    }

    private static boolean tom_is_sort_char(char t) {
        return true;
    }

    private static boolean tom_equal_term_String(String t1, String t2) {
        return t1.equals(t2);
    }

    private static boolean tom_is_sort_String(String t) {
        return t instanceof String;
    }

    private static boolean tom_equal_term_Type(Object t1, Object t2) {
        return t1.equals(t2);
    }

    private static boolean tom_is_sort_Type(Object t) {
        return t instanceof Type;
    }

    private static boolean tom_equal_term_TypeList(Object t1, Object t2) {
        return Arrays.equals((Type[])t1, (Type[])t2);
    }

    private static boolean tom_is_fun_sym_PowSet(Type t) {
        return t instanceof PowerSetType;
    }

    private static Type tom_get_slot_PowSet_child(Type t) {
        return ((PowerSetType)t).getBaseType();
    }

    private static boolean tom_is_fun_sym_CProd(Type t) {
        return t instanceof ProductType;
    }

    private static Type tom_get_slot_CProd_left(Type t) {
        return ((ProductType)t).getLeft();
    }

    private static Type tom_get_slot_CProd_right(Type t) {
        return ((ProductType)t).getRight();
    }

    private static boolean tom_is_fun_sym_ParamType(Type t) {
        return t instanceof ParametricType;
    }

    private static Type[] tom_get_slot_ParamType_children(Type t) {
        return ((ParametricType)t).getTypeParameters();
    }

    private static boolean tom_is_fun_sym_Set(Type t) {
        return t instanceof GivenType;
    }

    private static String tom_get_slot_Set_name(Type t) {
        return ((GivenType)t).getName();
    }

    private static boolean tom_is_fun_sym_Int(Type t) {
        return t instanceof IntegerType;
    }

    private static boolean tom_is_fun_sym_Bool(Type t) {
        return t instanceof BooleanType;
    }

    private static boolean tom_is_fun_sym_TypeVar(Type t) {
        return t instanceof TypeVariable;
    }

    protected final <T extends Formula<?>> Type unify(Type left, Type right, T origin) {
        if (left == null || right == null) {
            return null;
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_TypeVar(left) && TypeUnifier.tom_is_sort_Type(right)) {
            return this.unifyVariable((TypeVariable)left, right, origin);
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_TypeVar(right)) {
            return this.unifyVariable((TypeVariable)right, left, origin);
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_PowSet(left)) {
            Type tom_child1 = TypeUnifier.tom_get_slot_PowSet_child(left);
            if (TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_PowSet(right)) {
                Type tom_child2 = TypeUnifier.tom_get_slot_PowSet_child(right);
                Type newChild = this.unify(tom_child1, tom_child2, origin);
                if (newChild == null) {
                    return null;
                }
                if (newChild == tom_child1) {
                    return left;
                }
                if (newChild == tom_child2) {
                    return right;
                }
                return this.result.makePowerSetType(newChild);
            }
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_CProd(left)) {
            Type tom_left1 = TypeUnifier.tom_get_slot_CProd_left(left);
            Type tom_right1 = TypeUnifier.tom_get_slot_CProd_right(left);
            if (TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_CProd(right)) {
                Type tom_left2 = TypeUnifier.tom_get_slot_CProd_left(right);
                Type tom_right2 = TypeUnifier.tom_get_slot_CProd_right(right);
                Type newLeft = this.unify(tom_left1, tom_left2, origin);
                Type newRight = this.unify(tom_right1, tom_right2, origin);
                if (newLeft == null || newRight == null) {
                    return null;
                }
                if (newLeft == tom_left1 && newRight == tom_right1) {
                    return left;
                }
                if (newLeft == tom_left2 && newRight == tom_right2) {
                    return right;
                }
                return this.result.makeProductType(newLeft, newRight);
            }
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_ParamType(left)) {
            Type[] tom_params1 = TypeUnifier.tom_get_slot_ParamType_children(left);
            if (TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_ParamType(right)) {
                Type[] tom_params2 = TypeUnifier.tom_get_slot_ParamType_children(right);
                ParametricType paramType1 = (ParametricType)left;
                ParametricType paramType2 = (ParametricType)right;
                IExpressionExtension ext = paramType1.getExprExtension();
                if (ext != paramType2.getExprExtension()) {
                    this.result.addUnificationProblem(left, right, origin);
                    return null;
                }
                int length = tom_params1.length;
                assert (length == tom_params2.length);
                Type[] newParams = new Type[length];
                boolean all1 = true;
                boolean all2 = true;
                for (int i = 0; i < length; ++i) {
                    Type param1 = tom_params1[i];
                    Type param2 = tom_params2[i];
                    Type newParam = this.unify(param1, param2, origin);
                    if (newParam == null) {
                        return null;
                    }
                    all1 &= newParam == param1;
                    all2 &= newParam == param2;
                    newParams[i] = newParam;
                }
                if (all1) {
                    return left;
                }
                if (all2) {
                    return right;
                }
                return this.result.makeParametricType(ext, newParams);
            }
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_Int(left) && TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_Int(right)) {
            return left;
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_Bool(left) && TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_Bool(right)) {
            return left;
        }
        if (TypeUnifier.tom_is_sort_Type(left) && TypeUnifier.tom_is_fun_sym_Set(left) && TypeUnifier.tom_is_sort_Type(right) && TypeUnifier.tom_is_fun_sym_Set(right)) {
            if (TypeUnifier.tom_get_slot_Set_name(left).equals(TypeUnifier.tom_get_slot_Set_name(right))) {
                return left;
            }
            this.result.addUnificationProblem(left, right, origin);
            return null;
        }
        this.result.addUnificationProblem(left, right, origin);
        return null;
    }

    private <T extends Formula<?>> Type unifyVariable(TypeVariable variable, Type otherType, T origin) {
        Type type = variable.getValue();
        if (type != null) {
            if ((type = this.unify(type, otherType, origin)) != null) {
                variable.setValue(type);
            }
            return type;
        }
        type = this.solve(otherType);
        if (type == variable) {
            return variable;
        }
        if (this.occurs(variable, type)) {
            this.result.addProblem(new ASTProblem(origin.getSourceLocation(), ProblemKind.Circularity, 1, new Object[0]));
            return null;
        }
        variable.setValue(type);
        return type;
    }

    public final Type solve(Type intype) {
        assert (intype != null);
        if (TypeUnifier.tom_is_sort_Type(intype) && TypeUnifier.tom_is_fun_sym_TypeVar(intype)) {
            TypeVariable typeVar = (TypeVariable)intype;
            Type type = typeVar.getValue();
            if (type != null) {
                type = this.solve(type);
                typeVar.setValue(type);
                return type;
            }
            return intype;
        }
        if (TypeUnifier.tom_is_sort_Type(intype) && TypeUnifier.tom_is_fun_sym_PowSet(intype)) {
            Type tom_child = TypeUnifier.tom_get_slot_PowSet_child(intype);
            Type newChild = this.solve(tom_child);
            if (newChild == tom_child) {
                return intype;
            }
            return this.result.makePowerSetType(newChild);
        }
        if (TypeUnifier.tom_is_sort_Type(intype) && TypeUnifier.tom_is_fun_sym_CProd(intype)) {
            Type tom_left = TypeUnifier.tom_get_slot_CProd_left(intype);
            Type tom_right = TypeUnifier.tom_get_slot_CProd_right(intype);
            Type newLeft = this.solve(tom_left);
            Type newRight = this.solve(tom_right);
            if (newLeft == tom_left && newRight == tom_right) {
                return intype;
            }
            return this.result.makeProductType(newLeft, newRight);
        }
        if (TypeUnifier.tom_is_sort_Type(intype) && TypeUnifier.tom_is_fun_sym_ParamType(intype)) {
            Type[] tom_params = TypeUnifier.tom_get_slot_ParamType_children(intype);
            int length = tom_params.length;
            Type[] newParams = new Type[length];
            boolean same = true;
            for (int i = 0; i < length; ++i) {
                Type param = tom_params[i];
                Type newParam = this.solve(param);
                same &= newParam == param;
                newParams[i] = newParam;
            }
            if (same) {
                return intype;
            }
            IExpressionExtension exprExt = ((ParametricType)intype).getExprExtension();
            return this.result.makeParametricType(exprExt, newParams);
        }
        return intype;
    }

    protected final boolean occurs(TypeVariable typeVar, Type expr) {
        if (TypeUnifier.tom_is_sort_Type(expr) && TypeUnifier.tom_is_fun_sym_TypeVar(expr)) {
            return typeVar == expr;
        }
        if (TypeUnifier.tom_is_sort_Type(expr) && TypeUnifier.tom_is_fun_sym_PowSet(expr)) {
            return this.occurs(typeVar, TypeUnifier.tom_get_slot_PowSet_child(expr));
        }
        if (TypeUnifier.tom_is_sort_Type(expr) && TypeUnifier.tom_is_fun_sym_CProd(expr)) {
            return this.occurs(typeVar, TypeUnifier.tom_get_slot_CProd_left(expr)) || this.occurs(typeVar, TypeUnifier.tom_get_slot_CProd_right(expr));
        }
        if (TypeUnifier.tom_is_sort_Type(expr) && TypeUnifier.tom_is_fun_sym_ParamType(expr)) {
            for (Type param : TypeUnifier.tom_get_slot_ParamType_children(expr)) {
                if (!this.occurs(typeVar, param)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public final FormulaFactory getFormulaFactory() {
        return this.factory;
    }
}

