/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import org.eventb.core.ast.Type;
import org.eventb.internal.core.ast.datatype.ArgumentTypeChecker;
import org.eventb.internal.core.ast.datatype.ConstructorArgument;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.Datatype;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.ast.datatype.DestructorExtension;
import org.eventb.internal.core.ast.datatype.ExtensionHarvester;

public final class DatatypeArgument {
    private final String name;
    private final Type type;
    private final boolean isBasic;

    public DatatypeArgument(DatatypeBuilder dtBuilder, String name, Type argType) {
        ArgumentTypeChecker checker = dtBuilder.getArgumentTypeChecker();
        checker.check(argType);
        if (name != null) {
            dtBuilder.checkName(name, "destructor");
        }
        this.name = name;
        this.type = argType;
        this.isBasic = checker.isBasic();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isBasic() {
        return this.isBasic;
    }

    public boolean hasDestructor() {
        return this.name != null;
    }

    public String getDestructorName() {
        return this.name;
    }

    public ConstructorArgument finalize(Datatype origin, ConstructorExtension constructorExt) {
        if (this.hasDestructor()) {
            return new DestructorExtension(origin, constructorExt, this.name, this.type);
        }
        return new ConstructorArgument(constructorExt, this.type);
    }

    public void harvest(ExtensionHarvester harvester) {
        harvester.harvest(this.type);
    }
}

