/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.internal.core.ast.datatype;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.Type;
import org.eventb.core.ast.datatype.IConstructorExtension;
import org.eventb.core.ast.datatype.IDatatype;
import org.eventb.core.ast.datatype.IDestructorExtension;
import org.eventb.core.ast.datatype.ISetInstantiation;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.eventb.internal.core.ast.datatype.ConstructorBuilder;
import org.eventb.internal.core.ast.datatype.ConstructorExtension;
import org.eventb.internal.core.ast.datatype.DatatypeBuilder;
import org.eventb.internal.core.ast.datatype.DestructorExtension;
import org.eventb.internal.core.ast.datatype.SetSubstitution;
import org.eventb.internal.core.ast.datatype.TypeConstructorExtension;
import org.eventb.internal.core.ast.datatype.TypeSubstitution;

public class Datatype
implements IDatatype {
    private static final Map<Datatype, Datatype> REGISTRY = new HashMap<Datatype, Datatype>();
    private final FormulaFactory baseFactory;
    private final TypeConstructorExtension typeCons;
    private final LinkedHashMap<String, ConstructorExtension> constructors;
    private final Map<String, DestructorExtension> destructors;
    private final Set<IFormulaExtension> extensions;
    private final Object origin;

    public static Datatype makeDatatype(DatatypeBuilder dtBuilder) {
        Datatype candidate = new Datatype(dtBuilder);
        return Datatype.registerDatatype(candidate);
    }

    private static Datatype registerDatatype(Datatype candidate) {
        Datatype representative = REGISTRY.get(candidate);
        if (representative != null) {
            return representative;
        }
        REGISTRY.put(candidate, candidate);
        return candidate;
    }

    private Datatype(DatatypeBuilder dtBuilder) {
        this.baseFactory = dtBuilder.getBaseFactory();
        this.origin = dtBuilder.getOrigin();
        this.typeCons = new TypeConstructorExtension(this, dtBuilder);
        this.constructors = new LinkedHashMap();
        this.destructors = new HashMap<String, DestructorExtension>();
        List<ConstructorBuilder> dtConstrs = dtBuilder.getConstructors();
        for (ConstructorBuilder dtCons : dtConstrs) {
            ConstructorExtension constructor = dtCons.makeExtension(this);
            this.constructors.put(constructor.getName(), constructor);
            this.destructors.putAll(constructor.getDestructorMap());
        }
        this.extensions = new HashSet<IFormulaExtension>();
        this.extensions.add(this.typeCons);
        this.extensions.addAll(this.constructors.values());
        this.extensions.addAll(this.destructors.values());
    }

    @Override
    public TypeConstructorExtension getTypeConstructor() {
        return this.typeCons;
    }

    @Override
    public TypeSubstitution getTypeInstantiation(Type type) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        TypeSubstitution ti = TypeSubstitution.makeSubstitution(this, type);
        if (ti == null) {
            throw new IllegalArgumentException("Type " + type + " is not an instance of " + this.typeCons.getName());
        }
        return ti;
    }

    @Override
    public ISetInstantiation getSetInstantiation(Expression set) {
        if (set == null) {
            throw new NullPointerException("Null set");
        }
        return SetSubstitution.makeSubstitution(this, set);
    }

    public boolean hasSingleConstructor() {
        return this.constructors.size() == 1;
    }

    @Override
    public IConstructorExtension[] getConstructors() {
        Collection<ConstructorExtension> cons = this.constructors.values();
        return cons.toArray(new IConstructorExtension[cons.size()]);
    }

    @Override
    public IConstructorExtension getConstructor(String name) {
        return this.constructors.get(name);
    }

    @Override
    public IDestructorExtension getDestructor(String name) {
        return this.destructors.get(name);
    }

    @Override
    public FormulaFactory getBaseFactory() {
        return this.baseFactory;
    }

    @Override
    public FormulaFactory getFactory() {
        return this.baseFactory.withExtensions(this.getExtensions());
    }

    @Override
    public Set<IFormulaExtension> getExtensions() {
        return Collections.unmodifiableSet(this.extensions);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.typeCons.hashCode();
        result = 31 * result + this.constructors.hashCode();
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Datatype other = (Datatype)obj;
        return this.typeCons.isSimilarTo(other.typeCons) && Datatype.areSimilarConstructors(this.constructors.values(), other.constructors.values()) && Datatype.areEqualOrigins(this.origin, other.origin);
    }

    private static boolean areEqualOrigins(Object origin1, Object origin2) {
        if (origin1 == null) {
            return origin2 == null;
        }
        return origin1.equals(origin2);
    }

    private static boolean areSimilarConstructors(Collection<ConstructorExtension> cons1, Collection<ConstructorExtension> cons2) {
        if (cons1.size() != cons2.size()) {
            return false;
        }
        Iterator<ConstructorExtension> it1 = cons1.iterator();
        Iterator<ConstructorExtension> it2 = cons2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next().isSimilarTo(it2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.typeCons.toString(sb);
        String sep = " ::= ";
        for (ConstructorExtension cons : this.constructors.values()) {
            sb.append(sep);
            sep = " || ";
            cons.toString(sb);
        }
        return sb.toString();
    }

    @Override
    public Object getOrigin() {
        return this.origin;
    }
}

