/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eventb.core.ast.ASTProblem;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.BoundIdentifier;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.QuantifiedHelper;
import org.eventb.core.ast.QuantifiedUtil;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.BoundIdentDeclRemover;
import org.eventb.internal.core.ast.BoundIdentSubstitution;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IdentListMerger;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class QuantifiedPredicate
extends Predicate {
    private final BoundIdentDecl[] quantifiedIdentifiers;
    private final Predicate pred;
    private static final int FIRST_TAG = 851;
    public static final String FORALL_ID = "for all";
    public static final String EXISTS_ID = "exists";
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected QuantifiedPredicate(Predicate pred, BoundIdentDecl[] boundIdentifiers, int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, QuantifiedPredicate.combineHashCodes(boundIdentifiers.length, pred.hashCode()));
        this.quantifiedIdentifiers = boundIdentifiers;
        this.pred = pred;
        FormulaChecks.ensureTagInRange(tag, 851, TAGS_LENGTH);
        FormulaChecks.ensureMinLength(boundIdentifiers, 1);
        this.ensureSameFactory(this.quantifiedIdentifiers);
        this.ensureSameFactory(this.pred);
        this.setPredicateVariableCache(this.pred);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        int length = this.quantifiedIdentifiers.length;
        Formula[] children = new Formula[length + 1];
        System.arraycopy(this.quantifiedIdentifiers, 0, children, 0, length);
        children[length] = this.pred;
        IdentListMerger freeIdentMerger = QuantifiedPredicate.mergeFreeIdentifiers((Formula[])children);
        this.freeIdents = freeIdentMerger.getFreeMergedArray();
        BoundIdentifier[] boundIdentsBelow = this.pred.boundIdents;
        this.boundIdents = QuantifiedHelper.getBoundIdentsAbove(boundIdentsBelow, this.quantifiedIdentifiers, this.getFactory());
        if (freeIdentMerger.containsError()) {
            return;
        }
        if (!QuantifiedHelper.checkBoundIdentTypes(boundIdentsBelow, this.quantifiedIdentifiers)) {
            return;
        }
        if (!this.pred.isTypeChecked()) {
            return;
        }
        this.typeChecked = true;
    }

    public BoundIdentDecl[] getBoundIdentDecls() {
        return (BoundIdentDecl[])this.quantifiedIdentifiers.clone();
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 851];
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        HashSet<String> usedNames = new HashSet<String>();
        String[] boundNames = mediator.getBoundNames();
        this.pred.collectNamesAbove(usedNames, boundNames, this.quantifiedIdentifiers.length);
        String[] localNames = QuantifiedUtil.resolveIdents(this.quantifiedIdentifiers, usedNames, this.getFactory());
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind, localNames).toString(mediator, this);
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        String[] boundNamesBelow = QuantifiedUtil.catenateBoundIdentLists(boundNames, this.quantifiedIdentifiers);
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]\n" + QuantifiedHelper.getSyntaxTreeQuantifiers(boundNamesBelow, tabs + "\t", this.quantifiedIdentifiers) + this.pred.getSyntaxTree(boundNamesBelow, tabs + "\t");
    }

    @Override
    protected void isLegible(LegibilityResult result) {
        LegibilityResult resultCopy = new LegibilityResult(result);
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            decl.isLegible(resultCopy);
        }
        this.pred.isLegible(resultCopy);
        for (ASTProblem problem : resultCopy.getProblems()) {
            result.addProblem(problem);
        }
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        QuantifiedPredicate other = (QuantifiedPredicate)formula;
        return QuantifiedHelper.areEqualDecls(this.quantifiedIdentifiers, other.quantifiedIdentifiers) && this.pred.equals(other.pred);
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] boundAbove) {
        for (BoundIdentDecl ident : this.quantifiedIdentifiers) {
            ident.typeCheck(result, boundAbove);
        }
        BoundIdentDecl[] boundBelow = QuantifiedUtil.catenateBoundIdentLists(boundAbove, this.quantifiedIdentifiers);
        this.pred.typeCheck(result, boundBelow);
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
        for (BoundIdentDecl ident : this.quantifiedIdentifiers) {
            ident.solveType(unifier);
        }
        this.pred.solveType(unifier);
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
        this.pred.collectFreeIdentifiers(freeIdentSet);
    }

    public Set<String> collectNamesAbove(String[] boundNames) {
        HashSet<String> result = new HashSet<String>();
        this.pred.collectNamesAbove(result, boundNames, this.quantifiedIdentifiers.length);
        return result;
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
        int newOffset = offset + this.quantifiedIdentifiers.length;
        this.pred.collectNamesAbove(names, boundNames, newOffset);
    }

    @Override
    public boolean accept(IVisitor visitor) {
        boolean goOn = true;
        switch (this.getTag()) {
            case 851: {
                goOn = visitor.enterFORALL(this);
                break;
            }
            case 852: {
                goOn = visitor.enterEXISTS(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        block12: for (int i = 0; goOn && i < this.quantifiedIdentifiers.length; ++i) {
            goOn = this.quantifiedIdentifiers[i].accept(visitor);
            if (!goOn) continue;
            switch (this.getTag()) {
                case 851: {
                    goOn = visitor.continueFORALL(this);
                    continue block12;
                }
                case 852: {
                    goOn = visitor.continueEXISTS(this);
                    continue block12;
                }
                default: {
                    assert (false);
                    continue block12;
                }
            }
        }
        if (goOn) {
            goOn = this.pred.accept(visitor);
        }
        switch (this.getTag()) {
            case 851: {
                return visitor.exitFORALL(this);
            }
            case 852: {
                return visitor.exitEXISTS(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitQuantifiedPredicate(this);
    }

    public Predicate instantiate(Expression[] replacements, FormulaFactory formulaFactory) {
        BoundIdentSubstitution subst = new BoundIdentSubstitution(this.quantifiedIdentifiers, replacements, formulaFactory);
        Predicate newPred = (Predicate)this.pred.rewrite(subst);
        List<BoundIdentDecl> newBoundIdentDecls = subst.getNewDeclarations();
        if (newBoundIdentDecls.isEmpty()) {
            return newPred;
        }
        return formulaFactory.makeQuantifiedPredicate(this.getTag(), newBoundIdentDecls, newPred, this.getSourceLocation());
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        QuantifiedPredicate before;
        BoundIdentDecl[] newDecls = QuantifiedHelper.rewriteDecls(this.quantifiedIdentifiers, rewriter);
        int nbOfBoundIdentDecls = this.quantifiedIdentifiers.length;
        rewriter.enteringQuantifier(nbOfBoundIdentDecls);
        Predicate newPred = (Predicate)this.pred.rewrite(rewriter);
        rewriter.leavingQuantifier(nbOfBoundIdentDecls);
        FormulaFactory ff = rewriter.getFactory();
        if (rewriter.autoFlatteningMode()) {
            boolean[] used = new boolean[nbOfBoundIdentDecls];
            QuantifiedHelper.addUsedBoundIdentifiers(used, newPred);
            if (!QuantifiedHelper.areAllUsed(used)) {
                BoundIdentDeclRemover subst = new BoundIdentDeclRemover(this.quantifiedIdentifiers, used, ff);
                newPred = (Predicate)newPred.rewrite(subst);
                List<BoundIdentDecl> newDeclL = subst.getNewDeclarations();
                int size = newDeclL.size();
                if (size == 0) {
                    return newPred;
                }
                newDecls = newDeclL.toArray(new BoundIdentDecl[size]);
            }
            if (newPred.getTag() == this.getTag()) {
                QuantifiedPredicate quantChild = (QuantifiedPredicate)newPred;
                newDecls = QuantifiedUtil.catenateBoundIdentLists(newDecls, quantChild.quantifiedIdentifiers);
                newPred = quantChild.pred;
            }
        }
        if (newDecls == this.quantifiedIdentifiers && newPred == this.pred) {
            before = this;
        } else {
            SourceLocation sloc = this.getSourceLocation();
            before = ff.makeQuantifiedPredicate(this.getTag(), newDecls, newPred, sloc);
        }
        return rewriter.rewrite(this, before);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        if (acc.childrenSkipped()) {
            return;
        }
        acc.enterChildren();
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            decl.inspect(acc);
            if (acc.allSkipped()) break;
            acc.nextChild();
        }
        if (!acc.allSkipped()) {
            this.pred.inspect(acc);
        }
        acc.leaveChildren();
    }

    @Override
    public Formula<?> getChild(int index) {
        this.checkChildIndex(index);
        if (index < this.quantifiedIdentifiers.length) {
            return this.quantifiedIdentifiers[index];
        }
        return this.pred;
    }

    @Override
    public int getChildCount() {
        return this.quantifiedIdentifiers.length + 1;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        IPosition pos;
        indexes.push(0);
        for (BoundIdentDecl decl : this.quantifiedIdentifiers) {
            pos = decl.getPosition(sloc, indexes);
            if (pos != null) {
                return pos;
            }
            indexes.incrementTop();
        }
        pos = this.pred.getPosition(sloc, indexes);
        if (pos != null) {
            return pos;
        }
        indexes.pop();
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        BoundIdentDecl[] newDecls = this.quantifiedIdentifiers;
        Predicate newPred = this.pred;
        int length = this.quantifiedIdentifiers.length;
        if (index < length) {
            newDecls = (BoundIdentDecl[])this.quantifiedIdentifiers.clone();
            newDecls[index] = rewriter.rewrite(this.quantifiedIdentifiers[index]);
        } else if (index == length) {
            newPred = rewriter.rewrite(this.pred);
        } else {
            throw new IllegalArgumentException("Position is outside the formula");
        }
        return this.getFactory().makeQuantifiedPredicate(this.getTag(), newDecls, newPred, this.getSourceLocation());
    }

    @Override
    public boolean isWDStrict() {
        return false;
    }

    private static enum Operators implements IOperatorInfo<QuantifiedPredicate>
    {
        OP_FORALL("\u2200", "for all", StandardGroup.QUANTIFIED_PRED, 851),
        OP_EXISTS("\u2203", "exists", StandardGroup.QUANTIFIED_PRED, 852);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<QuantifiedPredicate> makeParser(int kind) {
            return new SubParsers.QuantifiedPredicateParser(kind, this.tag);
        }

        public IParserPrinter<QuantifiedPredicate> makeParser(int kind, String[] localNames) {
            IParserPrinter<QuantifiedPredicate> parser = this.makeParser(kind);
            ((SubParsers.IQuantifiedParser)parser).setLocalNames(localNames);
            return parser;
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

