/*
 * Decompiled with CFR 0.152.
 */
package org.eventb.core.ast;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eventb.core.ast.BoundIdentDecl;
import org.eventb.core.ast.Formula;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.FreeIdentifier;
import org.eventb.core.ast.IPosition;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.IVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.SingleRewriter;
import org.eventb.core.ast.SourceLocation;
import org.eventb.core.ast.extension.StandardGroup;
import org.eventb.internal.core.ast.FindingAccumulator;
import org.eventb.internal.core.ast.FormulaChecks;
import org.eventb.internal.core.ast.ITypeCheckingRewriter;
import org.eventb.internal.core.ast.IntStack;
import org.eventb.internal.core.ast.LegibilityResult;
import org.eventb.internal.core.ast.Position;
import org.eventb.internal.core.ast.extension.IToStringMediator;
import org.eventb.internal.core.ast.extension.KindMediator;
import org.eventb.internal.core.parser.BMath;
import org.eventb.internal.core.parser.GenParser;
import org.eventb.internal.core.parser.IOperatorInfo;
import org.eventb.internal.core.parser.IParserPrinter;
import org.eventb.internal.core.parser.SubParsers;
import org.eventb.internal.core.typecheck.TypeCheckResult;
import org.eventb.internal.core.typecheck.TypeUnifier;

public class LiteralPredicate
extends Predicate {
    private static final int FIRST_TAG = 610;
    private static final String BTRUE_ID = "B True";
    private static final String BFALSE_ID = "B False";
    public static final int TAGS_LENGTH = Operators.values().length;

    public static void init(BMath grammar) {
        try {
            for (Operators operInfo : Operators.values()) {
                grammar.addOperator(operInfo);
            }
        }
        catch (GenParser.OverrideException e) {
            e.printStackTrace();
        }
    }

    protected LiteralPredicate(int tag, SourceLocation location, FormulaFactory ff) {
        super(tag, ff, location, 0);
        FormulaChecks.ensureTagInRange(tag, 610, TAGS_LENGTH);
        this.setPredicateVariableCache(new Formula[0]);
        this.synthesizeType();
    }

    @Override
    protected void synthesizeType() {
        this.freeIdents = NO_FREE_IDENT;
        this.boundIdents = NO_BOUND_IDENT;
        this.typeChecked = true;
    }

    @Override
    protected void isLegible(LegibilityResult result) {
    }

    @Override
    protected boolean equalsInternal(Formula<?> formula) {
        return true;
    }

    @Override
    protected void typeCheck(TypeCheckResult result, BoundIdentDecl[] quantifiedIdentifiers) {
    }

    @Override
    protected void solveChildrenTypes(TypeUnifier unifier) {
    }

    private String getOperatorImage() {
        return this.getOperator().getImage();
    }

    private Operators getOperator() {
        return Operators.values()[this.getTag() - 610];
    }

    @Override
    protected int getKind(KindMediator mediator) {
        return mediator.getKind(this.getOperatorImage());
    }

    @Override
    protected void toString(IToStringMediator mediator) {
        Operators operator = this.getOperator();
        int kind = mediator.getKind();
        operator.makeParser(kind).toString(mediator, this);
    }

    @Override
    protected String getSyntaxTree(String[] boundNames, String tabs) {
        return tabs + this.getClass().getSimpleName() + " [" + this.getOperatorImage() + "]" + "\n";
    }

    @Override
    protected void collectFreeIdentifiers(LinkedHashSet<FreeIdentifier> freeIdentSet) {
    }

    @Override
    protected void collectNamesAbove(Set<String> names, String[] boundNames, int offset) {
    }

    @Override
    public boolean accept(IVisitor visitor) {
        switch (this.getTag()) {
            case 610: {
                return visitor.visitBTRUE(this);
            }
            case 611: {
                return visitor.visitBFALSE(this);
            }
        }
        return true;
    }

    @Override
    public void accept(ISimpleVisitor visitor) {
        visitor.visitLiteralPredicate(this);
    }

    @Override
    protected Predicate rewrite(ITypeCheckingRewriter rewriter) {
        return rewriter.rewrite(this);
    }

    @Override
    protected final <F> void inspect(FindingAccumulator<F> acc) {
        acc.inspect(this);
        acc.childrenSkipped();
    }

    @Override
    public Formula<?> getChild(int index) {
        throw LiteralPredicate.invalidIndex(index);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    protected IPosition getDescendantPos(SourceLocation sloc, IntStack indexes) {
        return new Position(indexes);
    }

    @Override
    protected Predicate rewriteChild(int index, SingleRewriter rewriter) {
        throw new IllegalArgumentException("Position is outside the formula");
    }

    @Override
    public boolean isWDStrict() {
        return true;
    }

    private static enum Operators implements IOperatorInfo<LiteralPredicate>
    {
        OP_BTRUE("\u22a4", "B True", StandardGroup.ATOMIC_PRED, 610),
        OP_BFALSE("\u22a5", "B False", StandardGroup.ATOMIC_PRED, 611);

        private final String image;
        private final String id;
        private final String groupId;
        private final int tag;

        private Operators(String image, String id, StandardGroup group, int tag) {
            this.image = image;
            this.id = id;
            this.groupId = group.getId();
            this.tag = tag;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public IParserPrinter<LiteralPredicate> makeParser(int kind) {
            return new SubParsers.LiteralPredicateParser(kind, this.tag);
        }

        @Override
        public boolean isSpaced() {
            return false;
        }
    }
}

