/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.handler;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.HandshakeData;
import com.corundumstudio.socketio.Transport;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.ClientsBox;
import com.corundumstudio.socketio.handler.EncoderHandler;
import com.corundumstudio.socketio.handler.TransportState;
import com.corundumstudio.socketio.messages.OutPacketMessage;
import com.corundumstudio.socketio.namespace.Namespace;
import com.corundumstudio.socketio.protocol.Packet;
import com.corundumstudio.socketio.protocol.PacketType;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.SchedulerKey;
import com.corundumstudio.socketio.store.Store;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.transport.NamespaceClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHead {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final AttributeKey<ClientHead> CLIENT = AttributeKey.valueOf((String)"client");
    private final AtomicBoolean disconnected = new AtomicBoolean();
    private final Map<Namespace, NamespaceClient> namespaceClients = PlatformDependent.newConcurrentHashMap();
    private final Map<Transport, TransportState> channels = new HashMap<Transport, TransportState>();
    private final HandshakeData handshakeData;
    private final UUID sessionId;
    private final Store store;
    private final DisconnectableHub disconnectableHub;
    private final AckManager ackManager;
    private ClientsBox clientsBox;
    private final CancelableScheduler disconnectScheduler;
    private final Configuration configuration;
    private Packet lastBinaryPacket;
    private volatile Transport currentTransport;

    public ClientHead(UUID sessionId, AckManager ackManager, DisconnectableHub disconnectable, StoreFactory storeFactory, HandshakeData handshakeData, ClientsBox clientsBox, Transport transport, CancelableScheduler disconnectScheduler, Configuration configuration) {
        this.sessionId = sessionId;
        this.ackManager = ackManager;
        this.disconnectableHub = disconnectable;
        this.store = storeFactory.createStore(sessionId);
        this.handshakeData = handshakeData;
        this.clientsBox = clientsBox;
        this.currentTransport = transport;
        this.disconnectScheduler = disconnectScheduler;
        this.configuration = configuration;
        this.channels.put(Transport.POLLING, new TransportState());
        this.channels.put(Transport.WEBSOCKET, new TransportState());
    }

    public void bindChannel(Channel channel, Transport transport) {
        this.log.debug("binding channel: {} to transport: {}", (Object)channel, (Object)transport);
        TransportState state = this.channels.get((Object)transport);
        Channel prevChannel = state.update(channel);
        if (prevChannel != null) {
            this.clientsBox.remove(prevChannel);
        }
        this.clientsBox.add(channel, this);
        this.sendPackets(transport, channel);
    }

    public String getOrigin() {
        return this.handshakeData.getSingleHeader("Origin");
    }

    public ChannelFuture send(Packet packet) {
        return this.send(packet, this.getCurrentTransport());
    }

    public void cancelPingTimeout() {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.PING_TIMEOUT, this.sessionId);
        this.disconnectScheduler.cancel(key);
    }

    public void schedulePingTimeout() {
        SchedulerKey key = new SchedulerKey(SchedulerKey.Type.PING_TIMEOUT, this.sessionId);
        this.disconnectScheduler.schedule(key, new Runnable(){

            @Override
            public void run() {
                ClientHead client = ClientHead.this.clientsBox.get(ClientHead.this.sessionId);
                if (client != null) {
                    client.onChannelDisconnect();
                    ClientHead.this.log.debug("{} removed due to ping timeout", (Object)ClientHead.this.sessionId);
                }
            }
        }, this.configuration.getPingTimeout() + this.configuration.getPingInterval(), TimeUnit.MILLISECONDS);
    }

    public ChannelFuture send(Packet packet, Transport transport) {
        TransportState state = this.channels.get((Object)transport);
        state.getPacketsQueue().add(packet);
        Channel channel = state.getChannel();
        if (channel == null || transport == Transport.POLLING && channel.attr(EncoderHandler.WRITE_ONCE).get() != null) {
            return null;
        }
        return this.sendPackets(transport, channel);
    }

    private ChannelFuture sendPackets(Transport transport, Channel channel) {
        return channel.writeAndFlush((Object)new OutPacketMessage(this, transport));
    }

    public void removeNamespaceClient(NamespaceClient client) {
        this.namespaceClients.remove(client.getNamespace());
        if (this.namespaceClients.isEmpty()) {
            this.disconnectableHub.onDisconnect(this);
        }
    }

    public NamespaceClient getChildClient(Namespace namespace) {
        return this.namespaceClients.get(namespace);
    }

    public NamespaceClient addNamespaceClient(Namespace namespace) {
        NamespaceClient client = new NamespaceClient(this, namespace);
        this.namespaceClients.put(namespace, client);
        return client;
    }

    public Set<Namespace> getNamespaces() {
        return this.namespaceClients.keySet();
    }

    public boolean isConnected() {
        return !this.disconnected.get();
    }

    public void onChannelDisconnect() {
        this.cancelPingTimeout();
        this.disconnected.set(true);
        for (NamespaceClient client : this.namespaceClients.values()) {
            client.onDisconnect();
        }
        for (TransportState state : this.channels.values()) {
            if (state.getChannel() == null) continue;
            this.clientsBox.remove(state.getChannel());
        }
    }

    public HandshakeData getHandshakeData() {
        return this.handshakeData;
    }

    public AckManager getAckManager() {
        return this.ackManager;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public SocketAddress getRemoteAddress() {
        return this.handshakeData.getAddress();
    }

    public void disconnect() {
        ChannelFuture future = this.send(new Packet(PacketType.DISCONNECT));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        this.onChannelDisconnect();
    }

    public boolean isChannelOpen() {
        for (TransportState state : this.channels.values()) {
            if (state.getChannel() == null || !state.getChannel().isActive()) continue;
            return true;
        }
        return false;
    }

    public Store getStore() {
        return this.store;
    }

    public boolean isTransportChannel(Channel channel, Transport transport) {
        TransportState state = this.channels.get((Object)transport);
        if (state.getChannel() == null) {
            return false;
        }
        return state.getChannel().equals(channel);
    }

    public void upgradeCurrentTransport(Transport currentTransport) {
        TransportState state = this.channels.get((Object)currentTransport);
        for (Map.Entry<Transport, TransportState> entry : this.channels.entrySet()) {
            if (entry.getKey().equals((Object)currentTransport)) continue;
            Queue<Packet> queue = entry.getValue().getPacketsQueue();
            state.setPacketsQueue(queue);
            this.sendPackets(currentTransport, state.getChannel());
            this.currentTransport = currentTransport;
            this.log.debug("Transport upgraded to: {} for: {}", (Object)currentTransport, (Object)this.sessionId);
            break;
        }
    }

    public Transport getCurrentTransport() {
        return this.currentTransport;
    }

    public Queue<Packet> getPacketsQueue(Transport transport) {
        return this.channels.get((Object)transport).getPacketsQueue();
    }

    public void setLastBinaryPacket(Packet lastBinaryPacket) {
        this.lastBinaryPacket = lastBinaryPacket;
    }

    public Packet getLastBinaryPacket() {
        return this.lastBinaryPacket;
    }
}

