/*
 * Decompiled with CFR 0.152.
 */
package tlc2.value;

import tlc2.TLCGlobals;
import tlc2.value.Enumerable;
import tlc2.value.MVPerm;
import tlc2.value.ModelValue;
import tlc2.value.RecordValue;
import tlc2.value.SetEnumValue;
import tlc2.value.Value;
import tlc2.value.ValueEnumeration;
import tlc2.value.ValueExcept;
import util.Assert;
import util.UniqueString;

public class SetOfRcdsValue
extends Value
implements Enumerable {
    public UniqueString[] names;
    public Value[] values;
    protected SetEnumValue rcdSet;

    public SetOfRcdsValue(UniqueString[] names, Value[] values, boolean isNorm) {
        this.names = names;
        this.values = values;
        this.rcdSet = null;
        if (!isNorm) {
            this.sortByNames();
        }
    }

    @Override
    public final byte getKind() {
        return 14;
    }

    @Override
    public final int compareTo(Object obj) {
        this.convertAndCache();
        return this.rcdSet.compareTo(obj);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SetOfRcdsValue) {
            SetOfRcdsValue rcds = (SetOfRcdsValue)obj;
            boolean isEmpty1 = this.isEmpty();
            if (isEmpty1) {
                return rcds.isEmpty();
            }
            if (rcds.isEmpty()) {
                return isEmpty1;
            }
            if (this.names.length != rcds.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i].equals(rcds.names[i]) && this.values[i].equals(rcds.values[i])) continue;
                return false;
            }
            return true;
        }
        this.convertAndCache();
        return this.rcdSet.equals(obj);
    }

    @Override
    public final boolean member(Value elem) {
        RecordValue rcd = RecordValue.convert(elem);
        if (rcd == null) {
            if (elem instanceof ModelValue) {
                return ((ModelValue)elem).modelValueMember(this);
            }
            Assert.fail("Attempted to check if non-record\n" + elem + "\nis in the" + " set of records:\n" + SetOfRcdsValue.ppr(this.toString()));
        }
        rcd.normalize();
        if (this.names.length != rcd.names.length) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equals(rcd.names[i]) && this.values[i].member(rcd.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isFinite() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].isFinite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Value takeExcept(ValueExcept ex) {
        if (ex.idx < ex.path.length) {
            Assert.fail("Attempted to apply EXCEPT to the set of records:\n" + SetOfRcdsValue.ppr(this.toString()));
        }
        return ex.value;
    }

    @Override
    public final Value takeExcept(ValueExcept[] exs) {
        if (exs.length != 0) {
            Assert.fail("Attempted to apply EXCEPT to the set of records:\n" + SetOfRcdsValue.ppr(this.toString()));
        }
        return this;
    }

    @Override
    public final int size() {
        long sz = 1L;
        for (int i = 0; i < this.values.length; ++i) {
            if ((sz *= (long)this.values[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
            Assert.fail(2178, "the number of elements in:\n" + SetOfRcdsValue.ppr(this.toString()));
        }
        return (int)sz;
    }

    @Override
    public final boolean isNormalized() {
        if (this.rcdSet == null || this.rcdSet == DummyEnum) {
            for (int i = 0; i < this.names.length; ++i) {
                if (this.values[i].isNormalized()) continue;
                return false;
            }
            return true;
        }
        return this.rcdSet.isNormalized();
    }

    @Override
    public final void normalize() {
        if (this.rcdSet == null || this.rcdSet == DummyEnum) {
            for (int i = 0; i < this.names.length; ++i) {
                this.values[i].normalize();
            }
        } else {
            this.rcdSet.normalize();
        }
    }

    private final void sortByNames() {
        int i;
        for (i = 1; i < this.names.length; ++i) {
            int cmp = this.names[0].compareTo(this.names[i]);
            if (cmp == 0) {
                Assert.fail("Field name " + this.names[0] + " occurs multiple times" + " in set of records.");
                continue;
            }
            if (cmp <= 0) continue;
            UniqueString ts = this.names[0];
            this.names[0] = this.names[i];
            this.names[i] = ts;
            Value tv = this.values[0];
            this.values[0] = this.values[i];
            this.values[i] = tv;
        }
        for (i = 2; i < this.names.length; ++i) {
            int cmp;
            int j = i;
            UniqueString st = this.names[i];
            Value val = this.values[i];
            while ((cmp = st.compareTo(this.names[j - 1])) < 0) {
                this.names[j] = this.names[j - 1];
                this.values[j] = this.values[j - 1];
                --j;
            }
            if (cmp == 0) {
                Assert.fail("Field name " + this.names[i] + " occurs multiple times" + " in set of records.");
            }
            this.names[j] = st;
            this.values[j] = val;
        }
    }

    @Override
    public final boolean isDefined() {
        boolean isDefined = true;
        for (int i = 0; i < this.values.length; ++i) {
            isDefined = isDefined && this.values[i].isDefined();
        }
        return isDefined;
    }

    @Override
    public final Value deepCopy() {
        return this;
    }

    @Override
    public final boolean assignable(Value val) {
        return this.equals(val);
    }

    @Override
    public final long fingerPrint(long fp) {
        this.convertAndCache();
        return this.rcdSet.fingerPrint(fp);
    }

    @Override
    public final Value permute(MVPerm perm) {
        this.convertAndCache();
        return this.rcdSet.permute(perm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void convertAndCache() {
        if (this.rcdSet == null) {
            this.rcdSet = SetEnumValue.convert(this);
        } else if (this.rcdSet == DummyEnum) {
            SetEnumValue val = null;
            SetOfRcdsValue setOfRcdsValue = this;
            synchronized (setOfRcdsValue) {
                if (this.rcdSet == DummyEnum) {
                    val = SetEnumValue.convert(this);
                    val.deepNormalize();
                }
            }
            setOfRcdsValue = this;
            synchronized (setOfRcdsValue) {
                if (this.rcdSet == DummyEnum) {
                    this.rcdSet = val;
                }
            }
        }
    }

    @Override
    public final StringBuffer toString(StringBuffer sb, int offset) {
        boolean unlazy = expand;
        try {
            if (unlazy) {
                long sz = 1L;
                for (int i = 0; i < this.values.length; ++i) {
                    if ((sz *= (long)this.values[i].size()) >= Integer.MIN_VALUE && sz <= Integer.MAX_VALUE) continue;
                    unlazy = false;
                    break;
                }
                unlazy = sz < (long)TLCGlobals.enumBound;
            }
        }
        catch (Throwable e) {
            unlazy = false;
        }
        if (unlazy) {
            SetEnumValue val = SetEnumValue.convert(this);
            return ((Value)val).toString(sb, offset);
        }
        sb.append("[");
        int len = this.names.length;
        if (len != 0) {
            sb.append(this.names[0] + ": ");
            this.values[0].toString(sb, offset);
        }
        for (int i = 1; i < len; ++i) {
            sb.append(", ");
            sb.append(this.names[i] + ": ");
            this.values[i].toString(sb, offset);
        }
        sb.append("]");
        return sb;
    }

    @Override
    public final ValueEnumeration elements() {
        if (this.rcdSet == null || this.rcdSet == DummyEnum) {
            return new Enumerator();
        }
        return this.rcdSet.elements();
    }

    final class Enumerator
    implements ValueEnumeration {
        private ValueEnumeration[] enums;
        private Value[] currentElems;
        private boolean isDone;

        public Enumerator() {
            this.enums = new ValueEnumeration[SetOfRcdsValue.this.values.length];
            this.currentElems = new Value[SetOfRcdsValue.this.values.length];
            this.isDone = false;
            for (int i = 0; i < SetOfRcdsValue.this.values.length; ++i) {
                if (SetOfRcdsValue.this.values[i] instanceof Enumerable) {
                    this.enums[i] = ((Enumerable)((Object)SetOfRcdsValue.this.values[i])).elements();
                    this.currentElems[i] = this.enums[i].nextElement();
                    if (this.currentElems[i] != null) continue;
                    this.enums = null;
                    this.isDone = true;
                    break;
                }
                Assert.fail("Attempted to enumerate a set of the form [l1 : v1, ..., ln : vn],\nbut can't enumerate the value of the `" + SetOfRcdsValue.this.names[i] + "' field:\n" + Value.ppr(SetOfRcdsValue.this.values[i].toString()));
            }
        }

        @Override
        public final void reset() {
            if (this.enums != null) {
                for (int i = 0; i < this.enums.length; ++i) {
                    this.enums[i].reset();
                    this.currentElems[i] = this.enums[i].nextElement();
                }
                this.isDone = false;
            }
        }

        @Override
        public final Value nextElement() {
            int i;
            if (this.isDone) {
                return null;
            }
            Value[] elems = new Value[this.currentElems.length];
            for (i = 0; i < elems.length; ++i) {
                elems[i] = this.currentElems[i];
            }
            for (i = elems.length - 1; i >= 0; --i) {
                this.currentElems[i] = this.enums[i].nextElement();
                if (this.currentElems[i] != null) break;
                if (i == 0) {
                    this.isDone = true;
                    break;
                }
                this.enums[i].reset();
                this.currentElems[i] = this.enums[i].nextElement();
            }
            return new RecordValue(SetOfRcdsValue.this.names, elems, true);
        }
    }
}

