/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.liveness;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import tlc2.TLCGlobals;
import tlc2.output.MP;
import tlc2.output.StatePrinter;
import tlc2.tool.EvalException;
import tlc2.tool.TLCState;
import tlc2.tool.TLCStateInfo;
import tlc2.tool.liveness.AbstractDiskGraph;
import tlc2.tool.liveness.DiskGraph;
import tlc2.tool.liveness.GraphNode;
import tlc2.tool.liveness.ILiveCheck;
import tlc2.tool.liveness.ILiveChecker;
import tlc2.tool.liveness.LNEven;
import tlc2.tool.liveness.OrderOfSolution;
import tlc2.tool.liveness.PossibleErrorModel;
import tlc2.tool.liveness.TBPar;
import tlc2.tool.liveness.TableauNodePtrTable;
import tlc2.util.IdThread;
import tlc2.util.LongVec;
import tlc2.util.MemIntQueue;
import tlc2.util.MemIntStack;
import tlc2.util.statistics.BucketStatistics;
import tlc2.util.statistics.IBucketStatistics;

public class LiveWorker
extends IdThread {
    public static final IBucketStatistics STATS = new BucketStatistics("Histogram SCC sizes", LiveWorker.class.getPackage().getName(), "StronglyConnectedComponent sizes");
    private static int errFoundByThread = -1;
    private static Object workerLock = new Object();
    private OrderOfSolution oos = null;
    private AbstractDiskGraph dg = null;
    private PossibleErrorModel pem = null;
    private final ILiveCheck liveCheck;
    private final BlockingQueue<ILiveChecker> queue;

    public LiveWorker(int id, ILiveCheck liveCheck, BlockingQueue<ILiveChecker> queue) {
        super(id);
        this.liveCheck = liveCheck;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasErrFound() {
        Object object = workerLock;
        synchronized (object) {
            return errFoundByThread != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setErrFound() {
        Object object = workerLock;
        synchronized (object) {
            if (errFoundByThread == -1) {
                errFoundByThread = this.myGetId();
                return true;
            }
            return errFoundByThread == this.myGetId();
            {
            }
        }
    }

    private final void checkSccs() throws IOException {
        this.dg.makeNodePtrTbl();
        MemIntQueue nodeQueue = new MemIntQueue(this.liveCheck.getMetaDir(), "root");
        LongVec initNodes = this.dg.getInitNodes();
        int numOfInits = initNodes.size();
        for (int j = 0; j < numOfInits; j += 2) {
            int tidx;
            long state = initNodes.elementAt(j);
            long ptr = this.dg.getLink(state, tidx = (int)initNodes.elementAt(j + 1));
            if (ptr < 0L) continue;
            nodeQueue.enqueueLong(state);
            nodeQueue.enqueueInt(tidx);
            nodeQueue.enqueueLong(ptr);
        }
        int[] eaaction = this.pem.EAAction;
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        MemIntStack dfsStack = new MemIntStack(this.liveCheck.getMetaDir(), "dfs");
        MemIntStack comStack = new MemIntStack(this.liveCheck.getMetaDir(), "com");
        while (nodeQueue.length() > 0) {
            long state = nodeQueue.dequeueLong();
            int tidx = nodeQueue.dequeueInt();
            long loc = nodeQueue.dequeueLong();
            dfsStack.reset();
            dfsStack.pushLong(state);
            dfsStack.pushInt(tidx);
            dfsStack.pushLong(loc);
            dfsStack.pushLong(0x4000000000000000L);
            long newLink = 0x4000000000000000L;
            while (dfsStack.size() > 2) {
                long lowLink = dfsStack.popLong();
                long curLoc = dfsStack.popLong();
                int curTidx = dfsStack.popInt();
                long curState = dfsStack.popLong();
                if (curLoc < 0L) {
                    boolean isOK;
                    long curLink = this.dg.getLink(curState, curTidx);
                    if (curLink == lowLink && !(isOK = this.checkComponent(curState, curTidx, comStack))) {
                        return;
                    }
                    long plowLink = dfsStack.popLong();
                    if (lowLink < plowLink) {
                        plowLink = lowLink;
                    }
                    dfsStack.pushLong(plowLink);
                    continue;
                }
                long link = this.dg.putLink(curState, curTidx, newLink);
                if (link == -1L) {
                    long nextLowLink;
                    dfsStack.pushLong(lowLink);
                    dfsStack.pushLong(curState);
                    dfsStack.pushInt(curTidx);
                    dfsStack.pushLong(-1L);
                    comStack.pushLong(curLoc);
                    comStack.pushInt(curTidx);
                    comStack.pushLong(curState);
                    GraphNode gnode = this.dg.getNode(curState, curTidx, curLoc);
                    int succCnt = gnode.succSize();
                    ++newLink;
                    for (int i = 0; i < succCnt; ++i) {
                        int nextTidx;
                        long nextState = gnode.getStateFP(i);
                        long nextLink = this.dg.getLink(nextState, nextTidx = gnode.getTidx(i));
                        if (nextLink < 0L) continue;
                        if (gnode.getCheckAction(slen, alen, i, eaaction)) {
                            if (DiskGraph.isFilePointer(nextLink)) {
                                dfsStack.pushLong(nextState);
                                dfsStack.pushInt(nextTidx);
                                dfsStack.pushLong(nextLink);
                                continue;
                            }
                            if (nextLink >= nextLowLink) continue;
                            nextLowLink = nextLink;
                            continue;
                        }
                        if (!DiskGraph.isFilePointer(nextLink)) continue;
                        nodeQueue.enqueueLong(nextState);
                        nodeQueue.enqueueInt(nextTidx);
                        nodeQueue.enqueueLong(nextLink);
                    }
                    dfsStack.pushLong(nextLowLink);
                    continue;
                }
                if (link < lowLink) {
                    lowLink = link;
                }
                dfsStack.pushLong(lowLink);
            }
        }
    }

    private boolean checkComponent(long state, int tidx, MemIntStack comStack) throws IOException {
        int i;
        long state1 = comStack.popLong();
        int tidx1 = comStack.popInt();
        long loc1 = comStack.popLong();
        if (state1 == state && tidx1 == tidx && !this.isStuttering(state1, tidx1, loc1)) {
            this.dg.setMaxLink(state, tidx);
            return true;
        }
        TableauNodePtrTable com = new TableauNodePtrTable(128);
        while (true) {
            com.put(state1, tidx1, loc1);
            this.dg.setMaxLink(state1, tidx1);
            if (state == state1 && tidx == tidx1) break;
            state1 = comStack.popLong();
            tidx1 = comStack.popInt();
            loc1 = comStack.popLong();
        }
        STATS.addSample(com.size());
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        int aeslen = this.pem.AEState.length;
        int aealen = this.pem.AEAction.length;
        int plen = this.oos.getPromises().length;
        boolean[] AEStateRes = new boolean[aeslen];
        boolean[] AEActionRes = new boolean[aealen];
        boolean[] promiseRes = new boolean[plen];
        int tsz = com.getSize();
        for (int ci = 0; ci < tsz; ++ci) {
            int[] nodes = com.getNodesByLoc(ci);
            if (nodes == null) continue;
            state1 = TableauNodePtrTable.getKey(nodes);
            for (int nidx = 2; nidx < nodes.length; nidx += com.getElemLength()) {
                int i2;
                tidx1 = TableauNodePtrTable.getTidx(nodes, nidx);
                loc1 = TableauNodePtrTable.getElem(nodes, nidx);
                GraphNode curNode = this.dg.getNode(state1, tidx1, loc1);
                for (int i3 = 0; i3 < aeslen; ++i3) {
                    if (AEStateRes[i3]) continue;
                    int idx = this.pem.AEState[i3];
                    AEStateRes[i3] = curNode.getCheckState(idx);
                }
                int succCnt = curNode.succSize();
                for (i2 = 0; i2 < succCnt; ++i2) {
                    int nextTidx;
                    long nextState = curNode.getStateFP(i2);
                    if (com.getLoc(nextState, nextTidx = curNode.getTidx(i2)) == -1) continue;
                    for (int j = 0; j < aealen; ++j) {
                        if (AEActionRes[j]) continue;
                        int idx = this.pem.AEAction[j];
                        AEActionRes[j] = curNode.getCheckAction(slen, alen, i2, idx);
                    }
                }
                for (i2 = 0; i2 < plen; ++i2) {
                    LNEven promise = this.oos.getPromises()[i2];
                    TBPar par = curNode.getTNode(this.oos.getTableau()).getPar();
                    if (!par.isFulfilling(promise)) continue;
                    promiseRes[i2] = true;
                }
            }
        }
        for (i = 0; i < aeslen; ++i) {
            if (AEStateRes[i]) continue;
            return true;
        }
        for (i = 0; i < aealen; ++i) {
            if (AEActionRes[i]) continue;
            return true;
        }
        for (i = 0; i < plen; ++i) {
            if (promiseRes[i]) continue;
            return true;
        }
        if (this.setErrFound()) {
            this.printTrace(state, tidx, com);
        }
        return false;
    }

    private boolean isStuttering(long state, int tidx, long loc) throws IOException {
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        GraphNode gnode = this.dg.getNode(state, tidx, loc);
        int succCnt = gnode.succSize();
        for (int i = 0; i < succCnt; ++i) {
            long nextState = gnode.getStateFP(i);
            int nextTidx = gnode.getTidx(i);
            if (state != nextState || tidx != nextTidx) continue;
            return gnode.getCheckAction(slen, alen, i, this.pem.EAAction);
        }
        return false;
    }

    private void printTrace(long state, int tidx, TableauNodePtrTable nodeTbl) throws IOException {
        int i;
        MP.printError(2116);
        MP.printError(2264);
        int slen = this.oos.getCheckState().length;
        int alen = this.oos.getCheckAction().length;
        boolean[] AEStateRes = new boolean[this.pem.AEState.length];
        boolean[] AEActionRes = new boolean[this.pem.AEAction.length];
        boolean[] promiseRes = new boolean[this.oos.getPromises().length];
        int cnt = AEStateRes.length + AEActionRes.length + promiseRes.length;
        MemIntStack cycleStack = new MemIntStack(this.liveCheck.getMetaDir(), "cycle");
        int[] nodes = nodeTbl.getNodes(state);
        int tloc = nodeTbl.getIdx(nodes, tidx);
        long ptr = TableauNodePtrTable.getElem(nodes, tloc);
        TableauNodePtrTable.setSeen(nodes, tloc);
        GraphNode curNode = this.dg.getNode(state, tidx, ptr);
        block0: while (cnt > 0) {
            int cnt0 = cnt;
            while (true) {
                int i2;
                for (i2 = 0; i2 < this.pem.AEState.length; ++i2) {
                    int idx = this.pem.AEState[i2];
                    if (AEStateRes[i2] || !curNode.getCheckState(idx)) continue;
                    AEStateRes[i2] = true;
                    --cnt;
                }
                for (i2 = 0; i2 < this.oos.getPromises().length; ++i2) {
                    LNEven promise = this.oos.getPromises()[i2];
                    TBPar par = curNode.getTNode(this.oos.getTableau()).getPar();
                    if (promiseRes[i2] || !par.isFulfilling(promise)) continue;
                    promiseRes[i2] = true;
                    --cnt;
                }
                if (cnt <= 0) continue block0;
                long nextState1 = 0L;
                long nextState2 = 0L;
                int nextTidx1 = 0;
                int nextTidx2 = 0;
                int tloc1 = -1;
                int tloc2 = -1;
                int[] nodes1 = null;
                int[] nodes2 = null;
                boolean hasUnvisitedSucc = false;
                int cnt1 = cnt;
                int succCnt = curNode.succSize();
                for (i = 0; i < succCnt; ++i) {
                    long nextState = curNode.getStateFP(i);
                    int nextTidx = curNode.getTidx(i);
                    nodes = nodeTbl.getNodes(nextState);
                    if (nodes != null && (tloc = nodeTbl.getIdx(nodes, nextTidx)) != -1) {
                        nextState1 = nextState;
                        nextTidx1 = nextTidx;
                        tloc1 = tloc;
                        nodes1 = nodes;
                        for (int j = 0; j < this.pem.AEAction.length; ++j) {
                            int idx = this.pem.AEAction[j];
                            if (AEActionRes[j] || !curNode.getCheckAction(slen, alen, i, idx)) continue;
                            AEActionRes[j] = true;
                            --cnt;
                        }
                    }
                    if (cnt < cnt1) {
                        cycleStack.pushInt(curNode.tindex);
                        cycleStack.pushLong(curNode.stateFP);
                        long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                        curNode = this.dg.getNode(nextState, nextTidx, nextPtr);
                        nodeTbl.resetElems();
                        continue block0;
                    }
                    if (nodes == null || tloc == -1 || TableauNodePtrTable.isSeen(nodes, tloc)) continue;
                    hasUnvisitedSucc = true;
                    nextState2 = nextState;
                    nextTidx2 = nextTidx;
                    tloc2 = tloc;
                    nodes2 = nodes;
                }
                if (cnt < cnt0) {
                    cycleStack.pushInt(curNode.tindex);
                    cycleStack.pushLong(curNode.stateFP);
                    long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes1, tloc1));
                    curNode = this.dg.getNode(nextState1, nextTidx1, nextPtr);
                    nodeTbl.resetElems();
                    continue block0;
                }
                block6: while (!hasUnvisitedSucc) {
                    long curState = cycleStack.popLong();
                    int curTidx = cycleStack.popInt();
                    long curPtr = TableauNodePtrTable.getPtr(nodeTbl.get(curState, curTidx));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    succCnt = curNode.succSize();
                    for (int i3 = 0; i3 < succCnt; ++i3) {
                        nextState2 = curNode.getStateFP(i3);
                        nextTidx2 = curNode.getTidx(i3);
                        nodes2 = nodeTbl.getNodes(nextState2);
                        if (nodes2 == null || (tloc2 = nodeTbl.getIdx(nodes2, nextTidx2)) == -1 || TableauNodePtrTable.isSeen(nodes2, tloc2)) continue;
                        hasUnvisitedSucc = true;
                        continue block6;
                    }
                }
                cycleStack.pushInt(curNode.tindex);
                cycleStack.pushLong(curNode.stateFP);
                long nextPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes2, tloc2));
                curNode = this.dg.getNode(nextState2, nextTidx2, nextPtr);
                TableauNodePtrTable.setSeen(nodes2, tloc2);
            }
        }
        nodeTbl.resetElems();
        LongVec postfix = new LongVec(16);
        long startState = curNode.stateFP;
        if (startState != state) {
            MemIntQueue queue = new MemIntQueue(this.liveCheck.getMetaDir(), null);
            long curState = startState;
            int ploc = -1;
            int curLoc = nodeTbl.getNodesLoc(curState);
            nodes = nodeTbl.getNodesByLoc(curLoc);
            TableauNodePtrTable.setSeen(nodes);
            block8: while (true) {
                tloc = TableauNodePtrTable.startLoc(nodes);
                while (tloc != -1) {
                    int curTidx = TableauNodePtrTable.getTidx(nodes, tloc);
                    long curPtr = TableauNodePtrTable.getPtr(TableauNodePtrTable.getElem(nodes, tloc));
                    curNode = this.dg.getNode(curState, curTidx, curPtr);
                    int succCnt = curNode.succSize();
                    for (int j = 0; j < succCnt; ++j) {
                        long nextState = curNode.getStateFP(j);
                        if (nextState == state) {
                            while (curState != startState) {
                                postfix.addElement(curState);
                                nodes = nodeTbl.getNodesByLoc(ploc);
                                curState = TableauNodePtrTable.getKey(nodes);
                                ploc = TableauNodePtrTable.getParent(nodes);
                            }
                            postfix.addElement(startState);
                            break block8;
                        }
                        int[] nodes1 = nodeTbl.getNodes(nextState);
                        if (nodes1 == null || TableauNodePtrTable.isSeen(nodes1)) continue;
                        TableauNodePtrTable.setSeen(nodes1);
                        queue.enqueueLong(nextState);
                        queue.enqueueInt(curLoc);
                    }
                    tloc = TableauNodePtrTable.nextLoc(nodes, tloc);
                }
                TableauNodePtrTable.setParent(nodes, ploc);
                curState = queue.dequeueLong();
                ploc = queue.dequeueInt();
                curLoc = nodeTbl.getNodesLoc(curState);
                nodes = nodeTbl.getNodesByLoc(curLoc);
            }
        }
        int stateNum = 0;
        LongVec prefix = this.dg.getPath(state, tidx);
        int plen = prefix.size();
        TLCStateInfo[] states = new TLCStateInfo[plen];
        long fp = prefix.elementAt(plen - 1);
        TLCStateInfo sinfo = this.liveCheck.getTool().getState(fp);
        if (sinfo == null) {
            throw new EvalException(2123);
        }
        states[stateNum++] = sinfo;
        for (int i4 = plen - 2; i4 >= 0; --i4) {
            long curFP = prefix.elementAt(i4);
            if (curFP == fp) continue;
            sinfo = this.liveCheck.getTool().getState(curFP, sinfo.state);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            states[stateNum++] = sinfo;
            fp = curFP;
        }
        TLCState lastState = null;
        for (int i5 = 0; i5 < stateNum; ++i5) {
            StatePrinter.printState(states[i5], lastState, i5 + 1);
            lastState = states[i5].state;
        }
        int cyclePos = stateNum;
        long cycleFP = fp;
        while (cycleStack.size() > 0) {
            postfix.addElement(cycleStack.popLong());
            cycleStack.popInt();
        }
        for (i = postfix.size() - 1; i >= 0; --i) {
            long curFP = postfix.elementAt(i);
            if (curFP == fp) continue;
            sinfo = this.liveCheck.getTool().getState(curFP, sinfo.state);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            StatePrinter.printState(sinfo, lastState, ++stateNum);
            lastState = sinfo.state;
            fp = curFP;
        }
        if (fp == cycleFP) {
            StatePrinter.printStutteringState(++stateNum);
        } else {
            sinfo = this.liveCheck.getTool().getState(cycleFP, sinfo.state);
            if (sinfo == null) {
                throw new EvalException(2117);
            }
            if (TLCGlobals.tool) {
                MP.printState(2122, new String[]{"" + cyclePos}, (TLCState)null, -1);
            } else {
                MP.printMessage(2122, "" + cyclePos);
            }
        }
    }

    @Override
    public final void run() {
        try {
            ILiveChecker checker;
            while ((checker = (ILiveChecker)this.queue.poll()) != null && !LiveWorker.hasErrFound()) {
                this.oos = checker.getSolution();
                this.dg = checker.getDiskGraph();
                this.dg.createCache();
                PossibleErrorModel[] pems = this.oos.getPems();
                for (int i = 0; i < pems.length; ++i) {
                    if (LiveWorker.hasErrFound()) continue;
                    this.pem = pems[i];
                    this.checkSccs();
                }
                this.dg.destroyCache();
                this.dg.recordSize();
            }
        }
        catch (Exception e) {
            MP.printError(1000, "checking liveness", (Throwable)e);
            return;
        }
    }
}

