/*
 * Decompiled with CFR 0.152.
 */
package tlc2.tool.fp;

import java.io.Serializable;
import tlc2.tool.fp.FPSet;
import tlc2.tool.fp.FPSetFactory;
import util.Assert;
import util.TLCRuntime;

public class FPSetConfiguration
implements Serializable {
    protected int fpBits = 0;
    protected long memoryInBytes = -1L;
    protected double ratio;
    protected String implementation;

    public FPSetConfiguration() {
        this(0.25);
    }

    public FPSetConfiguration(Double aRatio) {
        this.ratio = aRatio;
        this.implementation = System.getProperty(FPSetFactory.IMPL_PROPERTY, FPSetFactory.getImplementationDefault());
    }

    public boolean allowsNesting() {
        return this.getFpBits() > 0;
    }

    public int getFpBits() {
        return this.fpBits;
    }

    public long getMemoryInBytes() {
        TLCRuntime instance = TLCRuntime.getInstance();
        if (FPSetFactory.allocatesOnHeap(this.implementation)) {
            if (this.memoryInBytes > 0L) {
                return instance.getFPMemSize((double)this.memoryInBytes * this.ratio);
            }
            return instance.getFPMemSize(this.ratio);
        }
        return instance.getNonHeapPhysicalMemory();
    }

    public long getMemoryInFingerprintCnt() {
        return (long)Math.floor(this.getMemoryInBytes() / 8L);
    }

    public int getMultiFPSetCnt() {
        return 1 << this.getFpBits();
    }

    public int getPrefixBits() {
        return this.getFpBits();
    }

    public void setRatio(double aRatio) {
        Assert.check(aRatio >= 0.0 && aRatio <= 1.0, 1000);
        this.ratio = aRatio;
    }

    public void setFpBits(int fpBits) {
        Assert.check(FPSet.isValid(fpBits), 1000);
        this.fpBits = fpBits;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setMemory(long fpMemSize) {
        Assert.check(fpMemSize >= 0L, 1000);
        this.memoryInBytes = fpMemSize;
    }

    public String getImplementation() {
        return this.implementation;
    }
}

