/*
 * Decompiled with CFR 0.152.
 */
package de.prob.web.views;

import com.google.inject.Inject;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.EvaluationException;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.scripting.ClassicalBFactory;
import de.prob.scripting.ModelTranslationError;
import de.prob.statespace.AnimationSelector;
import de.prob.statespace.FormalismType;
import de.prob.statespace.IAnimationChangeListener;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.web.AbstractSession;
import de.prob.web.WebUtils;
import java.util.Map;
import java.util.UUID;
import javax.servlet.AsyncContext;
import org.apache.commons.lang.StringEscapeUtils;

public class BConsole
extends AbstractSession
implements IAnimationChangeListener {
    private final StateSpace defaultSS;
    private String modelName;
    private Trace currentTrace;

    @Inject
    public BConsole(UUID id, ClassicalBFactory bfactory, AnimationSelector animations) {
        super(id);
        StateSpace s = null;
        try {
            s = bfactory.create("MACHINE Empty END").load();
        }
        catch (ModelTranslationError e) {
            throw new RuntimeException("loading a model into ProB failed!");
        }
        this.defaultSS = s;
        animations.registerAnimationChangeListener((IAnimationChangeListener)this);
        this.incrementalUpdate = false;
    }

    @Override
    public String html(String clientid, Map<String, String[]> parameterMap) {
        return this.simpleRender(clientid, "ui/bconsole/index.html");
    }

    @Override
    public void reload(String client, int lastinfo, AsyncContext context) {
        this.sendInitMessage(context);
        this.notifyModelChange(this.modelName);
    }

    public Object eval(Map<String, String[]> params) {
        String line = this.get(params, "line");
        try {
            IEvalElement parsed = this.parse(line);
            String res = "";
            if (this.currentTrace == null) {
                EvaluationCommand cmd = parsed.getCommand(this.defaultSS.getRoot());
                this.defaultSS.execute((AbstractCommand)cmd);
                res = cmd.getValue().toString();
            } else {
                res = this.currentTrace.evalCurrent((Object)parsed).toString();
            }
            return WebUtils.wrap("cmd", "BConsole.result", "result", StringEscapeUtils.escapeHtml((String)res));
        }
        catch (EvaluationException e) {
            return WebUtils.wrap("cmd", "BConsole.error", "error", "Not correct B syntax");
        }
    }

    public IEvalElement parse(String line) {
        if (this.currentTrace == null) {
            return new ClassicalB(line);
        }
        return this.currentTrace.getModel().parseFormula(line);
    }

    public void traceChange(Trace currentTrace, boolean currentAnimationChanged) {
        if (currentAnimationChanged) {
            if (currentTrace == null) {
                this.modelName = null;
                this.notifyModelChange(this.modelName);
                this.currentTrace = currentTrace;
            } else if (currentTrace.getModel().getFormalismType() == FormalismType.B) {
                String modelName = currentTrace.getStateSpace().getMainComponent().toString();
                if (!modelName.equals(this.modelName)) {
                    this.modelName = modelName;
                    this.notifyModelChange(this.modelName);
                }
                this.currentTrace = currentTrace;
            }
        }
    }

    public void notifyModelChange(String name) {
        this.submit(WebUtils.wrap("cmd", "BConsole.modelChange", "modelloaded", name != null, "name", name == null ? "" : name));
    }

    public void animatorStatus(boolean busy) {
        if (busy) {
            this.submit(WebUtils.wrap("cmd", "BConsole.disable"));
        } else {
            this.submit(WebUtils.wrap("cmd", "BConsole.enable"));
        }
    }
}

