/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.Context;
import de.saxsys.mvvmfx.FxmlPath;
import de.saxsys.mvvmfx.Scope;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import de.saxsys.mvvmfx.internal.ContextImpl;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.GlobalBuilderFactory;
import de.saxsys.mvvmfx.internal.viewloader.ResourceBundleInjector;
import de.saxsys.mvvmfx.internal.viewloader.View;
import de.saxsys.mvvmfx.internal.viewloader.ViewLoaderReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.ViewLoaderScopeUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxmlViewLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FxmlViewLoader.class);

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(Class<? extends ViewType> viewType, ResourceBundle resourceBundle, ViewType codeBehind, Object root, ViewModelType viewModel, Context context, Collection<Scope> providedScopes, List<BuilderFactory> builderFactories) {
        String pathToFXML = this.createFxmlPath(viewType);
        return this.loadFxmlViewTuple(pathToFXML, resourceBundle, codeBehind, root, viewModel, context, providedScopes, builderFactories);
    }

    private String createFxmlPath(Class<?> viewType) {
        StringBuilder pathBuilder = new StringBuilder();
        FxmlPath pathAnnotation = viewType.getDeclaredAnnotation(FxmlPath.class);
        String fxmlPath = Optional.ofNullable(pathAnnotation).map(FxmlPath::value).map(String::trim).orElse("");
        if (fxmlPath.isEmpty()) {
            pathBuilder.append("/");
            if (viewType.getPackage() != null) {
                pathBuilder.append(viewType.getPackage().getName().replaceAll("\\.", "/"));
                pathBuilder.append("/");
            }
            pathBuilder.append(viewType.getSimpleName());
            pathBuilder.append(".fxml");
        } else {
            pathBuilder.append(fxmlPath);
        }
        return pathBuilder.toString();
    }

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(String resource, ResourceBundle resourceBundle, ViewType codeBehind, Object root, ViewModelType viewModel, Context parentContext, Collection<Scope> providedScopes, List<BuilderFactory> builderFactories) {
        try {
            ViewModelType actualViewModel;
            ContextImpl context = ViewLoaderScopeUtils.prepareContext(parentContext, providedScopes);
            SimpleBooleanProperty viewInSceneProperty = new SimpleBooleanProperty();
            FXMLLoader loader = this.createFxmlLoader(resource, resourceBundle, codeBehind, root, viewModel, context, (ObservableBooleanValue)viewInSceneProperty, builderFactories);
            loader.load();
            View loadedController = (View)loader.getController();
            Parent loadedRoot = (Parent)loader.getRoot();
            viewInSceneProperty.bind((ObservableValue)loadedRoot.sceneProperty().isNotNull());
            if (loadedController == null) {
                throw new IOException("Could not load the controller for the View " + resource + " maybe your missed the fx:controller in your fxml?");
            }
            if (viewModel == null) {
                actualViewModel = ViewLoaderReflectionUtils.getExistingViewModel(loadedController);
                if (actualViewModel == null && (actualViewModel = ViewLoaderReflectionUtils.createViewModel(loadedController)) != null) {
                    ViewLoaderReflectionUtils.initializeViewModel(actualViewModel);
                }
            } else {
                actualViewModel = viewModel;
                ViewLoaderReflectionUtils.createAndInjectScopes(actualViewModel, context);
            }
            if (actualViewModel != null) {
                // empty if block
            }
            return new ViewTuple<View, ViewModelType>(loadedController, loadedRoot, actualViewModel);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private FXMLLoader createFxmlLoader(String resource, ResourceBundle resourceBundle, View codeBehind, Object root, ViewModel viewModel, ContextImpl context, ObservableBooleanValue viewInSceneProperty, List<BuilderFactory> builderFactories) throws IOException {
        URL location = FxmlViewLoader.class.getResource(resource);
        if (location == null) {
            throw new IOException("Error loading FXML - can't load from given resourcepath: " + resource);
        }
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot(root);
        fxmlLoader.setResources(resourceBundle);
        fxmlLoader.setLocation(location);
        if (builderFactories == null || builderFactories.isEmpty()) {
            fxmlLoader.setBuilderFactory((BuilderFactory)GlobalBuilderFactory.getInstance());
        } else {
            BuilderFactory factory = GlobalBuilderFactory.getInstance().mergeWith(builderFactories);
            fxmlLoader.setBuilderFactory(factory);
        }
        if (viewModel != null && codeBehind == null) {
            fxmlLoader.setControllerFactory((Callback)new ControllerFactoryForCustomViewModel(viewModel, resourceBundle, context, viewInSceneProperty));
        } else {
            fxmlLoader.setControllerFactory((Callback)new DefaultControllerFactory(resourceBundle, context, viewInSceneProperty));
        }
        if (codeBehind != null) {
            fxmlLoader.setController((Object)codeBehind);
            if (viewModel == null) {
                FxmlViewLoader.handleInjection(codeBehind, resourceBundle, context, viewInSceneProperty);
            } else {
                FxmlViewLoader.handleInjection(codeBehind, resourceBundle, viewModel, context, viewInSceneProperty);
            }
        }
        return fxmlLoader;
    }

    private static void handleInjection(View codeBehind, ResourceBundle resourceBundle, ContextImpl context, ObservableBooleanValue viewInSceneProperty) {
        ResourceBundleInjector.injectResourceBundle(codeBehind, resourceBundle);
        Consumer<ViewModel> newVmConsumer = viewModel -> {
            ResourceBundleInjector.injectResourceBundle(viewModel, resourceBundle);
            ViewLoaderReflectionUtils.createAndInjectScopes(viewModel, context);
            ViewLoaderReflectionUtils.initializeViewModel(viewModel);
            ViewLoaderReflectionUtils.addSceneLifecycleHooks(viewModel, viewInSceneProperty);
        };
        ViewLoaderReflectionUtils.createAndInjectViewModel(codeBehind, newVmConsumer);
        ViewLoaderReflectionUtils.injectContext(codeBehind, context);
    }

    private static void handleInjection(View codeBehind, ResourceBundle resourceBundle, ViewModel viewModel, ContextImpl context, ObservableBooleanValue viewInSceneProperty) {
        ResourceBundleInjector.injectResourceBundle(codeBehind, resourceBundle);
        if (viewModel != null) {
            ResourceBundleInjector.injectResourceBundle(viewModel, resourceBundle);
            ViewLoaderReflectionUtils.createAndInjectScopes(viewModel, context);
            ViewLoaderReflectionUtils.injectViewModel(codeBehind, viewModel);
            ViewLoaderReflectionUtils.injectContext(codeBehind, context);
            ViewLoaderReflectionUtils.addSceneLifecycleHooks(viewModel, viewInSceneProperty);
        }
    }

    private static class ControllerFactoryForCustomViewModel
    implements Callback<Class<?>, Object> {
        private boolean customViewModelInjected = false;
        private final ViewModel customViewModel;
        private final ResourceBundle resourceBundle;
        private final ContextImpl context;
        private ObservableBooleanValue viewInSceneProperty;

        public ControllerFactoryForCustomViewModel(ViewModel customViewModel, ResourceBundle resourceBundle, ContextImpl context, ObservableBooleanValue viewInSceneProperty) {
            this.customViewModel = customViewModel;
            this.resourceBundle = resourceBundle;
            this.context = context;
            this.viewInSceneProperty = viewInSceneProperty;
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof View) {
                View codeBehind = (View)controller;
                if (!this.customViewModelInjected) {
                    ResourceBundleInjector.injectResourceBundle(this.customViewModel, this.resourceBundle);
                    ResourceBundleInjector.injectResourceBundle(codeBehind, this.resourceBundle);
                    ViewLoaderReflectionUtils.injectViewModel(codeBehind, this.customViewModel);
                    ViewLoaderReflectionUtils.injectContext(codeBehind, this.context);
                    ViewLoaderReflectionUtils.addSceneLifecycleHooks(this.customViewModel, this.viewInSceneProperty);
                    this.customViewModelInjected = true;
                    return codeBehind;
                }
                FxmlViewLoader.handleInjection(codeBehind, this.resourceBundle, this.context, this.viewInSceneProperty);
            }
            if (controller instanceof ViewModel) {
                throw new IllegalStateException("A ViewModel class [" + controller.getClass().getCanonicalName() + "] was referenced in an FXML file as the fx:controller. Instead a class that implements FxmlView has to be defined as the fx:controller in the FXML file.");
            }
            return controller;
        }
    }

    private static class DefaultControllerFactory
    implements Callback<Class<?>, Object> {
        private final ResourceBundle resourceBundle;
        private final ContextImpl context;
        private ObservableBooleanValue viewInSceneProperty;

        public DefaultControllerFactory(ResourceBundle resourceBundle, ContextImpl context, ObservableBooleanValue viewInSceneProperty) {
            this.resourceBundle = resourceBundle;
            this.context = context;
            this.viewInSceneProperty = viewInSceneProperty;
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof ViewModel) {
                throw new IllegalStateException("A ViewModel class [" + controller.getClass().getCanonicalName() + "] was referenced in an FXML file as the fx:controller. Instead a class that implements FxmlView has to be defined as the fx:controller in the FXML file.");
            }
            if (controller instanceof View) {
                View codeBehind = (View)controller;
                FxmlViewLoader.handleInjection(codeBehind, this.resourceBundle, this.context, this.viewInSceneProperty);
            }
            return controller;
        }
    }
}

