/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.time.Duration;
import java.util.function.Consumer;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.TextChange;
import org.fxmisc.richtext.util.UndoManagerInactivityWrapper;
import org.fxmisc.undo.UndoManager;
import org.fxmisc.undo.UndoManagerFactory;
import org.reactfx.EventStream;

public final class UndoUtils {
    public static final Duration DEFAULT_PREVENT_MERGE_DELAY = Duration.ofMillis(500L);

    private UndoUtils() {
        throw new IllegalStateException("UndoUtils cannot be instantiated");
    }

    public static <PS, SEG, S> UndoManager defaultUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return area.isPreserveStyle() ? UndoUtils.richTextUndoManager(area) : UndoUtils.plainTextUndoManager(area);
    }

    public static <PS, SEG, S> UndoManager<RichTextChange<PS, SEG, S>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.richTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory());
    }

    public static <PS, SEG, S> UndoManager<RichTextChange<PS, SEG, S>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.richTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory(), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<RichTextChange<PS, SEG, S>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.richTextUndoManager(area, factory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<RichTextChange<PS, SEG, S>> richTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return UndoUtils.wrap(factory.create(area.richChanges(), TextChange::invert, UndoUtils.applyRichTextChange(area), TextChange::mergeWith, TextChange::isIdentity), area.richChanges(), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<PlainTextChange> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area) {
        return UndoUtils.plainTextUndoManager(area, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<PlainTextChange> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, Duration preventMergeDelay) {
        return UndoUtils.plainTextUndoManager(area, UndoManagerFactory.unlimitedHistoryFactory(), preventMergeDelay);
    }

    public static <PS, SEG, S> UndoManager<PlainTextChange> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory) {
        return UndoUtils.plainTextUndoManager(area, factory, DEFAULT_PREVENT_MERGE_DELAY);
    }

    public static <PS, SEG, S> UndoManager<PlainTextChange> plainTextUndoManager(GenericStyledArea<PS, SEG, S> area, UndoManagerFactory factory, Duration preventMergeDelay) {
        return UndoUtils.wrap(factory.create(area.plainTextChanges(), TextChange::invert, UndoUtils.applyPlainTextChange(area), TextChange::mergeWith, TextChange::isIdentity), area.plainTextChanges(), preventMergeDelay);
    }

    public static <PS, SEG, S> Consumer<PlainTextChange> applyPlainTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replaceText(change.getPosition(), change.getRemovalEnd(), (String)change.getInserted());
    }

    public static <PS, SEG, S> Consumer<RichTextChange<PS, SEG, S>> applyRichTextChange(GenericStyledArea<PS, SEG, S> area) {
        return change -> area.replace(change.getPosition(), change.getRemovalEnd(), (StyledDocument)change.getInserted());
    }

    public static <T> UndoManager<T> wrap(UndoManager<T> undoManager, EventStream<T> changeStream, Duration preventMergeDelay) {
        return new UndoManagerInactivityWrapper<T>(undoManager, changeStream, preventMergeDelay);
    }
}

