/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import org.fxmisc.richtext.BackgroundPath;
import org.fxmisc.richtext.BorderPath;
import org.fxmisc.richtext.CaretPath;
import org.fxmisc.richtext.JavaFXCompatibility;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.TextFlowExt;
import org.fxmisc.richtext.UnderlinePath;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledSegment;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

class ParagraphText<PS, SEG, S>
extends TextFlowExt {
    private final ObjectProperty<Paint> highlightTextFill = new SimpleObjectProperty((Object)Color.WHITE);
    private final Var<Integer> caretPosition = Var.newSimpleVar((Object)0);
    private final Val<Integer> clampedCaretPosition;
    private final ObjectProperty<IndexRange> selection = new SimpleObjectProperty((Object)StyledTextArea.EMPTY_RANGE);
    private final Paragraph<PS, SEG, S> paragraph;
    private final Path caretShape = new CaretPath();
    private final Path selectionShape = new SelectionPath();
    private final CustomCssShapeHelper<Paint> backgroundShapeHelper;
    private final CustomCssShapeHelper<BorderAttributes> borderShapeHelper;
    private final CustomCssShapeHelper<UnderlineAttributes> underlineShapeHelper;
    private final Var<Boolean> caretVisible = Var.newSimpleVar((Object)false);

    public ObjectProperty<Paint> highlightTextFillProperty() {
        return this.highlightTextFill;
    }

    public Var<Integer> caretPositionProperty() {
        return this.caretPosition;
    }

    public void setCaretPosition(int pos) {
        this.caretPosition.setValue((Object)pos);
    }

    public ObjectProperty<IndexRange> selectionProperty() {
        return this.selection;
    }

    public void setSelection(IndexRange sel) {
        this.selection.set((Object)sel);
    }

    ParagraphText(Paragraph<PS, SEG, S> par, Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this.caretShape.visibleProperty().bind(this.caretVisible);
        this.paragraph = par;
        this.getStyleClass().add((Object)"paragraph-text");
        int parLen = this.paragraph.length();
        this.clampedCaretPosition = this.caretPosition.map(i -> Math.min(i, parLen));
        this.clampedCaretPosition.addListener((obs, oldPos, newPos) -> this.requestLayout());
        this.selection.addListener((obs, old, sel) -> this.requestLayout());
        Val leftInset = Val.map((ObservableValue)this.insetsProperty(), Insets::getLeft);
        Val topInset = Val.map((ObservableValue)this.insetsProperty(), Insets::getTop);
        this.selectionShape.setManaged(false);
        this.selectionShape.setFill((Paint)Color.DODGERBLUE);
        this.selectionShape.setStrokeWidth(0.0);
        this.selectionShape.layoutXProperty().bind((ObservableValue)leftInset);
        this.selectionShape.layoutYProperty().bind((ObservableValue)topInset);
        this.getChildren().add((Object)this.selectionShape);
        this.caretShape.getStyleClass().add((Object)"caret");
        this.caretShape.setManaged(false);
        this.caretShape.setStrokeWidth(1.0);
        this.caretShape.layoutXProperty().bind((ObservableValue)leftInset);
        this.caretShape.layoutYProperty().bind((ObservableValue)topInset);
        this.getChildren().add((Object)this.caretShape);
        par.getStyledSegments().stream().map(nodeFactory).forEach(n -> {
            if (n instanceof TextExt) {
                TextExt t = (TextExt)((Object)n);
                JavaFXCompatibility.Text_selectionFillProperty(t).bind((ObservableValue)t.fillProperty());
            }
            this.getChildren().add(n);
        });
        Supplier<Path> createBackgroundShape = () -> {
            BackgroundPath shape = new BackgroundPath();
            shape.setManaged(false);
            shape.layoutXProperty().bind((ObservableValue)leftInset);
            shape.layoutYProperty().bind((ObservableValue)topInset);
            return shape;
        };
        Supplier<Path> createBorderShape = () -> {
            BorderPath shape = new BorderPath();
            shape.setManaged(false);
            shape.layoutXProperty().bind((ObservableValue)leftInset);
            shape.layoutYProperty().bind((ObservableValue)topInset);
            return shape;
        };
        Supplier<Path> createUnderlineShape = () -> {
            UnderlinePath shape = new UnderlinePath();
            shape.setManaged(false);
            shape.layoutXProperty().bind((ObservableValue)leftInset);
            shape.layoutYProperty().bind((ObservableValue)topInset);
            return shape;
        };
        Consumer<Collection<Path>> clearUnusedShapes = paths -> this.getChildren().removeAll(paths);
        Consumer<Path> addToBackground = path -> this.getChildren().add(0, path);
        Consumer<Path> addToForeground = path -> this.getChildren().add(path);
        this.backgroundShapeHelper = new CustomCssShapeHelper(createBackgroundShape, (backgroundShape, tuple) -> {
            backgroundShape.setStrokeWidth(0.0);
            backgroundShape.setFill((Paint)tuple._1);
            backgroundShape.getElements().setAll((Object[])this.getRangeShape((IndexRange)tuple._2));
        }, addToBackground, clearUnusedShapes);
        this.borderShapeHelper = new CustomCssShapeHelper(createBorderShape, (borderShape, tuple) -> {
            BorderAttributes attributes = (BorderAttributes)tuple._1;
            borderShape.setStrokeWidth(attributes.width);
            borderShape.setStroke(attributes.color);
            if (attributes.type != null) {
                borderShape.setStrokeType(attributes.type);
            }
            if (attributes.dashArray != null) {
                borderShape.getStrokeDashArray().setAll((Object[])attributes.dashArray);
            }
            borderShape.getElements().setAll((Object[])this.getRangeShape((IndexRange)tuple._2));
        }, addToBackground, clearUnusedShapes);
        this.underlineShapeHelper = new CustomCssShapeHelper(createUnderlineShape, (underlineShape, tuple) -> {
            UnderlineAttributes attributes = (UnderlineAttributes)tuple._1;
            underlineShape.setStroke(attributes.color);
            underlineShape.setStrokeWidth(attributes.width);
            underlineShape.setStrokeLineCap(attributes.cap);
            if (attributes.dashArray != null) {
                underlineShape.getStrokeDashArray().setAll((Object[])attributes.dashArray);
            }
            underlineShape.getElements().setAll((Object[])this.getUnderlineShape((IndexRange)tuple._2));
        }, addToForeground, clearUnusedShapes);
    }

    public Paragraph<PS, SEG, S> getParagraph() {
        return this.paragraph;
    }

    public Var<Boolean> caretVisibleProperty() {
        return this.caretVisible;
    }

    public ObjectProperty<Paint> highlightFillProperty() {
        return this.selectionShape.fillProperty();
    }

    public double getCaretOffsetX() {
        this.layout();
        Bounds bounds = this.caretShape.getLayoutBounds();
        return (bounds.getMinX() + bounds.getMaxX()) / 2.0;
    }

    public Bounds getCaretBounds() {
        this.layout();
        return this.caretShape.getBoundsInParent();
    }

    public Bounds getCaretBoundsOnScreen() {
        this.layout();
        Bounds localBounds = this.caretShape.getBoundsInLocal();
        return this.caretShape.localToScreen(localBounds);
    }

    public Bounds getRangeBoundsOnScreen(int from, int to) {
        this.layout();
        Object[] rangeShape = this.getRangeShapeSafely(from, to);
        ArrayList selShape = new ArrayList(this.selectionShape.getElements());
        this.selectionShape.getElements().setAll(rangeShape);
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        Bounds rangeBoundsOnScreen = this.selectionShape.localToScreen(localBounds);
        this.selectionShape.getElements().setAll(selShape);
        return rangeBoundsOnScreen;
    }

    public Optional<Bounds> getSelectionBoundsOnScreen() {
        if (((IndexRange)this.selection.get()).getLength() == 0) {
            return Optional.empty();
        }
        this.layout();
        Bounds localBounds = this.selectionShape.getBoundsInLocal();
        return Optional.ofNullable(this.selectionShape.localToScreen(localBounds));
    }

    public int getCurrentLineStartPosition() {
        return this.getLineStartPosition((Integer)this.clampedCaretPosition.getValue());
    }

    public int getCurrentLineEndPosition() {
        return this.getLineEndPosition((Integer)this.clampedCaretPosition.getValue());
    }

    public int currentLineIndex() {
        return this.getLineOfCharacter((Integer)this.clampedCaretPosition.getValue());
    }

    public int currentLineIndex(int position) {
        return this.getLineOfCharacter(position);
    }

    private void updateCaretShape() {
        Object[] shape = this.getCaretShape((Integer)this.clampedCaretPosition.getValue(), true);
        this.caretShape.getElements().setAll(shape);
    }

    private void updateSelectionShape() {
        int start = ((IndexRange)this.selection.get()).getStart();
        int end = ((IndexRange)this.selection.get()).getEnd();
        this.selectionShape.getElements().setAll((Object[])this.getRangeShapeSafely(start, end));
    }

    private PathElement[] getRangeShapeSafely(int start, int end) {
        PathElement[] shape;
        if (end <= this.paragraph.length()) {
            shape = this.getRangeShape(start, end);
        } else if (this.paragraph.length() == 0) {
            shape = this.createRectangle(0.0, 0.0, this.getWidth(), this.getHeight());
        } else if (start == this.paragraph.length()) {
            shape = this.getRangeShape(start - 1, start);
            LineTo lineToTopRight = (LineTo)shape[shape.length - 4];
            shape = this.createRectangle(lineToTopRight.getX(), lineToTopRight.getY(), this.getWidth(), this.getHeight());
        } else {
            shape = this.getRangeShape(start, this.paragraph.length());
            int length = shape.length;
            int bottomRightIndex = length - 3;
            int topRightIndex = bottomRightIndex - 1;
            LineTo lineToTopRight = (LineTo)shape[topRightIndex];
            shape[topRightIndex] = new LineTo(this.getWidth(), lineToTopRight.getY());
            shape[bottomRightIndex] = new LineTo(this.getWidth(), this.getHeight());
        }
        if (this.getLineCount() > 1) {
            boolean wrappedAtEndPos = end > 0 && this.getLineOfCharacter(end) > this.getLineOfCharacter(end - 1);
            int adjustLength = shape.length - (wrappedAtEndPos ? 0 : 5);
            for (int i = 0; i < adjustLength; ++i) {
                if (!(shape[i] instanceof MoveTo)) continue;
                ((LineTo)shape[i + 1]).setX(this.getWidth());
                ((LineTo)shape[i + 2]).setX(this.getWidth());
            }
        }
        return shape;
    }

    private PathElement[] createRectangle(double topLeftX, double topLeftY, double bottomRightX, double bottomRightY) {
        return new PathElement[]{new MoveTo(topLeftX, topLeftY), new LineTo(bottomRightX, topLeftY), new LineTo(bottomRightX, bottomRightY), new LineTo(topLeftX, bottomRightY), new LineTo(topLeftX, topLeftY)};
    }

    private void updateBackgroundShapes() {
        int start = 0;
        FilteredList nodeList = this.getChildren().filtered(node -> node instanceof TextExt);
        for (Node node2 : nodeList) {
            UnderlineAttributes underline;
            BorderAttributes border;
            TextExt text = (TextExt)node2;
            int end = start + text.getText().length();
            Paint backgroundColor = text.getBackgroundColor();
            if (backgroundColor != null) {
                ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapeRange(backgroundColor, start, end);
            }
            if (!(border = new BorderAttributes(text)).isNullValue()) {
                ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapeRange(border, start, end);
            }
            if (!(underline = new UnderlineAttributes(text)).isNullValue()) {
                ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapeRange(underline, start, end);
            }
            start = end;
        }
        ((CustomCssShapeHelper)this.borderShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.backgroundShapeHelper).updateSharedShapes();
        ((CustomCssShapeHelper)this.underlineShapeHelper).updateSharedShapes();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.updateCaretShape();
        this.updateSelectionShape();
        this.updateBackgroundShapes();
    }

    private static class LineAttributesBase {
        final double width;
        final Paint color;
        final Double[] dashArray;

        public final boolean isNullValue() {
            return this.color == null || this.width == -1.0;
        }

        LineAttributesBase(Paint color, Number width, ObjectProperty<Number[]> dashArrayProp) {
            this.color = color;
            if (color == null || width == null || width.doubleValue() <= 0.0) {
                this.width = -1.0;
                this.dashArray = null;
            } else {
                this.width = width.doubleValue();
                Object dashArrayProperty = dashArrayProp.get();
                if (dashArrayProperty != null) {
                    if (dashArrayProperty.getClass().isArray()) {
                        Number[] numberArray = (Number[])dashArrayProperty;
                        this.dashArray = new Double[numberArray.length];
                        int idx = 0;
                        for (Number d : numberArray) {
                            this.dashArray[idx++] = (Double)d;
                        }
                    } else {
                        this.dashArray = new Double[1];
                        this.dashArray[0] = (double)((Double)dashArrayProperty);
                    }
                } else {
                    this.dashArray = null;
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof UnderlineAttributes) {
                UnderlineAttributes attr = (UnderlineAttributes)obj;
                return Objects.equals(this.width, attr.width) && Objects.equals(this.color, attr.color) && Arrays.equals((Object[])this.dashArray, (Object[])attr.dashArray);
            }
            return false;
        }

        protected final String getSubString() {
            return String.format("width=%s color=%s dashArray=%s", this.width, this.color, Arrays.toString((Object[])this.dashArray));
        }
    }

    private static class UnderlineAttributes
    extends LineAttributesBase {
        final StrokeLineCap cap;

        UnderlineAttributes(TextExt text) {
            super(text.getUnderlineColor(), text.getUnderlineWidth(), text.underlineDashArrayProperty());
            this.cap = text.getUnderlineCap();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof UnderlineAttributes) {
                UnderlineAttributes attr = (UnderlineAttributes)obj;
                return super.equals(attr) && Objects.equals(this.cap, attr.cap);
            }
            return false;
        }

        public String toString() {
            return String.format("UnderlineAttributes[cap=%s %s]", this.cap, this.getSubString());
        }
    }

    private static class BorderAttributes
    extends LineAttributesBase {
        final StrokeType type;

        BorderAttributes(TextExt text) {
            super(text.getBorderStrokeColor(), text.getBorderStrokeWidth(), text.borderStrokeDashArrayProperty());
            this.type = text.getBorderStrokeType();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof BorderAttributes) {
                BorderAttributes attributes = (BorderAttributes)obj;
                return super.equals(attributes) && Objects.equals(this.type, attributes.type);
            }
            return false;
        }

        public String toString() {
            return String.format("BorderAttributes[type=%s %s]", this.type, this.getSubString());
        }
    }

    private static class CustomCssShapeHelper<T> {
        private final List<Tuple2<T, IndexRange>> ranges = new LinkedList<Tuple2<T, IndexRange>>();
        private final List<Path> shapes = new LinkedList<Path>();
        private final Supplier<Path> createShape;
        private final BiConsumer<Path, Tuple2<T, IndexRange>> configureShape;
        private final Consumer<Path> addToChildren;
        private final Consumer<Collection<Path>> clearUnusedShapes;

        CustomCssShapeHelper(Supplier<Path> createShape, BiConsumer<Path, Tuple2<T, IndexRange>> configureShape, Consumer<Path> addToChildren, Consumer<Collection<Path>> clearUnusedShapes) {
            this.createShape = createShape;
            this.configureShape = configureShape;
            this.addToChildren = addToChildren;
            this.clearUnusedShapes = clearUnusedShapes;
        }

        private void updateSharedShapeRange(T value, int start, int end) {
            Runnable addNewValueRange = () -> this.ranges.add(Tuples.t((Object)value, (Object)new IndexRange(start, end)));
            if (this.ranges.isEmpty()) {
                addNewValueRange.run();
            } else {
                int lastIndex = this.ranges.size() - 1;
                Tuple2<T, IndexRange> lastShapeValueRange = this.ranges.get(lastIndex);
                Object lastShapeValue = lastShapeValueRange._1;
                int prevEndNext = ((IndexRange)lastShapeValueRange.get2()).getEnd() + 1;
                if (start <= prevEndNext && lastShapeValue.equals(value)) {
                    IndexRange lastRange = (IndexRange)lastShapeValueRange._2;
                    IndexRange extendedRange = new IndexRange(lastRange.getStart(), end);
                    this.ranges.set(lastIndex, Tuples.t((Object)lastShapeValue, (Object)extendedRange));
                } else {
                    addNewValueRange.run();
                }
            }
        }

        private void updateSharedShapes() {
            int availableNumber;
            int neededNumber = this.ranges.size();
            if (neededNumber < (availableNumber = this.shapes.size())) {
                List<Path> unusedShapes = this.shapes.subList(neededNumber, availableNumber);
                this.clearUnusedShapes.accept(unusedShapes);
                unusedShapes.clear();
            } else if (availableNumber < neededNumber) {
                for (int i = 0; i < neededNumber - availableNumber; ++i) {
                    Path shape = this.createShape.get();
                    this.shapes.add(shape);
                    this.addToChildren.accept(shape);
                }
            }
            for (int i = 0; i < this.ranges.size(); ++i) {
                this.configureShape.accept(this.shapes.get(i), this.ranges.get(i));
            }
            this.ranges.clear();
        }
    }
}

