/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.text.BreakIterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.util.Duration;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.model.TwoDimensional;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.StateMachine;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableNo;
import org.reactfx.value.SuspendableVal;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

final class CaretImpl
implements Caret {
    private final SuspendableVal<Integer> position;
    private final SuspendableVal<Integer> paragraphIndex;
    private final SuspendableVal<OptionalInt> lineIndex;
    private final SuspendableVal<Integer> columnPosition;
    private final Var<Caret.CaretVisibility> showCaret = Var.newSimpleVar((Object)((Object)Caret.CaretVisibility.AUTO));
    private final Binding<Boolean> visible;
    private final Val<Optional<Bounds>> bounds;
    private Optional<ParagraphBox.CaretOffsetX> targetOffset = Optional.empty();
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final EventStream<?> dirty;
    private final GenericStyledArea<?, ?, ?> area;
    private final SuspendableNo dependentBeingUpdated;
    private final Var<Integer> internalTextPosition;
    private Subscription subscriptions = () -> {};

    @Override
    public final int getPosition() {
        return (Integer)this.position.getValue();
    }

    @Override
    public final ObservableValue<Integer> positionProperty() {
        return this.position;
    }

    @Override
    public final int getParagraphIndex() {
        return (Integer)this.paragraphIndex.getValue();
    }

    @Override
    public final ObservableValue<Integer> paragraphIndexProperty() {
        return this.paragraphIndex;
    }

    @Override
    public final OptionalInt getLineIndex() {
        return (OptionalInt)this.lineIndex.getValue();
    }

    @Override
    public final ObservableValue<OptionalInt> lineIndexProperty() {
        return this.lineIndex;
    }

    @Override
    public final int getColumnPosition() {
        return (Integer)this.columnPosition.getValue();
    }

    @Override
    public final ObservableValue<Integer> columnPositionProperty() {
        return this.columnPosition;
    }

    @Override
    public final Caret.CaretVisibility getShowCaret() {
        return (Caret.CaretVisibility)((Object)this.showCaret.getValue());
    }

    @Override
    public final void setShowCaret(Caret.CaretVisibility value) {
        this.showCaret.setValue((Object)value);
    }

    @Override
    public final Var<Caret.CaretVisibility> showCaretProperty() {
        return this.showCaret;
    }

    @Override
    public final boolean isVisible() {
        return (Boolean)this.visible.getValue();
    }

    @Override
    public final ObservableValue<Boolean> visibleProperty() {
        return this.visible;
    }

    @Override
    public final Optional<Bounds> getCaretBounds() {
        return (Optional)this.bounds.getValue();
    }

    @Override
    public final ObservableValue<Optional<Bounds>> caretBoundsProperty() {
        return this.bounds;
    }

    @Override
    public final void clearTargetOffset() {
        this.targetOffset = Optional.empty();
    }

    @Override
    public final ParagraphBox.CaretOffsetX getTargetOffset() {
        if (!this.targetOffset.isPresent()) {
            this.targetOffset = Optional.of(this.area.getCaretOffsetX(this.getParagraphIndex()));
        }
        return this.targetOffset.get();
    }

    @Override
    public final boolean isBeingUpdated() {
        return this.beingUpdated.get();
    }

    @Override
    public final ObservableValue<Boolean> beingUpdatedProperty() {
        return this.beingUpdated;
    }

    CaretImpl(GenericStyledArea<?, ?, ?> area) {
        this(area, 0);
    }

    CaretImpl(GenericStyledArea<?, ?, ?> area, int startingPosition) {
        this(area, area.beingUpdatedProperty(), startingPosition);
    }

    CaretImpl(GenericStyledArea<?, ?, ?> area, SuspendableNo dependentBeingUpdated, int startingPosition) {
        this.area = area;
        this.dependentBeingUpdated = dependentBeingUpdated;
        this.internalTextPosition = Var.newSimpleVar((Object)startingPosition);
        this.position = this.internalTextPosition.suspendable();
        Val caretPosition2D = Val.create(() -> area.offsetToPosition((Integer)this.internalTextPosition.getValue(), TwoDimensional.Bias.Forward), (Observable[])new Observable[]{this.internalTextPosition, area.getParagraphs()});
        this.paragraphIndex = caretPosition2D.map(TwoDimensional.Position::getMajor).suspendable();
        this.columnPosition = caretPosition2D.map(TwoDimensional.Position::getMinor).suspendable();
        this.manageSubscription(area.plainTextChanges(), plainTextChange -> {
            int netLength = plainTextChange.getNetLength();
            if (netLength != 0) {
                int indexOfChange = plainTextChange.getPosition();
                int endOfChange = indexOfChange + Math.abs(netLength);
                int caretPosition = this.getPosition();
                if (indexOfChange < caretPosition) {
                    this.moveTo(caretPosition < endOfChange ? indexOfChange : caretPosition + netLength);
                }
            }
        });
        EventStream blinkCaret = this.showCaret.values().flatMap(mode -> {
            switch (mode) {
                case ON: {
                    return Val.constant((Object)true).values();
                }
                case OFF: {
                    return Val.constant((Object)false).values();
                }
            }
            return area.autoCaretBlink();
        });
        this.dirty = EventStreams.merge((EventStream[])new EventStream[]{EventStreams.invalidationsOf(this.positionProperty()), EventStreams.invalidationsOf(area.getParagraphs())});
        this.visible = EventStreams.combine((EventStream)blinkCaret, area.caretBlinkRateEvents()).flatMap(tuple -> {
            Boolean blink = (Boolean)tuple.get1();
            Duration rate = (Duration)tuple.get2();
            if (blink.booleanValue()) {
                return rate.lessThanOrEqualTo(Duration.ZERO) ? Val.constant((Object)true).values() : CaretImpl.booleanPulse(rate, this.dirty);
            }
            return Val.constant((Object)false).values();
        }).toBinding((Object)false);
        this.manageBinding(this.visible);
        this.bounds = Val.create(() -> area.getCaretBoundsOnScreen(this.getParagraphIndex()), area.boundsDirtyFor(this.dirty));
        this.lineIndex = Val.create(() -> OptionalInt.of(area.lineIndex(this.getParagraphIndex(), this.getColumnPosition())), this.dirty).suspendable();
        Suspendable omniSuspendable = Suspendable.combine((Suspendable[])new Suspendable[]{this.beingUpdated, this.paragraphIndex, this.columnPosition, this.position});
        this.manageSubscription(omniSuspendable.suspendWhen((ObservableValue)dependentBeingUpdated));
    }

    @Override
    public void moveTo(int paragraphIndex, int columnPosition) {
        this.moveTo(this.textPosition(paragraphIndex, columnPosition));
    }

    @Override
    public void moveTo(int position) {
        Runnable updatePos = () -> this.internalTextPosition.setValue((Object)position);
        if (this.isBeingUpdated()) {
            updatePos.run();
        } else {
            this.dependentBeingUpdated.suspendWhile(updatePos);
        }
    }

    @Override
    public void moveToParStart() {
        this.moveTo(this.getPosition() - this.getColumnPosition());
    }

    @Override
    public void moveToParEnd() {
        this.moveTo(this.area.getParagraphLength(this.getParagraphIndex()));
    }

    @Override
    public void moveToAreaEnd() {
        this.moveTo(this.area.getLength());
    }

    @Override
    public void moveToNextChar() {
        this.moveTo(this.getPosition() + 1);
    }

    @Override
    public void moveToPrevChar() {
        this.moveTo(this.getPosition() - 1);
    }

    @Override
    public void moveBreaksBackwards(int numOfBreaks, BreakIterator breakIterator) {
        this.moveContentBreaks(numOfBreaks, breakIterator, false);
    }

    @Override
    public void moveBreaksForwards(int numOfBreaks, BreakIterator breakIterator) {
        this.moveContentBreaks(numOfBreaks, breakIterator, true);
    }

    @Override
    public void dispose() {
        this.subscriptions.unsubscribe();
    }

    private int textPosition(int row, int col) {
        return this.area.position(row, col).toOffset();
    }

    private <T> void manageSubscription(EventStream<T> stream, Consumer<T> subscriber) {
        this.manageSubscription(stream.subscribe(subscriber));
    }

    private void manageBinding(Binding<?> binding) {
        this.manageSubscription(() -> binding.dispose());
    }

    private void manageSubscription(Subscription s) {
        this.subscriptions = this.subscriptions.and(s);
    }

    private static EventStream<Boolean> booleanPulse(Duration javafxDuration, EventStream<?> restartImpulse) {
        java.time.Duration duration = java.time.Duration.ofMillis(Math.round(javafxDuration.toMillis()));
        EventStream ticks = EventStreams.restartableTicks((java.time.Duration)duration, restartImpulse);
        return StateMachine.init((Object)false).on(restartImpulse.withDefaultEvent(null)).transition((state, impulse) -> true).on(ticks).transition((state, tick) -> state == false).toStateStream();
    }

    private void moveContentBreaks(int numOfBreaks, BreakIterator breakIterator, boolean followingNotPreceding) {
        if (this.area.getLength() == 0) {
            return;
        }
        breakIterator.setText(this.area.getText());
        if (followingNotPreceding) {
            breakIterator.following(this.getPosition());
        } else {
            breakIterator.preceding(this.getPosition());
        }
        for (int i = 1; i < numOfBreaks; ++i) {
            breakIterator.next();
        }
        this.moveTo(breakIterator.current());
    }
}

