/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes.ltl;

import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;

public class LTLInfixOperatorNode
implements LTLNode {
    private Kind kind;
    private LTLNode left;
    private LTLNode right;

    public LTLInfixOperatorNode(Kind kind, LTLNode left, LTLNode right) {
        this.kind = kind;
        this.left = left;
        this.right = right;
    }

    public Kind getKind() {
        return this.kind;
    }

    public LTLNode getLeft() {
        return this.left;
    }

    public LTLNode getRight() {
        return this.right;
    }

    public void setLeft(LTLNode left) {
        this.left = left;
    }

    public void setRight(LTLNode right) {
        this.right = right;
    }

    public String toString() {
        return (Object)((Object)this.kind) + "(" + this.left + "," + this.right + ")";
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        LTLInfixOperatorNode that = (LTLInfixOperatorNode)other;
        return this.kind.equals((Object)that.kind) && this.left.equalAst(that.left) && this.right.equalAst(that.right);
    }

    public static enum Kind {
        IMPLICATION,
        UNTIL,
        WEAK_UNTIL,
        RELEASE,
        AND,
        OR;

    }
}

