/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes.ltl;

import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.ltl.BuechiAutomatonNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLKeywordNode;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;

public class BuechiAutomaton {
    static final String FORMULA_NOT_NOMALIZED = "Formula not normalized";
    private int nodeCounter = 0;
    private Set<LTLNode> subFormulasForAcceptance = new LinkedHashSet<LTLNode>();
    private List<List<BuechiAutomatonNode>> acceptingStateSets = new ArrayList<List<BuechiAutomatonNode>>();
    private Set<BuechiAutomatonNode> initialStates = new LinkedHashSet<BuechiAutomatonNode>();
    private final Set<BuechiAutomatonNode> nodeSet = new LinkedHashSet<BuechiAutomatonNode>();

    public BuechiAutomaton(LTLNode ltlNode) {
        this.createGraph(ltlNode);
        this.labelNodes();
        this.determineInitialsAndSuccessors();
    }

    private String newName() {
        ++this.nodeCounter;
        return "node" + this.nodeCounter;
    }

    private Boolean checkForContradiction(LTLNode ltlNode, Set<LTLNode> processedNodes) {
        PredicateNode negatedNode = ((LTLBPredicateNode)ltlNode).getPredicate().getNegatedPredicateNode();
        for (LTLNode processedNode : processedNodes) {
            if (!(processedNode instanceof LTLBPredicateNode) || !((LTLBPredicateNode)processedNode).getPredicate().equalAst(negatedNode)) continue;
            return true;
        }
        return false;
    }

    private Boolean ltlNodeIsInList(LTLNode ltlNode, Set<LTLNode> processed) {
        for (LTLNode processedNode : processed) {
            if (!ltlNode.equalAst(processedNode)) continue;
            return true;
        }
        return false;
    }

    private Boolean compareLTLNodeSets(Set<LTLNode> nodeSet, Set<LTLNode> processedNodeSet) {
        if (nodeSet.size() == processedNodeSet.size()) {
            LinkedHashSet<LTLNode> nodeProcessed = new LinkedHashSet<LTLNode>(nodeSet);
            LinkedHashSet<LTLNode> nodeInSetProcessed = new LinkedHashSet<LTLNode>(processedNodeSet);
            Iterator nodeIterator = nodeProcessed.iterator();
            while (nodeIterator.hasNext()) {
                LTLNode ltlNode = (LTLNode)nodeIterator.next();
                Iterator nodeInSetIterator = nodeInSetProcessed.iterator();
                while (nodeInSetIterator.hasNext()) {
                    LTLNode ltlNodeInSet = (LTLNode)nodeInSetIterator.next();
                    if (!ltlNode.equalAst(ltlNodeInSet)) continue;
                    nodeIterator.remove();
                    nodeInSetIterator.remove();
                }
            }
            return nodeProcessed.isEmpty() && nodeInSetProcessed.isEmpty();
        }
        return false;
    }

    private BuechiAutomatonNode buechiNodeIsInNodeSet(BuechiAutomatonNode buechiNode) {
        for (BuechiAutomatonNode nodeInSet : this.nodeSet) {
            boolean processedEquals = this.compareLTLNodeSets(buechiNode.processed, nodeInSet.processed);
            boolean nextEquals = this.compareLTLNodeSets(buechiNode.next, nodeInSet.next);
            if (!processedEquals || !nextEquals) continue;
            return nodeInSet;
        }
        return null;
    }

    private Set<LTLNode> new1(LTLInfixOperatorNode ltlNode) {
        LinkedHashSet<LTLNode> newNodes = new LinkedHashSet<LTLNode>();
        if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.RELEASE) {
            newNodes.add(ltlNode.getRight());
        } else if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.UNTIL || ltlNode.getKind() == LTLInfixOperatorNode.Kind.OR) {
            newNodes.add(ltlNode.getLeft());
        } else {
            throw new IllegalArgumentException(FORMULA_NOT_NOMALIZED);
        }
        return newNodes;
    }

    private Set<LTLNode> new2(LTLInfixOperatorNode ltlNode) {
        LinkedHashSet<LTLNode> newNodes = new LinkedHashSet<LTLNode>();
        newNodes.add(ltlNode.getRight());
        if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.RELEASE) {
            newNodes.add(ltlNode.getLeft());
        }
        return newNodes;
    }

    private Set<LTLNode> next1(LTLInfixOperatorNode ltlNode) {
        LinkedHashSet<LTLNode> newNodes = new LinkedHashSet<LTLNode>();
        if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.UNTIL || ltlNode.getKind() == LTLInfixOperatorNode.Kind.RELEASE) {
            newNodes.add(ltlNode);
            return newNodes;
        }
        if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.OR) {
            return newNodes;
        }
        throw new IllegalArgumentException(FORMULA_NOT_NOMALIZED);
    }

    private BuechiAutomatonNode buildFirstNodeInSplit(BuechiAutomatonNode buechiNode, LTLInfixOperatorNode subNode) {
        LinkedHashSet<LTLNode> unprocessed = new LinkedHashSet<LTLNode>(buechiNode.unprocessed);
        for (LTLNode node : this.new1(subNode)) {
            if (this.ltlNodeIsInList(node, buechiNode.processed).booleanValue()) continue;
            unprocessed.add(node);
        }
        LinkedHashSet<LTLNode> next = new LinkedHashSet<LTLNode>(buechiNode.next);
        next.addAll(this.next1(subNode));
        LinkedHashSet<LTLNode> processed = new LinkedHashSet<LTLNode>(buechiNode.processed);
        processed.add(subNode);
        return new BuechiAutomatonNode(this.newName(), new LinkedHashSet<BuechiAutomatonNode>(buechiNode.incoming), unprocessed, processed, next);
    }

    private BuechiAutomatonNode buildSecondNodeInSplit(BuechiAutomatonNode buechiNode, LTLInfixOperatorNode subNode) {
        LinkedHashSet<LTLNode> unprocessed = new LinkedHashSet<LTLNode>(buechiNode.unprocessed);
        for (LTLNode node : this.new2(subNode)) {
            if (this.ltlNodeIsInList(node, buechiNode.processed).booleanValue()) continue;
            unprocessed.add(node);
        }
        LinkedHashSet<LTLNode> processed = new LinkedHashSet<LTLNode>(buechiNode.processed);
        processed.add(subNode);
        return new BuechiAutomatonNode(this.newName(), new LinkedHashSet<BuechiAutomatonNode>(buechiNode.incoming), unprocessed, processed, new LinkedHashSet<LTLNode>(buechiNode.next));
    }

    private void handleProcessedNode(BuechiAutomatonNode buechiNode) {
        BuechiAutomatonNode nodeInSet = this.buechiNodeIsInNodeSet(buechiNode);
        if (nodeInSet != null) {
            nodeInSet.incoming.addAll(buechiNode.incoming);
        } else {
            LinkedHashSet<BuechiAutomatonNode> incoming = new LinkedHashSet<BuechiAutomatonNode>();
            incoming.add(buechiNode);
            this.nodeSet.add(buechiNode);
            this.expand(new BuechiAutomatonNode(this.newName(), incoming, new LinkedHashSet<LTLNode>(buechiNode.next), new LinkedHashSet<LTLNode>(), new LinkedHashSet<LTLNode>()));
        }
    }

    private void handleInfixOperatorNode(BuechiAutomatonNode buechiNode, LTLInfixOperatorNode ltlNode) {
        if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.AND) {
            LinkedHashSet<LTLNode> unprocessed = new LinkedHashSet<LTLNode>(buechiNode.unprocessed);
            unprocessed.add(ltlNode.getLeft());
            unprocessed.add(ltlNode.getRight());
            unprocessed.removeAll(buechiNode.processed);
            LinkedHashSet<LTLNode> processed = new LinkedHashSet<LTLNode>(buechiNode.processed);
            processed.add(ltlNode);
            this.expand(new BuechiAutomatonNode(buechiNode.name, new LinkedHashSet<BuechiAutomatonNode>(buechiNode.incoming), unprocessed, processed, new LinkedHashSet<LTLNode>(buechiNode.next)));
        } else {
            if (ltlNode.getKind() == LTLInfixOperatorNode.Kind.UNTIL && !this.ltlNodeIsInList(ltlNode, this.subFormulasForAcceptance).booleanValue()) {
                this.subFormulasForAcceptance.add(ltlNode);
            }
            BuechiAutomatonNode node1 = this.buildFirstNodeInSplit(buechiNode, ltlNode);
            BuechiAutomatonNode node2 = this.buildSecondNodeInSplit(buechiNode, ltlNode);
            this.expand(node1);
            this.expand(node2);
        }
    }

    private void handlePrefixOperatorNode(BuechiAutomatonNode buechiNode, LTLPrefixOperatorNode ltlNode) {
        if (ltlNode.getKind() != LTLPrefixOperatorNode.Kind.NEXT) {
            throw new IllegalArgumentException(FORMULA_NOT_NOMALIZED);
        }
        LinkedHashSet<LTLNode> processed = new LinkedHashSet<LTLNode>(buechiNode.processed);
        processed.add(ltlNode);
        LinkedHashSet<LTLNode> next = new LinkedHashSet<LTLNode>(buechiNode.next);
        next.add(ltlNode.getArgument());
        this.expand(new BuechiAutomatonNode(buechiNode.name + "_1", new LinkedHashSet<BuechiAutomatonNode>(buechiNode.incoming), new LinkedHashSet<LTLNode>(buechiNode.unprocessed), processed, next));
    }

    private void expand(BuechiAutomatonNode buechiNode) {
        if (buechiNode.unprocessed.isEmpty()) {
            this.handleProcessedNode(buechiNode);
        } else {
            Iterator<LTLNode> iterator = buechiNode.unprocessed.iterator();
            LTLNode ltlNode = iterator.next();
            iterator.remove();
            if (ltlNode instanceof LTLKeywordNode) {
                if (((LTLKeywordNode)ltlNode).getKind() == LTLKeywordNode.Kind.TRUE) {
                    buechiNode.processed.add(ltlNode);
                    this.expand(buechiNode);
                }
            } else if (ltlNode instanceof LTLBPredicateNode) {
                if (!this.checkForContradiction(ltlNode, buechiNode.processed).booleanValue()) {
                    buechiNode.processed.add(ltlNode);
                    this.expand(buechiNode);
                }
            } else if (ltlNode instanceof LTLPrefixOperatorNode) {
                this.handlePrefixOperatorNode(buechiNode, (LTLPrefixOperatorNode)ltlNode);
            } else if (ltlNode instanceof LTLInfixOperatorNode) {
                this.handleInfixOperatorNode(buechiNode, (LTLInfixOperatorNode)ltlNode);
            }
        }
    }

    private void createGraph(LTLNode node) {
        LinkedHashSet<BuechiAutomatonNode> initIncoming = new LinkedHashSet<BuechiAutomatonNode>();
        initIncoming.add(new BuechiAutomatonNode("init", new LinkedHashSet<BuechiAutomatonNode>(), new LinkedHashSet<LTLNode>(), new LinkedHashSet<LTLNode>(), new LinkedHashSet<LTLNode>()));
        LinkedHashSet<LTLNode> unprocessed = new LinkedHashSet<LTLNode>();
        unprocessed.add(node);
        this.expand(new BuechiAutomatonNode(this.newName(), initIncoming, unprocessed, new LinkedHashSet<LTLNode>(), new LinkedHashSet<LTLNode>()));
    }

    private void labelNodes() {
        for (BuechiAutomatonNode buechiNode : this.nodeSet) {
            buechiNode.label();
        }
        for (LTLNode formulaForAcceptance : this.subFormulasForAcceptance) {
            LTLInfixOperatorNode untilNode = (LTLInfixOperatorNode)formulaForAcceptance;
            ArrayList<BuechiAutomatonNode> acceptingStateSet = new ArrayList<BuechiAutomatonNode>();
            for (BuechiAutomatonNode buechiNode : this.nodeSet) {
                if (this.ltlNodeIsInList(untilNode, buechiNode.processed).booleanValue() && !this.ltlNodeIsInList(untilNode.getRight(), buechiNode.processed).booleanValue()) continue;
                buechiNode.isAcceptingState = true;
                acceptingStateSet.add(buechiNode);
            }
            this.acceptingStateSets.add(acceptingStateSet);
        }
    }

    private void determineInitialsAndSuccessors() {
        for (BuechiAutomatonNode node : this.nodeSet) {
            for (BuechiAutomatonNode incomingNode : node.incoming) {
                incomingNode.successors.add(node);
            }
            if (!node.isInitialState) continue;
            this.initialStates.add(node);
        }
    }

    public String toString() {
        StringJoiner nodesString = new StringJoiner(",\n\n", "", "");
        for (BuechiAutomatonNode node : this.nodeSet) {
            nodesString.add(node.toString());
        }
        StringJoiner acceptingString = new StringJoiner(", ", "[", "]");
        for (List<BuechiAutomatonNode> acceptingStateSet : this.acceptingStateSets) {
            StringJoiner acceptingStatesString = new StringJoiner(", ", "(", ")");
            for (BuechiAutomatonNode node : acceptingStateSet) {
                acceptingStatesString.add(node.name);
            }
            acceptingString.add(acceptingStatesString.toString());
        }
        nodesString.add("Accepting state sets: " + acceptingString.toString());
        return nodesString.toString();
    }

    public boolean isAcceptingSet(Set<BuechiAutomatonNode> buechiStates) {
        for (List<BuechiAutomatonNode> accepting : this.acceptingStateSets) {
            LinkedHashSet<BuechiAutomatonNode> acceptingSet = new LinkedHashSet<BuechiAutomatonNode>(accepting);
            if (!Collections.disjoint(acceptingSet, buechiStates)) continue;
            return false;
        }
        return true;
    }

    public Set<BuechiAutomatonNode> getFinalNodeSet() {
        return this.nodeSet;
    }

    public Set<BuechiAutomatonNode> getInitialStates() {
        return this.initialStates;
    }
}

