/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.PredicateNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class QuantifiedPredicateNode
extends PredicateNode {
    private static final Map<Integer, QuantifiedPredicateOperator> map = new HashMap<Integer, QuantifiedPredicateOperator>();
    private List<DeclarationNode> declarationList;
    private PredicateNode predicateNode;
    private QuantifiedPredicateOperator operator;

    public QuantifiedPredicateNode(BMoThParser.QuantifiedPredicateContext ctx, List<DeclarationNode> declarationList, PredicateNode predNode) {
        super((ParseTree)ctx);
        this.declarationList = declarationList;
        this.predicateNode = predNode;
        this.operator = this.lookUpOperator(ctx.operator.getType());
    }

    private QuantifiedPredicateOperator lookUpOperator(int type) {
        if (map.containsKey(type)) {
            return map.get(type);
        }
        throw new AssertionError((Object)"Operator not implemented");
    }

    public List<DeclarationNode> getDeclarationList() {
        return this.declarationList;
    }

    public PredicateNode getPredicateNode() {
        return this.predicateNode;
    }

    public QuantifiedPredicateOperator getOperator() {
        return this.operator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.operator == QuantifiedPredicateOperator.EXISTENTIAL_QUANTIFICATION) {
            sb.append("EXISTS(");
        } else if (this.operator == QuantifiedPredicateOperator.UNIVERSAL_QUANTIFICATION) {
            sb.append("FORALL(");
        }
        sb.append(this.declarationList.stream().map(Object::toString).collect(Collectors.joining(",")));
        sb.append(",");
        sb.append(this.predicateNode);
        sb.append(")");
        return sb.toString();
    }

    public void setPredicate(PredicateNode pred) {
        this.predicateNode = pred;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        QuantifiedPredicateNode that = (QuantifiedPredicateNode)other;
        return this.operator.equals((Object)that.operator) && this.predicateNode.equalAst(that.predicateNode) && NodeUtil.equalAst(this.declarationList, that.declarationList);
    }

    static {
        map.put(37, QuantifiedPredicateOperator.UNIVERSAL_QUANTIFICATION);
        map.put(38, QuantifiedPredicateOperator.EXISTENTIAL_QUANTIFICATION);
    }

    public static enum QuantifiedPredicateOperator {
        UNIVERSAL_QUANTIFICATION,
        EXISTENTIAL_QUANTIFICATION;

    }
}

