/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.OperatorNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;

public class PredicateOperatorWithExprArgsNode
extends PredicateNode
implements OperatorNode<PredOperatorExprArgs> {
    private static final Map<Integer, PredOperatorExprArgs> map = new HashMap<Integer, PredOperatorExprArgs>();
    private List<ExprNode> expressionNodes;
    private String operatorString;
    private PredOperatorExprArgs operator;

    public PredicateOperatorWithExprArgsNode(BMoThParser.PredicateOperatorWithExprArgsContext ctx, List<ExprNode> expressionNodes) {
        super((ParseTree)ctx);
        this.expressionNodes = expressionNodes;
        this.operatorString = ctx.operator.getText();
        this.operator = this.loopUpOperator(ctx.operator.getType());
    }

    public PredicateOperatorWithExprArgsNode(ParseTree ctx, PredOperatorExprArgs operator, List<ExprNode> expressionNodes) {
        super(ctx);
        this.expressionNodes = expressionNodes;
        this.operator = operator;
    }

    private PredOperatorExprArgs loopUpOperator(int type) {
        if (map.containsKey(type)) {
            return map.get(type);
        }
        throw new AssertionError((Object)("Operator not implemented: " + this.operatorString));
    }

    @Override
    public PredOperatorExprArgs getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(PredOperatorExprArgs operator) {
        this.operator = operator;
    }

    public List<ExprNode> getExpressionNodes() {
        return this.expressionNodes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.name()).append("(");
        Iterator<ExprNode> iter = this.expressionNodes.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public void setArgumentsList(List<ExprNode> argumentList) {
        this.expressionNodes = argumentList;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        PredicateOperatorWithExprArgsNode that = (PredicateOperatorWithExprArgsNode)other;
        return this.operator.equals((Object)that.operator) && NodeUtil.equalAst(this.expressionNodes, that.expressionNodes);
    }

    static {
        map.put(86, PredOperatorExprArgs.EQUAL);
        map.put(88, PredOperatorExprArgs.NOT_EQUAL);
        map.put(90, PredOperatorExprArgs.ELEMENT_OF);
        map.put(89, PredOperatorExprArgs.ELEMENT_OF);
        map.put(97, PredOperatorExprArgs.LESS_EQUAL);
        map.put(96, PredOperatorExprArgs.LESS);
        map.put(99, PredOperatorExprArgs.GREATER_EQUAL);
        map.put(98, PredOperatorExprArgs.GREATER);
        map.put(95, PredOperatorExprArgs.NOT_BELONGING);
        map.put(91, PredOperatorExprArgs.INCLUSION);
        map.put(92, PredOperatorExprArgs.STRICT_INCLUSION);
        map.put(93, PredOperatorExprArgs.NON_INCLUSION);
        map.put(94, PredOperatorExprArgs.STRICT_NON_INCLUSION);
    }

    public static enum PredOperatorExprArgs {
        EQUAL,
        NOT_EQUAL,
        ELEMENT_OF,
        LESS_EQUAL,
        LESS,
        GREATER_EQUAL,
        GREATER,
        NOT_BELONGING,
        INCLUSION,
        STRICT_INCLUSION,
        NON_INCLUSION,
        STRICT_NON_INCLUSION;

    }
}

