/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.OperatorNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;

public class PredicateOperatorNode
extends PredicateNode
implements OperatorNode<PredicateOperator> {
    private static final Map<Integer, PredicateOperator> map = new HashMap<Integer, PredicateOperator>();
    private List<PredicateNode> predicateArguments;
    private String operatorString;
    private PredicateOperator operator;

    public PredicateOperatorNode(BMoThParser.PredicateOperatorContext ctx, List<PredicateNode> predicateArguments) {
        super((ParseTree)ctx);
        this.predicateArguments = predicateArguments;
        this.operatorString = ctx.operator.getText();
        this.setOperator(this.lookUpOperator(ctx.operator.getType()));
    }

    public PredicateOperatorNode(ParseTree ctx, PredicateOperator operator, List<PredicateNode> predicateArguments) {
        super(ctx);
        this.predicateArguments = predicateArguments;
        this.operator = operator;
    }

    private PredicateOperator lookUpOperator(int type) {
        if (map.containsKey(type)) {
            return map.get(type);
        }
        throw new AssertionError((Object)("Operator not implemented: " + this.operatorString));
    }

    public List<PredicateNode> getPredicateArguments() {
        return this.predicateArguments;
    }

    @Override
    public PredicateOperator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(PredicateOperator operator) {
        this.operator = operator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.name());
        Iterator<PredicateNode> iter = this.predicateArguments.iterator();
        if (iter.hasNext()) {
            sb.append("(");
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public void setPredicateList(List<PredicateNode> list) {
        this.predicateArguments = list;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        PredicateOperatorNode that = (PredicateOperatorNode)other;
        return this.operator.equals((Object)that.operator) && NodeUtil.equalAst(this.predicateArguments, that.predicateArguments);
    }

    static {
        map.put(64, PredicateOperator.AND);
        map.put(65, PredicateOperator.OR);
        map.put(43, PredicateOperator.IMPLIES);
        map.put(42, PredicateOperator.EQUIVALENCE);
        map.put(62, PredicateOperator.NOT);
        map.put(100, PredicateOperator.TRUE);
        map.put(101, PredicateOperator.FALSE);
    }

    public static enum PredicateOperator {
        AND,
        OR,
        IMPLIES,
        EQUIVALENCE,
        NOT,
        TRUE,
        FALSE;

    }
}

