/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OperationNode
implements Node {
    private final String name;
    private final List<DeclarationNode> outputParams;
    private final List<DeclarationNode> params;
    private SubstitutionNode substitution;

    public OperationNode(String name, List<DeclarationNode> outputParamNodes, SubstitutionNode substitution, List<DeclarationNode> paramNodes) {
        this.name = name;
        this.substitution = substitution;
        this.outputParams = outputParamNodes;
        this.params = paramNodes;
    }

    public String getName() {
        return this.name;
    }

    public SubstitutionNode getSubstitution() {
        return this.substitution;
    }

    public void setSubstitution(SubstitutionNode substitution) {
        this.substitution = substitution;
    }

    public String toString() {
        if (this.substitution instanceof SingleAssignSubstitutionNode) {
            return this.name + " = BEGIN " + this.substitution + " END";
        }
        return this.name + " = " + this.substitution;
    }

    public Set<DeclarationNode> getAssignedDeclarationNodes() {
        return new HashSet<DeclarationNode>(this.substitution.getAssignedVariables());
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        OperationNode that = (OperationNode)other;
        return this.name.equals(that.name) && this.substitution.equalAst(that.substitution);
    }

    public List<DeclarationNode> getOutputParams() {
        return this.outputParams;
    }

    public List<DeclarationNode> getParams() {
        return this.params;
    }
}

