/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.OperatorNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExpressionOperatorNode
extends ExprNode
implements OperatorNode<ExpressionOperator> {
    private static final Map<Integer, ExpressionOperator> map = new HashMap<Integer, ExpressionOperator>();
    private List<ExprNode> expressionNodes;
    private String operatorString;
    private ExpressionOperator operator;

    public ExpressionOperatorNode(BMoThParser.ExpressionOperatorContext ctx, List<ExprNode> expressionNodes, String operatorString) {
        super((ParseTree)ctx);
        this.expressionNodes = expressionNodes;
        this.operatorString = operatorString;
        this.operator = this.loopUpOperator(ctx.operator.getType());
    }

    public ExpressionOperatorNode(ParserRuleContext parseTree, List<ExprNode> expressionNodes, ExpressionOperator operator) {
        super((ParseTree)parseTree);
        this.expressionNodes = expressionNodes;
        this.operatorString = null;
        this.operator = operator;
    }

    private ExpressionOperator loopUpOperator(int type) {
        if (type == 50) {
            if (this.expressionNodes.size() == 1) {
                return ExpressionOperator.UNARY_MINUS;
            }
            return ExpressionOperator.MINUS;
        }
        if (map.containsKey(type)) {
            return map.get(type);
        }
        throw new AssertionError((Object)("Operator not implemented: " + this.operatorString));
    }

    @Override
    public ExpressionOperator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ExpressionOperator operator) {
        this.operator = operator;
    }

    public List<ExprNode> getExpressionNodes() {
        return this.expressionNodes;
    }

    public int getArity() {
        return this.expressionNodes.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.name());
        Iterator<ExprNode> iter = this.expressionNodes.iterator();
        if (iter.hasNext()) {
            sb.append("(");
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public void setExpressionList(List<ExprNode> list) {
        this.expressionNodes = list;
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        ExpressionOperatorNode that = (ExpressionOperatorNode)other;
        return this.operator.equals((Object)that.operator) && NodeUtil.equalAst(this.expressionNodes, that.expressionNodes);
    }

    static {
        map.put(52, ExpressionOperator.PLUS);
        map.put(133, ExpressionOperator.NATURAL);
        map.put(134, ExpressionOperator.NATURAL1);
        map.put(135, ExpressionOperator.INTEGER);
        map.put(137, ExpressionOperator.NAT);
        map.put(138, ExpressionOperator.NAT1);
        map.put(136, ExpressionOperator.INT);
        map.put(140, ExpressionOperator.MININT);
        map.put(141, ExpressionOperator.MAXINT);
        map.put(139, ExpressionOperator.BOOL);
        map.put(100, ExpressionOperator.TRUE);
        map.put(101, ExpressionOperator.FALSE);
        map.put(84, ExpressionOperator.POWER_OF);
        map.put(81, ExpressionOperator.MULT);
        map.put(82, ExpressionOperator.DIVIDE);
        map.put(83, ExpressionOperator.MOD);
        map.put(51, ExpressionOperator.SET_SUBTRACTION);
        map.put(85, ExpressionOperator.INTERVAL);
        map.put(79, ExpressionOperator.UNION);
        map.put(75, ExpressionOperator.INTERSECTION);
        map.put(78, ExpressionOperator.COUPLE);
        map.put(114, ExpressionOperator.DOMAIN);
        map.put(115, ExpressionOperator.RANGE);
        map.put(125, ExpressionOperator.MIN);
        map.put(124, ExpressionOperator.MAX);
        map.put(66, ExpressionOperator.OVERWRITE_RELATION);
        map.put(67, ExpressionOperator.DIRECT_PRODUCT);
        map.put(68, ExpressionOperator.CONCAT);
        map.put(69, ExpressionOperator.DOMAIN_RESTRICTION);
        map.put(70, ExpressionOperator.DOMAIN_SUBTRACTION);
        map.put(71, ExpressionOperator.RANGE_RESTRICTION);
        map.put(72, ExpressionOperator.RANGE_SUBTRATION);
        map.put(54, ExpressionOperator.INVERSE_RELATION);
        map.put(102, ExpressionOperator.SET_RELATION);
        map.put(131, ExpressionOperator.GENERALIZED_UNION);
        map.put(132, ExpressionOperator.GENERALIZED_INTER);
        map.put(116, ExpressionOperator.CARD);
        map.put(118, ExpressionOperator.FIRST);
        map.put(123, ExpressionOperator.LAST);
        map.put(119, ExpressionOperator.FRONT);
        map.put(130, ExpressionOperator.TAIL);
        map.put(117, ExpressionOperator.CONC);
        map.put(73, ExpressionOperator.INSERT_FRONT);
        map.put(74, ExpressionOperator.INSERT_TAIL);
        map.put(76, ExpressionOperator.RESTRICT_FRONT);
        map.put(77, ExpressionOperator.RESTRICT_TAIL);
        map.put(128, ExpressionOperator.SEQ);
        map.put(129, ExpressionOperator.SEQ1);
        map.put(121, ExpressionOperator.ISEQ);
        map.put(122, ExpressionOperator.ISEQ1);
    }

    public static enum ExpressionOperator {
        NATURAL,
        NATURAL1,
        INTEGER,
        INT,
        NAT,
        NAT1,
        MININT,
        MAXINT,
        BOOL,
        TRUE,
        FALSE,
        POWER_OF,
        PLUS,
        MINUS,
        MULT,
        DIVIDE,
        MOD,
        INTERVAL,
        UNARY_MINUS,
        MAX,
        MIN,
        SET_ENUMERATION,
        EMPTY_SET,
        SET_SUBTRACTION,
        UNION,
        INTERSECTION,
        GENERALIZED_UNION,
        GENERALIZED_INTER,
        DOMAIN,
        RANGE,
        CARTESIAN_PRODUCT,
        CARD,
        DOMAIN_RESTRICTION,
        OVERWRITE_RELATION,
        DIRECT_PRODUCT,
        DOMAIN_SUBTRACTION,
        RANGE_RESTRICTION,
        RANGE_SUBTRATION,
        INVERSE_RELATION,
        SET_RELATION,
        FUNCTION_CALL,
        FIRST,
        LAST,
        FRONT,
        TAIL,
        CONC,
        SEQ_ENUMERATION,
        EMPTY_SEQUENCE,
        CONCAT,
        INSERT_FRONT,
        INSERT_TAIL,
        RESTRICT_FRONT,
        RESTRICT_TAIL,
        SEQ,
        SEQ1,
        ISEQ,
        ISEQ1,
        COUPLE;

    }
}

