/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import java.util.List;
import java.util.stream.Collectors;

public class EnumeratedSetDeclarationNode
implements Node {
    final DeclarationNode setDeclaration;
    final List<DeclarationNode> elements;

    public EnumeratedSetDeclarationNode(DeclarationNode setDeclaration, List<DeclarationNode> elements) {
        this.setDeclaration = setDeclaration;
        this.elements = elements;
    }

    public DeclarationNode getSetDeclaration() {
        return this.setDeclaration;
    }

    public List<DeclarationNode> getElements() {
        return this.elements;
    }

    public List<String> getElementsAsStrings() {
        return this.elements.stream().map(DeclarationNode::getName).collect(Collectors.toList());
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        EnumeratedSetDeclarationNode that = (EnumeratedSetDeclarationNode)other;
        return this.setDeclaration.equalAst(that.setDeclaration) && NodeUtil.equalAst(this.elements, that.elements);
    }
}

