/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.nodes;

import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NodeUtil;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import java.util.List;
import java.util.stream.Collectors;

public class BecomesSuchThatSubstitutionNode
extends SubstitutionNode {
    private List<IdentifierExprNode> identifiers;
    private PredicateNode predicate;

    public BecomesSuchThatSubstitutionNode(List<IdentifierExprNode> identifiers, PredicateNode predicate) {
        this.identifiers = identifiers;
        this.predicate = predicate;
        super.setAssignedVariables(identifiers.stream().map(IdentifierExprNode::getDeclarationNode).collect(Collectors.toSet()));
    }

    public List<IdentifierExprNode> getIdentifiers() {
        return this.identifiers;
    }

    public PredicateNode getPredicate() {
        return this.predicate;
    }

    public void setPredicate(PredicateNode predicate) {
        this.predicate = predicate;
    }

    public String toString() {
        return this.identifiers.stream().map(Object::toString).collect(Collectors.joining(",")) + " :( " + this.predicate + ")";
    }

    @Override
    public boolean equalAst(Node other) {
        if (!NodeUtil.isSameClass(this, other)) {
            return false;
        }
        BecomesSuchThatSubstitutionNode that = (BecomesSuchThatSubstitutionNode)other;
        return this.predicate.equalAst(that.predicate) && NodeUtil.equalAst(this.identifiers, that.identifiers);
    }
}

