/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser;

import de.bmoth.antlr.BMoThLexer;
import de.bmoth.antlr.BMoThParser;
import de.bmoth.parser.ErrorListener;
import de.bmoth.parser.ParseErrorException;
import de.bmoth.parser.ParserException;
import de.bmoth.parser.ast.SemanticAstCreator;
import de.bmoth.parser.ast.TypeChecker;
import de.bmoth.parser.ast.TypeErrorException;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.ltl.LTLFormula;
import de.bmoth.parser.cst.CSTAnalyser;
import de.bmoth.parser.cst.FormulaAnalyser;
import de.bmoth.parser.cst.LTLFormulaAnalyser;
import de.bmoth.parser.cst.MachineAnalyser;
import de.bmoth.parser.cst.ScopeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class Parser {
    private static final String PARSE_ERROR = "PARSE_ERROR";

    private BMoThParser getParser(String inputString) {
        CodePointCharStream fromString = CharStreams.fromString((String)inputString);
        BMoThLexer lexer = new BMoThLexer((CharStream)fromString);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BMoThParser bMoThParser = new BMoThParser((TokenStream)tokens);
        bMoThParser.removeErrorListeners();
        ErrorListener errorListener = new ErrorListener();
        bMoThParser.addErrorListener((ANTLRErrorListener)errorListener);
        return bMoThParser;
    }

    private BMoThParser.StartContext parseMachine(String inputString) throws ParseErrorException {
        BMoThParser parser = this.getParser(inputString);
        try {
            return parser.start();
        }
        catch (ErrorListener.VisitorException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, PARSE_ERROR, e);
            throw e.getParseErrorException();
        }
    }

    private BMoThParser.FormulaContext parseFormula(String inputString) throws ParseErrorException {
        BMoThParser parser = this.getParser(inputString);
        try {
            return parser.formula();
        }
        catch (ErrorListener.VisitorException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, PARSE_ERROR, e);
            throw e.getParseErrorException();
        }
    }

    private BMoThParser.LtlStartContext parseLTLFormula(String inputString) throws ParseErrorException {
        CodePointCharStream fromString = CharStreams.fromString((String)inputString);
        BMoThLexer lexer = new BMoThLexer((CharStream)fromString);
        lexer.pushMode(1);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        BMoThParser parser = new BMoThParser((TokenStream)tokens);
        parser.removeErrorListeners();
        ErrorListener errorListener = new ErrorListener();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        try {
            return parser.ltlStart();
        }
        catch (ErrorListener.VisitorException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, PARSE_ERROR, e);
            throw e.getParseErrorException();
        }
    }

    public static BMoThParser.LtlStartContext getLTLFormulaAsCST(String string) throws ParseErrorException {
        Parser parser = new Parser();
        return parser.parseLTLFormula(string);
    }

    private MachineNode getMachineAst(BMoThParser.StartContext start) throws ScopeException, ParseErrorException {
        MachineAnalyser machineAnalyser = new MachineAnalyser(start);
        SemanticAstCreator astCreator = new SemanticAstCreator(machineAnalyser);
        return (MachineNode)astCreator.getAstNode();
    }

    private FormulaNode getFormulaAst(BMoThParser.FormulaContext formula) throws ScopeException {
        FormulaAnalyser formulaAnalyser = new FormulaAnalyser(formula);
        SemanticAstCreator astCreator = new SemanticAstCreator(formulaAnalyser);
        return (FormulaNode)astCreator.getAstNode();
    }

    private LTLFormula getLTLFormulaAst(BMoThParser.LtlStartContext context) throws ScopeException {
        LTLFormulaAnalyser formulaAnalyser = new LTLFormulaAnalyser(context);
        SemanticAstCreator astCreator = new SemanticAstCreator(formulaAnalyser);
        return (LTLFormula)astCreator.getAstNode();
    }

    public static MachineNode getMachineFileAsSemanticAst(String file) throws ParserException {
        try {
            String fileContent = Parser.readFile(new File(file));
            return Parser.getMachineAsSemanticAst(fileContent);
        }
        catch (IOException e) {
            throw new ParserException(e);
        }
    }

    public static MachineNode getMachineAsSemanticAst(String inputString) throws ParserException {
        Parser parser = new Parser();
        try {
            BMoThParser.StartContext start = parser.parseMachine(inputString);
            List<String> warnings = CSTAnalyser.analyseConcreteSyntaxTree(start);
            MachineNode machineNode = parser.getMachineAst(start);
            machineNode.setWarnings(warnings);
            TypeChecker.typecheckMachineNode(machineNode);
            return machineNode;
        }
        catch (ParseErrorException | TypeErrorException | ScopeException e) {
            throw new ParserException(e);
        }
    }

    public static FormulaNode getFormulaAsSemanticAst(String inputString) throws ParserException {
        Parser parser = new Parser();
        try {
            BMoThParser.FormulaContext formulaContext = parser.parseFormula(inputString);
            List<String> warnings = CSTAnalyser.analyseConcreteSyntaxTree(formulaContext);
            FormulaNode formulaNode = parser.getFormulaAst(formulaContext);
            formulaNode.setWarnings(warnings);
            TypeChecker.typecheckFormulaNode(formulaNode);
            return formulaNode;
        }
        catch (ParseErrorException | TypeErrorException | ScopeException e) {
            throw new ParserException(e);
        }
    }

    public static LTLFormula getLTLFormulaAsSemanticAst(String inputString) throws ParserException {
        Parser parser = new Parser();
        try {
            BMoThParser.LtlStartContext context = parser.parseLTLFormula(inputString);
            LTLFormula ltlFormulaAst = parser.getLTLFormulaAst(context);
            TypeChecker.typecheckLTLFormulaNode(ltlFormulaAst);
            return ltlFormulaAst;
        }
        catch (ParseErrorException | TypeErrorException | ScopeException e) {
            throw new ParserException(e);
        }
    }

    static String readFile(File file) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));){
            int read;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[1024];
            while ((read = inputStreamReader.read(buffer)) >= 0) {
                builder.append(String.valueOf(buffer, 0, read));
            }
            String content = builder.toString();
            if (!content.isEmpty()) {
                if (content.startsWith("\ufeff")) {
                    content = content.substring(1);
                } else if (content.startsWith("\u00ef\u00bb\u00bf")) {
                    content = content.substring(3);
                }
            }
            String string = content.replaceAll("\r\n", "\n");
            return string;
        }
    }
}

