/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker.esmc;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import de.bmoth.backend.TranslationOptions;
import de.bmoth.backend.ltl.LTLTransformations;
import de.bmoth.backend.z3.FormulaToZ3Translator;
import de.bmoth.backend.z3.SolutionFinder;
import de.bmoth.backend.z3.Z3SolverFactory;
import de.bmoth.modelchecker.ModelChecker;
import de.bmoth.modelchecker.ModelCheckingResult;
import de.bmoth.modelchecker.State;
import de.bmoth.modelchecker.StateSpace;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.ltl.BuechiAutomaton;
import de.bmoth.parser.ast.nodes.ltl.BuechiAutomatonNode;
import de.bmoth.parser.ast.nodes.ltl.LTLFormula;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.preferences.BMothPreferences;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.graph.DefaultEdge;

public class ExplicitStateModelChecker
extends ModelChecker {
    private Solver solver = Z3SolverFactory.getZ3Solver(this.getContext());
    private Solver opSolver = Z3SolverFactory.getZ3Solver(this.getContext());
    private Solver labelSolver = Z3SolverFactory.getZ3Solver(this.getContext());
    private SolutionFinder finder = new SolutionFinder(this.solver, this.getContext());
    private SolutionFinder opFinder = new SolutionFinder(this.opSolver, this.getContext());
    private Set<State> visited;
    private BuechiAutomaton buechiAutomaton;
    private StateSpace stateSpace;

    public ExplicitStateModelChecker(MachineNode machine) {
        super(machine);
        List<LTLFormula> ltlFormulas = machine.getLTLFormulas();
        if (ltlFormulas.size() == 1) {
            LTLPrefixOperatorNode negatedFormula = new LTLPrefixOperatorNode(LTLPrefixOperatorNode.Kind.NOT, ltlFormulas.get(0).getLTLNode());
            this.buechiAutomaton = new BuechiAutomaton(LTLTransformations.transformLTLNode(negatedFormula));
        } else {
            this.buechiAutomaton = null;
        }
    }

    public static ModelCheckingResult check(MachineNode machine) {
        ExplicitStateModelChecker modelChecker = new ExplicitStateModelChecker(machine);
        return modelChecker.check();
    }

    @Override
    public void abort() {
        super.abort();
        this.finder.abort();
        this.opFinder.abort();
    }

    @Override
    protected ModelCheckingResult doModelCheck() {
        int maxInitialStates = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INITIAL_STATE);
        int maxTransitions = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_TRANSITIONS);
        this.stateSpace = new StateSpace();
        this.visited = new HashSet<State>();
        LinkedList queue = new LinkedList();
        BoolExpr initialValueConstraint = this.getMachineTranslator().getInitialValueConstraint();
        Set<Model> models = this.finder.findSolutions(initialValueConstraint, maxInitialStates);
        models.stream().map(this::getStateFromModel).filter(this::isUnknown).forEach(root -> {
            this.stateSpace.addRootVertex((State)root);
            queue.add(root);
        });
        BoolExpr invariant = this.getMachineTranslator().getInvariantConstraint();
        this.solver.add(new BoolExpr[]{invariant});
        BoolExpr operationsConstraint = this.getMachineTranslator().getCombinedOperationConstraint();
        this.opSolver.add(new BoolExpr[]{operationsConstraint});
        while (!this.isAborted() && !queue.isEmpty()) {
            this.solver.push();
            State current = (State)queue.poll();
            this.visited.add(current);
            BoolExpr stateConstraint = current.getStateConstraint(this.getContext());
            this.solver.add(new BoolExpr[]{stateConstraint});
            Status check = this.solver.check();
            switch (check) {
                case UNKNOWN: {
                    return ModelCheckingResult.createUnknown(this.visited.size(), this.solver.getReasonUnknown());
                }
                case UNSATISFIABLE: {
                    return ModelCheckingResult.createCounterExampleFound(this.visited.size(), current, this.stateSpace);
                }
            }
            models = this.opFinder.findSolutions(stateConstraint, maxTransitions);
            models.stream().map(this::getStateFromModel).forEach(successor -> {
                if (this.isUnknown((State)successor)) {
                    this.stateSpace.addVertex(successor);
                    queue.add(successor);
                }
                this.stateSpace.addEdge(current, successor);
            });
            this.solver.pop();
        }
        if (this.isAborted()) {
            return ModelCheckingResult.createAborted(this.visited.size());
        }
        ModelCheckingResult resultVerified = ModelCheckingResult.createVerified(this.visited.size(), this.stateSpace);
        if (this.buechiAutomaton != null) {
            this.labelStateSpace();
            List cycles = new TarjanSimpleCycles((DirectedGraph)this.stateSpace).findSimpleCycles();
            for (List cycle : cycles) {
                for (State state : cycle) {
                    if (!this.buechiAutomaton.isAcceptingSet(state.getBuechiNodes())) continue;
                    return ModelCheckingResult.createLTLCounterExampleFound(this.visited.size(), state);
                }
            }
        }
        return resultVerified;
    }

    private void labelStateSpace() {
        ArrayDeque statesToUpdate = new ArrayDeque();
        statesToUpdate.addAll(this.stateSpace.vertexSet());
        while (!statesToUpdate.isEmpty()) {
            State current = (State)statesToUpdate.poll();
            HashSet<BuechiAutomatonNode> buechiNodes = new HashSet<BuechiAutomatonNode>();
            HashSet<BuechiAutomatonNode> candidates = new HashSet<BuechiAutomatonNode>();
            if (this.stateSpace.rootVertexSet().contains(current)) {
                candidates.addAll(this.buechiAutomaton.getInitialStates());
            } else {
                Set incomingEdges = this.stateSpace.incomingEdgesOf(current);
                for (DefaultEdge incomingEdge : incomingEdges) {
                    State predecessor = (State)this.stateSpace.getEdgeSource(incomingEdge);
                    predecessor.getBuechiNodes().forEach(n -> candidates.addAll(n.getSuccessors()));
                }
            }
            for (BuechiAutomatonNode node : candidates) {
                if (node.getLabels().isEmpty()) {
                    buechiNodes.add(node);
                }
                for (PredicateNode label : node.getLabels()) {
                    this.labelSolver.reset();
                    this.labelSolver.add(new BoolExpr[]{FormulaToZ3Translator.translatePredicate(label, this.getContext(), this.getMachineTranslator().getZ3TypeInference())});
                    this.labelSolver.add(new BoolExpr[]{current.getStateConstraint(this.getContext())});
                    Status status = this.labelSolver.check();
                    switch (status) {
                        case UNSATISFIABLE: {
                            break;
                        }
                        case UNKNOWN: {
                            throw new UnsupportedOperationException("should not be undefined");
                        }
                        case SATISFIABLE: {
                            buechiNodes.add(node);
                        }
                    }
                }
            }
            buechiNodes.stream().filter(n -> !current.getBuechiNodes().contains(n)).forEach(newBuechiNode -> {
                current.addBuechiNode((BuechiAutomatonNode)newBuechiNode);
                Set outgoingEdges = this.stateSpace.outgoingEdgesOf(current);
                for (DefaultEdge outgoingEdge : outgoingEdges) {
                    State successor = (State)this.stateSpace.getEdgeTarget(outgoingEdge);
                    if (statesToUpdate.contains(successor)) continue;
                    statesToUpdate.add(successor);
                }
            });
        }
    }

    private State getStateFromModel(Model model) {
        return this.getStateFromModel(model, TranslationOptions.PRIMED_0);
    }

    private boolean isUnknown(State state) {
        return !this.stateSpace.containsVertex(state) && !this.visited.contains(state);
    }
}

