/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker.bmc;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import de.bmoth.backend.z3.Z3SolverFactory;
import de.bmoth.modelchecker.ModelCheckingResult;
import de.bmoth.modelchecker.State;
import de.bmoth.modelchecker.SymbolicModelChecker;
import de.bmoth.parser.ast.nodes.MachineNode;

public class BoundedModelChecker
extends SymbolicModelChecker {
    private final Solver solver = Z3SolverFactory.getZ3Solver(this.getContext());

    public BoundedModelChecker(MachineNode machine, int maxSteps) {
        super(machine, maxSteps);
    }

    @Override
    protected ModelCheckingResult doModelCheck() {
        for (int k = 0; k < this.maxSteps; ++k) {
            this.solver.reset();
            this.solver.add(new BoolExpr[]{this.init()});
            for (int i = 1; i <= k; ++i) {
                this.solver.add(new BoolExpr[]{this.transition(i - 1, i)});
            }
            this.solver.add(new BoolExpr[]{this.negatedInvariant(k)});
            this.solver.add(new BoolExpr[]{this.distinctVectors(k)});
            Status check = this.solver.check();
            if (check != Status.SATISFIABLE) continue;
            State counterExample = this.getStateFromModel(this.solver.getModel(), k);
            return ModelCheckingResult.createCounterExampleFound(k, counterExample, this.solver.getModel());
        }
        return ModelCheckingResult.createExceededMaxSteps(this.maxSteps);
    }
}

