/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.modelchecker;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.Sort;
import de.bmoth.parser.ast.nodes.ltl.BuechiAutomatonNode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class State {
    private final Map<String, Expr> values;
    private final Set<BuechiAutomatonNode> buechiNodes = new HashSet<BuechiAutomatonNode>();

    public State(Map<String, Expr> values) {
        this.values = values;
    }

    public String toString() {
        return this.values.toString();
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof State)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        State that = (State)obj;
        return this.values.equals(that.values);
    }

    public BoolExpr getStateConstraint(Context context) {
        BoolExpr[] result = (BoolExpr[])this.values.entrySet().stream().map(entry -> {
            Expr singleExpression = (Expr)entry.getValue();
            Sort sort = singleExpression.getSort();
            Expr identifierExpr = context.mkConst((String)entry.getKey(), sort);
            return context.mkEq(identifierExpr, singleExpression);
        }).toArray(BoolExpr[]::new);
        switch (result.length) {
            case 0: {
                return null;
            }
            case 1: {
                return result[0];
            }
        }
        return context.mkAnd(result);
    }

    public Map<String, Expr> getValues() {
        return this.values;
    }

    public Set<BuechiAutomatonNode> getBuechiNodes() {
        return this.buechiNodes;
    }

    public void addBuechiNode(BuechiAutomatonNode newNode) {
        this.buechiNodes.add(newNode);
    }
}

