/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.cli;

import de.bmoth.cli.CliGetopt;
import de.bmoth.cli.CliOption;
import de.bmoth.cli.CliTask;
import java.io.File;

public class CliApplication {
    private static void help() {
        System.out.print("bmoth-cli - BMoTH command line interface\n\n");
        System.out.print("Usage example:\n");
        System.out.print("bmoth-cli (-h|--help)|(-m|--machine) mch-file [(-a|--algorithm) esmc|bmc|kind] [(-b|--benchmark)] [(-s|--max-steps)]\n\n");
        System.out.print("Options:\n");
        System.out.print("-h or --help:             Displays this information.\n");
        System.out.print("-m or --machine string:   Machine file to be model checked.\n");
        System.out.print("-a or --algorithm string: Specify the algorithm used for model checking. (default: esmc).\n");
        System.out.print("-b or --benchmark:        Enable benchmark mode.\n");
        System.out.print("-s or --max-steps:        Optional for bmc|kind max # steps before aborting. (default: 20)\n");
        System.out.print("-t or --times:            Specify the number of times the benchmark is executed. (default: 1)\n");
        System.out.print("-f or --file:             Specify a file that the benchmark results will be written to.\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        CliTask task = new CliTask();
        CliGetopt g = new CliGetopt(args);
        CliOption option = g.getopt();
        while (option != null) {
            switch (option) {
                case ALGORITHM: {
                    task.setAlgorithm(g.getOptarg());
                    break;
                }
                case BENCHMARK: {
                    task.setIsBenchmark();
                    break;
                }
                case MACHINE: {
                    task.setMachineFile(new File(g.getOptarg()));
                    break;
                }
                case STEPS: {
                    task.setMaxSteps(Integer.parseInt(g.getOptarg()));
                    break;
                }
                case TIMES: {
                    task.setTimes(Integer.parseInt(g.getOptarg()));
                    break;
                }
                case FILE: {
                    task.setResultFileName(g.getOptarg());
                    break;
                }
                default: {
                    CliApplication.help();
                }
            }
            option = g.getopt();
        }
        task.execute();
    }
}

