/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3.transformation;

import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.visitors.ASTTransformation;
import de.bmoth.preferences.BMothPreferences;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;

public class ConvertMemberOfIntegerSetToLeqGeq
implements ASTTransformation {
    @Override
    public boolean canHandleNode(Node node) {
        return node instanceof PredicateOperatorWithExprArgsNode;
    }

    @Override
    public Node transformNode(Node node2) {
        PredicateOperatorWithExprArgsNode node = (PredicateOperatorWithExprArgsNode)node2;
        if (node.getOperator() == PredicateOperatorWithExprArgsNode.PredOperatorExprArgs.ELEMENT_OF) {
            ExprNode left = node.getExpressionNodes().get(0);
            ExprNode right = node.getExpressionNodes().get(1);
            if (right instanceof ExpressionOperatorNode) {
                ExpressionOperatorNode castedRight = (ExpressionOperatorNode)right;
                switch (castedRight.getOperator()) {
                    case NATURAL: {
                        return new PredicateOperatorWithExprArgsNode(node.getParseTree(), PredicateOperatorWithExprArgsNode.PredOperatorExprArgs.GREATER_EQUAL, Arrays.asList(left, new NumberNode(right.getParseTree(), BigInteger.ZERO)));
                    }
                    case NATURAL1: {
                        return new PredicateOperatorWithExprArgsNode(node.getParseTree(), PredicateOperatorWithExprArgsNode.PredOperatorExprArgs.GREATER_EQUAL, Arrays.asList(left, new NumberNode(right.getParseTree(), BigInteger.ONE)));
                    }
                    case INTEGER: {
                        return new PredicateOperatorNode(node.getParseTree(), PredicateOperatorNode.PredicateOperator.TRUE, Collections.emptyList());
                    }
                    case INT: {
                        return this.upperAndLowerBoundsConstraint(node, left, right, BigInteger.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MIN_INT)));
                    }
                    case NAT: {
                        return this.upperAndLowerBoundsConstraint(node, left, right, BigInteger.ZERO);
                    }
                }
            }
        }
        return node;
    }

    private Node upperAndLowerBoundsConstraint(PredicateOperatorWithExprArgsNode node, ExprNode left, ExprNode right, BigInteger lowerBound) {
        PredicateOperatorWithExprArgsNode geq = new PredicateOperatorWithExprArgsNode(node.getParseTree(), PredicateOperatorWithExprArgsNode.PredOperatorExprArgs.GREATER_EQUAL, Arrays.asList(left, new NumberNode(right.getParseTree(), lowerBound)));
        PredicateOperatorWithExprArgsNode leq = new PredicateOperatorWithExprArgsNode(node.getParseTree(), PredicateOperatorWithExprArgsNode.PredOperatorExprArgs.LESS_EQUAL, Arrays.asList(left, new NumberNode(right.getParseTree(), BigInteger.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT)))));
        return new PredicateOperatorNode(node.getParseTree(), PredicateOperatorNode.PredicateOperator.AND, Arrays.asList(leq, geq));
    }
}

