/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3;

import com.microsoft.z3.Context;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Symbol;
import de.bmoth.parser.ast.nodes.AnySubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesElementOfSubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesSuchThatSubstitutionNode;
import de.bmoth.parser.ast.nodes.CastPredicateExpressionNode;
import de.bmoth.parser.ast.nodes.ConditionSubstitutionNode;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.DeferredSetNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetElementNode;
import de.bmoth.parser.ast.nodes.EnumerationSetNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IdentifierPredicateNode;
import de.bmoth.parser.ast.nodes.IfSubstitutionNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.ParallelSubstitutionNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.nodes.QuantifiedExpressionNode;
import de.bmoth.parser.ast.nodes.QuantifiedPredicateNode;
import de.bmoth.parser.ast.nodes.SelectSubstitutionNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SkipSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import de.bmoth.parser.ast.nodes.TypedNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLKeywordNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.parser.ast.types.BType;
import de.bmoth.parser.ast.types.BoolType;
import de.bmoth.parser.ast.types.CoupleType;
import de.bmoth.parser.ast.types.DeferredSetElementType;
import de.bmoth.parser.ast.types.EnumeratedSetElementType;
import de.bmoth.parser.ast.types.IntegerType;
import de.bmoth.parser.ast.types.SetType;
import de.bmoth.parser.ast.visitors.AbstractVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Z3TypeInference {
    Map<TypedNode, Z3Type> types = new HashMap<TypedNode, Z3Type>();
    Map<DeclarationNode, Z3Type> declarationNodesTypes = new HashMap<DeclarationNode, Z3Type>();

    public void visitMachineNode(MachineNode machineNode) {
        Visitor visitor = new Visitor();
        if (machineNode.getProperties() != null) {
            visitor.visitPredicateNode(machineNode.getProperties(), null);
        }
        if (machineNode.getInitialisation() != null) {
            visitor.visitSubstitutionNode(machineNode.getInitialisation(), null);
        }
        machineNode.getOperations().forEach(op -> {
            Z3Type cfr_ignored_0 = (Z3Type)visitor.visitSubstitutionNode(op.getSubstitution(), null);
        });
        if (machineNode.getInvariant() != null) {
            visitor.visitPredicateNode(machineNode.getInvariant(), null);
        }
    }

    public void visitPredicateNode(PredicateNode node) {
        Visitor visitor = new Visitor();
        visitor.visitPredicateNode(node, null);
    }

    public Sort getZ3Sort(TypedNode node, Context z3Context) {
        if (this.declarationNodesTypes.containsKey(node)) {
            Z3Type z3Type = this.declarationNodesTypes.get(node);
            return this.getZ3Sort(z3Type, z3Context);
        }
        if (this.types.containsKey(node)) {
            Z3Type z3Type = this.types.get(node);
            return this.getZ3Sort(z3Type, z3Context);
        }
        return this.getZ3Sort(this.convertBTypeToZ3Type(node.getType()), z3Context);
    }

    public Sort getZ3Sort(BType bType, Context z3Context) {
        return this.getZ3Sort(this.convertBTypeToZ3Type(bType), z3Context);
    }

    public Sort getZ3Sort(Z3Type t, Context z3Context) {
        if (t instanceof Z3BasicType) {
            switch (((Z3BasicType)t).kind) {
                case INTEGER: {
                    return z3Context.getIntSort();
                }
                case BOOL: {
                    return z3Context.getBoolSort();
                }
            }
        } else {
            if (t instanceof Z3SetType) {
                Sort subSort = this.getZ3Sort(((Z3SetType)t).subtype, z3Context);
                return z3Context.mkSetSort(subSort);
            }
            if (t instanceof Z3CoupleType) {
                Z3CoupleType couple = (Z3CoupleType)t;
                Sort left = this.getZ3Sort(couple.left, z3Context);
                Sort right = this.getZ3Sort(couple.right, z3Context);
                Sort[] subSorts = new Sort[]{left, right};
                return z3Context.mkTupleSort((Symbol)z3Context.mkSymbol("couple"), new Symbol[]{z3Context.mkSymbol("left"), z3Context.mkSymbol("right")}, subSorts);
            }
            if (t instanceof Z3SequenceType) {
                Sort subSort = this.getZ3Sort(((Z3SequenceType)t).subtype, z3Context);
                IntSort intType = z3Context.getIntSort();
                Sort[] subSorts = new Sort[]{z3Context.mkArraySort((Sort)intType, subSort), intType};
                return z3Context.mkTupleSort((Symbol)z3Context.mkSymbol("sequence"), new Symbol[]{z3Context.mkSymbol("array"), z3Context.mkSymbol("size")}, subSorts);
            }
            if (t instanceof Z3DeferredType) {
                return z3Context.mkUninterpretedSort(((Z3DeferredType)t).name);
            }
            if (t instanceof Z3EnumeratedSetType) {
                List<String> elements = ((Z3EnumeratedSetType)t).elements;
                String[] array = elements.toArray(new String[elements.size()]);
                return z3Context.mkEnumSort(((Z3EnumeratedSetType)t).name, array);
            }
        }
        throw new AssertionError((Object)("Missing Type Conversion: " + t.getClass()));
    }

    protected Z3Type updateDeclarationType(DeclarationNode node, Z3Type newZ3Type) {
        if (this.declarationNodesTypes.containsKey(node)) {
            Z3Type z3Type = this.declarationNodesTypes.get(node);
            Z3Type unification = this.unify(z3Type, newZ3Type);
            this.declarationNodesTypes.put(node, unification);
            return unification;
        }
        this.declarationNodesTypes.put(node, newZ3Type);
        return newZ3Type;
    }

    private Z3Type unify(Z3Type z3Type, Z3Type newZ3Type) {
        if (z3Type instanceof Z3SequenceType && newZ3Type instanceof Z3SetType) {
            return newZ3Type;
        }
        if (newZ3Type instanceof Z3SequenceType && z3Type instanceof Z3SetType) {
            return z3Type;
        }
        return newZ3Type;
    }

    protected Z3Type setZ3Type(TypedNode node, Z3Type subType) {
        this.types.put(node, subType);
        return subType;
    }

    protected Z3Type getZ3TypeOfNode(TypedNode node) {
        if (this.types.containsKey(node)) {
            return this.types.get(node);
        }
        return this.convertBTypeToZ3Type(node.getType());
    }

    protected Z3Type convertBTypeToZ3Type(BType bType) {
        if (bType instanceof IntegerType) {
            return new Z3BasicType(Basic.INTEGER);
        }
        if (bType instanceof BoolType) {
            return new Z3BasicType(Basic.BOOL);
        }
        if (bType instanceof SetType) {
            BType subtype = ((SetType)bType).getSubType();
            return new Z3SetType(this.convertBTypeToZ3Type(subtype));
        }
        if (bType instanceof CoupleType) {
            CoupleType couple = (CoupleType)bType;
            return new Z3CoupleType(this.convertBTypeToZ3Type(couple.getLeft()), this.convertBTypeToZ3Type(couple.getRight()));
        }
        if (bType instanceof EnumeratedSetElementType) {
            EnumeratedSetElementType userType = (EnumeratedSetElementType)bType;
            return new Z3EnumeratedSetType(userType.getSetName(), userType.getElements());
        }
        if (bType instanceof DeferredSetElementType) {
            DeferredSetElementType deferred = (DeferredSetElementType)bType;
            return new Z3DeferredType(deferred.getSetName());
        }
        throw new AssertionError(bType);
    }

    class Visitor
    implements AbstractVisitor<Z3Type, Void> {
        Visitor() {
        }

        @Override
        public Z3Type visitExprOperatorNode(ExpressionOperatorNode node, Void expected) {
            List<ExprNode> arguments = node.getExpressionNodes();
            arguments.forEach(e -> {
                Z3Type cfr_ignored_0 = (Z3Type)this.visitExprNode((ExprNode)e, expected);
            });
            switch (node.getOperator()) {
                case FRONT: 
                case TAIL: 
                case CONCAT: 
                case INSERT_TAIL: 
                case RESTRICT_FRONT: 
                case RESTRICT_TAIL: {
                    return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.getZ3TypeOfNode(arguments.get(0)));
                }
                case INSERT_FRONT: {
                    return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.getZ3TypeOfNode(arguments.get(1)));
                }
                case SEQ_ENUMERATION: {
                    return Z3TypeInference.this.setZ3Type(node, new Z3SequenceType(Z3TypeInference.this.getZ3TypeOfNode(arguments.get(0))));
                }
                case EMPTY_SEQUENCE: {
                    SetType setType = (SetType)node.getType();
                    CoupleType c = (CoupleType)setType.getSubType();
                    return Z3TypeInference.this.setZ3Type(node, new Z3SequenceType(Z3TypeInference.this.convertBTypeToZ3Type(c.getRight())));
                }
            }
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitIdentifierExprNode(IdentifierExprNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitCastPredicateExpressionNode(CastPredicateExpressionNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitNumberNode(NumberNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitQuantifiedExpressionNode(QuantifiedExpressionNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getPredicateNode(), expected);
            this.visitExprNode(node.getExpressionNode(), expected);
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitSetComprehensionNode(SetComprehensionNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getPredicateNode(), expected);
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitIdentifierPredicateNode(IdentifierPredicateNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitPredicateOperatorNode(PredicateOperatorNode node, Void expected) {
            node.getPredicateArguments().forEach(e -> {
                Z3Type cfr_ignored_0 = (Z3Type)AbstractVisitor.super.visitPredicateNode((PredicateNode)e, expected);
            });
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitPredicateOperatorWithExprArgs(PredicateOperatorWithExprArgsNode node, Void expected) {
            List<ExprNode> arguments = node.getExpressionNodes();
            switch (node.getOperator()) {
                case EQUAL: 
                case NOT_EQUAL: {
                    ExprNode left = arguments.get(0);
                    ExprNode right = arguments.get(1);
                    if (left instanceof IdentifierExprNode) {
                        return Z3TypeInference.this.updateDeclarationType(((IdentifierExprNode)left).getDeclarationNode(), (Z3Type)this.visitExprNode(right, expected));
                    }
                    if (!(right instanceof IdentifierExprNode)) break;
                    return Z3TypeInference.this.updateDeclarationType(((IdentifierExprNode)right).getDeclarationNode(), (Z3Type)this.visitExprNode(left, expected));
                }
            }
            arguments.forEach(a -> {
                Z3Type cfr_ignored_0 = (Z3Type)this.visitExprNode((ExprNode)a, expected);
            });
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitQuantifiedPredicateNode(QuantifiedPredicateNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getPredicateNode(), expected);
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitSkipSubstitutionNode(SkipSubstitutionNode node, Void expected) {
            return null;
        }

        @Override
        public Z3Type visitIfSubstitutionNode(IfSubstitutionNode node, Void expected) {
            node.getConditions().forEach(t -> {
                Z3Type cfr_ignored_0 = (Z3Type)AbstractVisitor.super.visitPredicateNode((PredicateNode)t, expected);
            });
            node.getSubstitutions().forEach(t -> {
                Z3Type cfr_ignored_0 = (Z3Type)this.visitSubstitutionNode((SubstitutionNode)t, expected);
            });
            if (node.getElseSubstitution() != null) {
                this.visitSubstitutionNode(node.getElseSubstitution(), expected);
            }
            return null;
        }

        @Override
        public Z3Type visitConditionSubstitutionNode(ConditionSubstitutionNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getCondition(), expected);
            this.visitSubstitutionNode(node.getSubstitution(), expected);
            return null;
        }

        @Override
        public Z3Type visitAnySubstitution(AnySubstitutionNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getWherePredicate(), expected);
            this.visitSubstitutionNode(node.getThenSubstitution(), expected);
            return null;
        }

        @Override
        public Z3Type visitSelectSubstitutionNode(SelectSubstitutionNode node, Void expected) {
            node.getConditions().forEach(t -> {
                Z3Type cfr_ignored_0 = (Z3Type)AbstractVisitor.super.visitPredicateNode((PredicateNode)t, expected);
            });
            node.getSubstitutions().forEach(t -> {
                Z3Type cfr_ignored_0 = (Z3Type)this.visitSubstitutionNode((SubstitutionNode)t, expected);
            });
            if (node.getElseSubstitution() != null) {
                this.visitSubstitutionNode(node.getElseSubstitution(), expected);
            }
            return null;
        }

        @Override
        public Z3Type visitSingleAssignSubstitution(SingleAssignSubstitutionNode node, Void expected) {
            IdentifierExprNode identifier = node.getIdentifier();
            DeclarationNode declarationNode = identifier.getDeclarationNode();
            Z3Type exprType = (Z3Type)this.visitExprNode(node.getValue(), expected);
            return Z3TypeInference.this.updateDeclarationType(declarationNode, exprType);
        }

        @Override
        public Z3Type visitParallelSubstitutionNode(ParallelSubstitutionNode node, Void expected) {
            node.getSubstitutions().forEach(s -> {
                Z3Type cfr_ignored_0 = (Z3Type)this.visitSubstitutionNode((SubstitutionNode)s, null);
            });
            return null;
        }

        @Override
        public Z3Type visitBecomesElementOfSubstitutionNode(BecomesElementOfSubstitutionNode node, Void expected) {
            Z3SetType setType = (Z3SetType)this.visitExprNode(node.getExpression(), expected);
            Z3Type type = setType.getSubtype();
            if (node.getIdentifiers().size() == 1) {
                Z3TypeInference.this.updateDeclarationType(node.getIdentifiers().get(0).getDeclarationNode(), type);
            } else {
                ArrayList<Z3Type> typesList = new ArrayList<Z3Type>();
                Z3CoupleType couple = (Z3CoupleType)type;
                while (node.getIdentifiers().size() - 1 > typesList.size()) {
                    typesList.add(0, couple.getRightType());
                    couple = (Z3CoupleType)couple.getLeftType();
                }
                typesList.add(0, couple);
                for (int i = 0; i < node.getIdentifiers().size(); ++i) {
                    Z3TypeInference.this.updateDeclarationType(node.getIdentifiers().get(i).getDeclarationNode(), (Z3Type)typesList.get(i));
                }
            }
            return null;
        }

        @Override
        public Z3Type visitBecomesSuchThatSubstitutionNode(BecomesSuchThatSubstitutionNode node, Void expected) {
            AbstractVisitor.super.visitPredicateNode(node.getPredicate(), expected);
            return null;
        }

        @Override
        public Z3Type visitEnumerationSetNode(EnumerationSetNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitDeferredSetNode(DeferredSetNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitEnumeratedSetElementNode(EnumeratedSetElementNode node, Void expected) {
            return Z3TypeInference.this.setZ3Type(node, Z3TypeInference.this.convertBTypeToZ3Type(node.getType()));
        }

        @Override
        public Z3Type visitLTLPrefixOperatorNode(LTLPrefixOperatorNode node, Void expected) {
            throw new AssertionError();
        }

        @Override
        public Z3Type visitLTLKeywordNode(LTLKeywordNode node, Void expected) {
            throw new AssertionError();
        }

        @Override
        public Z3Type visitLTLInfixOperatorNode(LTLInfixOperatorNode node, Void expected) {
            throw new AssertionError();
        }

        @Override
        public Z3Type visitLTLBPredicateNode(LTLBPredicateNode node, Void expected) {
            throw new AssertionError();
        }
    }

    class Z3CoupleType
    implements Z3Type {
        Z3Type left;
        Z3Type right;

        Z3CoupleType(Z3Type left, Z3Type right) {
            this.left = left;
            this.right = right;
        }

        public Z3Type getLeftType() {
            return this.left;
        }

        public Z3Type getRightType() {
            return this.right;
        }
    }

    class Z3EnumeratedSetType
    implements Z3Type {
        String name;
        List<String> elements;

        Z3EnumeratedSetType(String name, List<String> elements) {
            this.name = name;
            this.elements = elements;
        }

        public String getSetName() {
            return this.name;
        }

        public List<String> getElements() {
            return this.elements;
        }
    }

    class Z3DeferredType
    implements Z3Type {
        String name;

        Z3DeferredType(String name) {
            this.name = name;
        }

        public String getSetName() {
            return this.name;
        }
    }

    class Z3SetType
    implements Z3Type {
        Z3Type subtype;

        Z3SetType(Z3Type type) {
            this.subtype = type;
        }

        public Z3Type getSubtype() {
            return this.subtype;
        }
    }

    class Z3SequenceType
    implements Z3Type {
        Z3Type subtype;

        Z3SequenceType(Z3Type type) {
            this.subtype = type;
        }

        public Z3Type getSubtype() {
            return this.subtype;
        }
    }

    class Z3BasicType
    implements Z3Type {
        Basic kind;

        public Z3BasicType(Basic kind) {
            this.kind = kind;
        }
    }

    static enum Basic {
        INTEGER,
        BOOL;

    }

    static interface Z3Type {
    }
}

