/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import de.bmoth.backend.Abortable;
import java.util.HashSet;
import java.util.Set;

public class SolutionFinder
implements Abortable {
    private final Solver solver;
    private final Context z3Context;
    private boolean isAborted;

    public SolutionFinder(Solver solver, Context z3Context) {
        this.solver = solver;
        this.z3Context = z3Context;
    }

    private BoolExpr findSolution(Model model) {
        FuncDecl[] constants = model.getConstDecls();
        BoolExpr result = null;
        for (FuncDecl var : constants) {
            if (var.getName().toString().contains("!")) continue;
            Expr value = model.eval(var.apply(new Expr[0]), true);
            result = result == null ? this.z3Context.mkEq(var.apply(new Expr[0]), value) : this.z3Context.mkAnd(new BoolExpr[]{result, this.z3Context.mkEq(var.apply(new Expr[0]), value)});
        }
        return result;
    }

    public Set<Model> findSolutions(BoolExpr constraint, int maxIterations) {
        Model currentModel;
        BoolExpr solution;
        this.isAborted = false;
        HashSet<Model> result = new HashSet<Model>();
        this.solver.push();
        this.solver.add(new BoolExpr[]{constraint});
        for (int i = 0; !this.isAborted && this.solver.check() == Status.SATISFIABLE && i < maxIterations && (solution = this.findSolution(currentModel = this.solver.getModel())) != null; ++i) {
            this.solver.add(new BoolExpr[]{this.z3Context.mkNot(solution)});
            result.add(currentModel);
        }
        this.solver.pop();
        return result;
    }

    @Override
    public void abort() {
        this.isAborted = true;
    }
}

