/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3;

import com.microsoft.z3.ArithExpr;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeExpr;
import com.microsoft.z3.EnumSort;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntSort;
import com.microsoft.z3.Pattern;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.Sort;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import com.microsoft.z3.TupleSort;
import de.bmoth.backend.TranslationOptions;
import de.bmoth.backend.z3.Z3TypeInference;
import de.bmoth.parser.Parser;
import de.bmoth.parser.ParserException;
import de.bmoth.parser.ast.nodes.CastPredicateExpressionNode;
import de.bmoth.parser.ast.nodes.DeclarationNode;
import de.bmoth.parser.ast.nodes.DeferredSetNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetElementNode;
import de.bmoth.parser.ast.nodes.EnumerationSetNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IdentifierPredicateNode;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.OperatorNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.nodes.QuantifiedExpressionNode;
import de.bmoth.parser.ast.nodes.QuantifiedPredicateNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import de.bmoth.parser.ast.nodes.TypedNode;
import de.bmoth.parser.ast.visitors.FormulaVisitor;
import de.bmoth.preferences.BMothPreferences;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class FormulaToZ3Translator {
    private Context z3Context;
    private final LinkedList<BoolExpr> constraintList = new LinkedList();
    private List<DeclarationNode> implicitDeclarations;
    private FormulaNode formulaNode;
    private final Z3TypeInference z3TypeInference;
    private FuncDecl pow = null;
    private ArrayExpr setNatural = null;
    private ArrayExpr setNatural1 = null;
    private ArrayExpr setInt = null;
    private ArrayExpr setNat = null;
    private ArrayExpr setNat1 = null;
    private static int tempVariablesCounter = 0;

    public List<DeclarationNode> getImplicitDeclarations() {
        return this.implicitDeclarations;
    }

    public List<Expr> getImplicitVariablesAsZ3Expression() {
        ArrayList<Expr> list = new ArrayList<Expr>();
        for (DeclarationNode decl : this.implicitDeclarations) {
            Expr mkConst = this.z3Context.mkConst(decl.getName(), this.z3TypeInference.getZ3Sort(decl, this.z3Context));
            list.add(mkConst);
        }
        return list;
    }

    private static String createFreshTemporaryVariable() {
        return "$t_" + ++tempVariablesCounter;
    }

    private FormulaToZ3Translator(Context z3Context, String formula) throws ParserException {
        this.z3Context = z3Context;
        this.formulaNode = Parser.getFormulaAsSemanticAst(formula);
        this.implicitDeclarations = this.formulaNode.getImplicitDeclarations();
        this.z3TypeInference = new Z3TypeInference();
        this.z3TypeInference.visitPredicateNode((PredicateNode)this.formulaNode.getFormula());
    }

    private FormulaToZ3Translator(Context z3Context, Z3TypeInference z3TypeInference) {
        this.z3Context = z3Context;
        this.z3TypeInference = z3TypeInference;
    }

    static BoolExpr translateVariableEqualToExpr(String name, ExprNode exprNode, Context z3Context, Z3TypeInference z3TypeInference) {
        return FormulaToZ3Translator.translateVariableEqualToExpr(name, exprNode, z3Context, TranslationOptions.UNPRIMED, z3TypeInference);
    }

    private static BoolExpr translateVariableEqualToExpr(String name, ExprNode value, Context z3Context, TranslationOptions opt, Z3TypeInference z3TypeInference) {
        FormulaToZ3Translator formulaToZ3Translator = new FormulaToZ3Translator(z3Context, z3TypeInference);
        FormulaToZ3TranslatorVisitor visitor = formulaToZ3Translator.new FormulaToZ3TranslatorVisitor();
        Expr z3Value = (Expr)visitor.visitExprNode(value, opt);
        Expr variable = z3Context.mkConst(name, z3Value.getSort());
        BoolExpr mkEq = z3Context.mkEq(variable, z3Value);
        BoolExpr accumulated = formulaToZ3Translator.getAccumulatedConstraints(z3Context);
        if (accumulated != null) {
            return z3Context.mkAnd(new BoolExpr[]{mkEq, accumulated});
        }
        return mkEq;
    }

    static BoolExpr translateVariableElementOfSetExpr(String name, DeclarationNode variable, ExprNode setValue, Context z3Context, TranslationOptions opt, Z3TypeInference z3TypeInference) {
        FormulaToZ3Translator formulaToZ3Translator = new FormulaToZ3Translator(z3Context, z3TypeInference);
        FormulaToZ3TranslatorVisitor visitor = formulaToZ3Translator.new FormulaToZ3TranslatorVisitor();
        ArrayExpr z3Value = (ArrayExpr)visitor.visitExprNode(setValue, opt);
        Expr variableExpr = z3Context.mkConst(name, formulaToZ3Translator.z3TypeInference.getZ3Sort(variable, z3Context));
        BoolExpr mkEq = z3Context.mkSetMembership(variableExpr, z3Value);
        BoolExpr accumulated = formulaToZ3Translator.getAccumulatedConstraints(z3Context);
        if (accumulated != null) {
            return z3Context.mkAnd(new BoolExpr[]{mkEq, accumulated});
        }
        return mkEq;
    }

    private BoolExpr getAccumulatedConstraints(Context z3Context) {
        switch (this.constraintList.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.constraintList.get(0);
            }
        }
        return z3Context.mkAnd(this.constraintList.toArray(new BoolExpr[0]));
    }

    public static BoolExpr translatePredicate(String formula, Context z3Context) throws ParserException {
        FormulaToZ3Translator formulaToZ3Translator = new FormulaToZ3Translator(z3Context, formula);
        if (formulaToZ3Translator.formulaNode.getFormulaType() != FormulaNode.FormulaType.PREDICATE_FORMULA) {
            throw new IllegalArgumentException("Expected predicate.");
        }
        FormulaToZ3TranslatorVisitor visitor = formulaToZ3Translator.new FormulaToZ3TranslatorVisitor();
        Expr constraint = (Expr)visitor.visitPredicateNode((PredicateNode)formulaToZ3Translator.formulaNode.getFormula(), TranslationOptions.UNPRIMED);
        if (!(constraint instanceof BoolExpr)) {
            throw new IllegalStateException("Invalid translation. Expected BoolExpr but found " + constraint.getClass());
        }
        BoolExpr accumulated = formulaToZ3Translator.getAccumulatedConstraints(z3Context);
        if (accumulated != null) {
            return z3Context.mkAnd(new BoolExpr[]{(BoolExpr)constraint, accumulated});
        }
        return (BoolExpr)constraint;
    }

    public static BoolExpr translatePredicate(PredicateNode predNode, Context z3Context, Z3TypeInference z3TypeInference) {
        return FormulaToZ3Translator.translatePredicate(predNode, z3Context, TranslationOptions.UNPRIMED, z3TypeInference);
    }

    public static BoolExpr translatePredicate(PredicateNode predNode, Context z3Context, TranslationOptions opt, Z3TypeInference z3TypeInference) {
        FormulaToZ3Translator formulaToZ3Translator = new FormulaToZ3Translator(z3Context, z3TypeInference);
        FormulaToZ3TranslatorVisitor formulaToZ3TranslatorVisitor = formulaToZ3Translator.new FormulaToZ3TranslatorVisitor();
        BoolExpr boolExpr = (BoolExpr)formulaToZ3TranslatorVisitor.visitPredicateNode(predNode, opt);
        BoolExpr accumulated = formulaToZ3Translator.getAccumulatedConstraints(z3Context);
        if (accumulated != null) {
            return z3Context.mkAnd(new BoolExpr[]{boolExpr, accumulated});
        }
        return boolExpr;
    }

    class FormulaToZ3TranslatorVisitor
    implements FormulaVisitor<Expr, TranslationOptions> {
        FormulaToZ3TranslatorVisitor() {
        }

        private Sort getZ3Sort(TypedNode node) {
            return FormulaToZ3Translator.this.z3TypeInference.getZ3Sort(node, FormulaToZ3Translator.this.z3Context);
        }

        private Z3TypeInference.Z3Type getZ3Type(TypedNode node) {
            return FormulaToZ3Translator.this.z3TypeInference.getZ3TypeOfNode(node);
        }

        private Sort getZ3Sort(Z3TypeInference.Z3Type z3Type) {
            return FormulaToZ3Translator.this.z3TypeInference.getZ3Sort(z3Type, FormulaToZ3Translator.this.z3Context);
        }

        @Override
        public Expr visitIdentifierExprNode(IdentifierExprNode node, TranslationOptions ops) {
            return FormulaToZ3Translator.this.z3Context.mkConst(node.getName(), this.getZ3Sort(node.getDeclarationNode()));
        }

        @Override
        public Expr visitCastPredicateExpressionNode(CastPredicateExpressionNode node, TranslationOptions expected) {
            return (Expr)this.visitPredicateNode(node.getPredicate(), expected);
        }

        @Override
        public Expr visitIdentifierPredicateNode(IdentifierPredicateNode node, TranslationOptions ops) {
            return FormulaToZ3Translator.this.z3Context.mkBoolConst(node.getName());
        }

        @Override
        public Expr visitPredicateOperatorWithExprArgs(PredicateOperatorWithExprArgsNode node, TranslationOptions ops) {
            List arguments = node.getExpressionNodes().stream().map(it -> (Expr)this.visitExprNode((ExprNode)it, ops)).collect(Collectors.toList());
            switch (node.getOperator()) {
                case EQUAL: {
                    return FormulaToZ3Translator.this.z3Context.mkEq((Expr)arguments.get(0), (Expr)arguments.get(1));
                }
                case NOT_EQUAL: {
                    return FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkEq((Expr)arguments.get(0), (Expr)arguments.get(1)));
                }
                case ELEMENT_OF: {
                    return FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)arguments.get(0), (ArrayExpr)arguments.get(1));
                }
                case LESS_EQUAL: {
                    return FormulaToZ3Translator.this.z3Context.mkLe((ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1));
                }
                case LESS: {
                    return FormulaToZ3Translator.this.z3Context.mkLt((ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1));
                }
                case GREATER_EQUAL: {
                    return FormulaToZ3Translator.this.z3Context.mkGe((ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1));
                }
                case GREATER: {
                    return FormulaToZ3Translator.this.z3Context.mkGt((ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1));
                }
                case NOT_BELONGING: {
                    return FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)arguments.get(0), (ArrayExpr)arguments.get(1)));
                }
                case INCLUSION: {
                    return FormulaToZ3Translator.this.z3Context.mkSetSubset((ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1));
                }
                case STRICT_INCLUSION: {
                    return FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkEq((Expr)arguments.get(0), (Expr)arguments.get(1))), FormulaToZ3Translator.this.z3Context.mkSetSubset((ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1))});
                }
                case NON_INCLUSION: {
                    return FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkSetSubset((ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1)));
                }
                case STRICT_NON_INCLUSION: {
                    return FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkEq((Expr)arguments.get(0), (Expr)arguments.get(1))), FormulaToZ3Translator.this.z3Context.mkSetSubset((ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1))}));
                }
            }
            throw new OperatorNotImplementedError(node);
        }

        @Override
        public Expr visitExprOperatorNode(ExpressionOperatorNode node, TranslationOptions ops) {
            List<Expr> arguments = node.getExpressionNodes().stream().map(it -> (Expr)this.visitExprNode((ExprNode)it, ops)).collect(Collectors.toList());
            switch (node.getOperator()) {
                case PLUS: {
                    return FormulaToZ3Translator.this.z3Context.mkAdd(new ArithExpr[]{(ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1)});
                }
                case UNARY_MINUS: {
                    return FormulaToZ3Translator.this.z3Context.mkUnaryMinus((ArithExpr)arguments.get(0));
                }
                case MINUS: {
                    return FormulaToZ3Translator.this.z3Context.mkSub(new ArithExpr[]{(ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1)});
                }
                case MOD: {
                    return FormulaToZ3Translator.this.z3Context.mkMod((IntExpr)arguments.get(0), (IntExpr)arguments.get(1));
                }
                case MULT: {
                    return FormulaToZ3Translator.this.z3Context.mkMul(new ArithExpr[]{(ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1)});
                }
                case DIVIDE: {
                    FormulaToZ3Translator.this.constraintList.add(FormulaToZ3Translator.this.z3Context.mkNot(FormulaToZ3Translator.this.z3Context.mkEq(arguments.get(1), (Expr)FormulaToZ3Translator.this.z3Context.mkInt(0))));
                    return FormulaToZ3Translator.this.z3Context.mkDiv((ArithExpr)arguments.get(0), (ArithExpr)arguments.get(1));
                }
                case POWER_OF: {
                    if (FormulaToZ3Translator.this.pow == null) {
                        FormulaToZ3Translator.this.pow = this.initPowerOf();
                    }
                    return FormulaToZ3Translator.this.pow.apply(new Expr[]{arguments.get(0), arguments.get(1)});
                }
                case INTERVAL: {
                    ArrayExpr interval = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(node));
                    FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(interval, (IntExpr)arguments.get(0), (IntExpr)arguments.get(1)));
                    return interval;
                }
                case INTEGER: {
                    return FormulaToZ3Translator.this.z3Context.mkFullSet((Sort)FormulaToZ3Translator.this.z3Context.mkIntSort());
                }
                case NATURAL1: {
                    if (FormulaToZ3Translator.this.setNatural1 == null) {
                        FormulaToZ3Translator.this.setNatural1 = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst("NATURAL1", this.getZ3Sort(node));
                        FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(FormulaToZ3Translator.this.setNatural1, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(1), null));
                    }
                    return FormulaToZ3Translator.this.setNatural1;
                }
                case NATURAL: {
                    if (FormulaToZ3Translator.this.setNatural == null) {
                        FormulaToZ3Translator.this.setNatural = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst("NATURAL", this.getZ3Sort(node));
                        FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(FormulaToZ3Translator.this.setNatural, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(0), null));
                    }
                    return FormulaToZ3Translator.this.setNatural;
                }
                case INT: {
                    if (FormulaToZ3Translator.this.setInt == null) {
                        int maxInt = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT);
                        int minInt = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MIN_INT);
                        FormulaToZ3Translator.this.setInt = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst(ExpressionOperatorNode.ExpressionOperator.INT.toString(), this.getZ3Sort(node));
                        FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(FormulaToZ3Translator.this.setInt, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(minInt), (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(maxInt)));
                    }
                    return FormulaToZ3Translator.this.setInt;
                }
                case NAT: {
                    if (FormulaToZ3Translator.this.setNat == null) {
                        int maxInt = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT);
                        FormulaToZ3Translator.this.setNat = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst(ExpressionOperatorNode.ExpressionOperator.NAT.toString(), this.getZ3Sort(node));
                        FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(FormulaToZ3Translator.this.setNat, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(0), (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(maxInt)));
                    }
                    return FormulaToZ3Translator.this.setNat;
                }
                case NAT1: {
                    if (FormulaToZ3Translator.this.setNat1 == null) {
                        int maxInt = BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT);
                        FormulaToZ3Translator.this.setNat1 = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst(ExpressionOperatorNode.ExpressionOperator.NAT1.toString(), this.getZ3Sort(node));
                        FormulaToZ3Translator.this.constraintList.add(this.prepareSetQuantifier(FormulaToZ3Translator.this.setNat1, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(1), (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(maxInt)));
                    }
                    return FormulaToZ3Translator.this.setNat1;
                }
                case FALSE: {
                    return FormulaToZ3Translator.this.z3Context.mkFalse();
                }
                case TRUE: {
                    return FormulaToZ3Translator.this.z3Context.mkTrue();
                }
                case BOOL: {
                    return FormulaToZ3Translator.this.z3Context.mkFullSet((Sort)FormulaToZ3Translator.this.z3Context.mkBoolSort());
                }
                case UNION: {
                    return FormulaToZ3Translator.this.z3Context.mkSetUnion((ArrayExpr[])arguments.stream().map(it -> (ArrayExpr)it).toArray(ArrayExpr[]::new));
                }
                case COUPLE: {
                    TupleSort bTypeToZ3Sort = (TupleSort)this.getZ3Sort(node);
                    return bTypeToZ3Sort.mkDecl().apply(new Expr[]{arguments.get(0), arguments.get(1)});
                }
                case INTERSECTION: {
                    return FormulaToZ3Translator.this.z3Context.mkSetIntersection(new ArrayExpr[]{(ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1)});
                }
                case DOMAIN: {
                    ArrayExpr argument = (ArrayExpr)this.visitExprNode(node.getExpressionNodes().get(0), ops);
                    Z3TypeInference.Z3SetType setOfTuples = (Z3TypeInference.Z3SetType)this.getZ3Type(node.getExpressionNodes().get(0));
                    Z3TypeInference.Z3CoupleType coupleType = (Z3TypeInference.Z3CoupleType)setOfTuples.getSubtype();
                    TupleSort tupleSort = (TupleSort)this.getZ3Sort(coupleType);
                    Context context = FormulaToZ3Translator.this.z3Context;
                    String string = FormulaToZ3Translator.createFreshTemporaryVariable();
                    Z3TypeInference z3TypeInference = FormulaToZ3Translator.this.z3TypeInference;
                    Z3TypeInference z3TypeInference2 = FormulaToZ3Translator.this.z3TypeInference;
                    z3TypeInference2.getClass();
                    Expr dom = context.mkConst(string, z3TypeInference.getZ3Sort(new Z3TypeInference.Z3SetType(z3TypeInference2, coupleType.getRightType()), FormulaToZ3Translator.this.z3Context));
                    Expr domMember = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getRightType()));
                    Expr ranMember = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getLeftType()));
                    BoolExpr domMemberInDom = FormulaToZ3Translator.this.z3Context.mkSetMembership(domMember, (ArrayExpr)dom);
                    BoolExpr ranAndDomInArgument = FormulaToZ3Translator.this.z3Context.mkSetMembership(tupleSort.mkDecl().apply(new Expr[]{ranMember, domMember}), argument);
                    Quantifier existsRan = FormulaToZ3Translator.this.z3Context.mkExists(new Expr[]{ranMember}, (Expr)ranAndDomInArgument, 1, null, null, null, null);
                    Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(new Expr[]{domMember}, (Expr)FormulaToZ3Translator.this.z3Context.mkEq((Expr)existsRan, (Expr)domMemberInDom), 1, null, null, null, null);
                    FormulaToZ3Translator.this.constraintList.add(q);
                    return dom;
                }
                case RANGE: {
                    ArrayExpr argument = (ArrayExpr)this.visitExprNode(node.getExpressionNodes().get(0), ops);
                    Z3TypeInference.Z3SetType setOfTuples = (Z3TypeInference.Z3SetType)this.getZ3Type(node.getExpressionNodes().get(0));
                    Z3TypeInference.Z3CoupleType coupleType = (Z3TypeInference.Z3CoupleType)setOfTuples.getSubtype();
                    TupleSort tupleSort = (TupleSort)this.getZ3Sort(coupleType);
                    Context context = FormulaToZ3Translator.this.z3Context;
                    String string = FormulaToZ3Translator.createFreshTemporaryVariable();
                    Z3TypeInference z3TypeInference = FormulaToZ3Translator.this.z3TypeInference;
                    z3TypeInference.getClass();
                    Expr ran = context.mkConst(string, this.getZ3Sort(new Z3TypeInference.Z3SetType(z3TypeInference, coupleType.getLeftType())));
                    Expr domMember = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getRightType()));
                    Expr ranMember = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getLeftType()));
                    BoolExpr ranMemberInRan = FormulaToZ3Translator.this.z3Context.mkSetMembership(ranMember, (ArrayExpr)ran);
                    BoolExpr ranAndDomInArgument = FormulaToZ3Translator.this.z3Context.mkSetMembership(tupleSort.mkDecl().apply(new Expr[]{ranMember, domMember}), argument);
                    Quantifier existsDom = FormulaToZ3Translator.this.z3Context.mkExists(new Expr[]{domMember}, (Expr)ranAndDomInArgument, 1, null, null, null, null);
                    Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(new Expr[]{ranMember}, (Expr)FormulaToZ3Translator.this.z3Context.mkEq((Expr)existsDom, (Expr)ranMemberInRan), 1, null, null, null, null);
                    FormulaToZ3Translator.this.constraintList.add(q);
                    return ran;
                }
                case LAST: {
                    DatatypeExpr d = (DatatypeExpr)arguments.get(0);
                    Expr[] args = d.getArgs();
                    ArrayExpr array = (ArrayExpr)args[0];
                    ArithExpr size = (ArithExpr)args[1];
                    FormulaToZ3Translator.this.constraintList.add(FormulaToZ3Translator.this.z3Context.mkLe((ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(1), size));
                    return FormulaToZ3Translator.this.z3Context.mkSelect(array, (Expr)size);
                }
                case FRONT: {
                    DatatypeExpr d = (DatatypeExpr)arguments.get(0);
                    Expr[] args = d.getArgs();
                    ArrayExpr array = (ArrayExpr)args[0];
                    ArithExpr size = (ArithExpr)args[1];
                    FormulaToZ3Translator.this.constraintList.add(FormulaToZ3Translator.this.z3Context.mkLe((ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(1), size));
                    TupleSort mkTupleSort = (TupleSort)this.getZ3Sort(node);
                    return mkTupleSort.mkDecl().apply(new Expr[]{array, FormulaToZ3Translator.this.z3Context.mkSub(new ArithExpr[]{size, FormulaToZ3Translator.this.z3Context.mkInt(1)})});
                }
                case TAIL: {
                    break;
                }
                case CONC: {
                    break;
                }
                case EMPTY_SET: 
                case SET_ENUMERATION: {
                    Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
                    Z3TypeInference.Z3Type subType = setType.getSubtype();
                    ArrayExpr z3Set = FormulaToZ3Translator.this.z3Context.mkEmptySet(this.getZ3Sort(subType));
                    for (Expr expr : arguments) {
                        z3Set = FormulaToZ3Translator.this.z3Context.mkSetAdd(z3Set, expr);
                    }
                    return z3Set;
                }
                case SET_SUBTRACTION: {
                    return FormulaToZ3Translator.this.z3Context.mkSetDifference((ArrayExpr)arguments.get(0), (ArrayExpr)arguments.get(1));
                }
                case CONCAT: 
                case DIRECT_PRODUCT: 
                case DOMAIN_RESTRICTION: 
                case DOMAIN_SUBTRACTION: 
                case GENERALIZED_INTER: {
                    break;
                }
                case GENERALIZED_UNION: {
                    return this.translateGeneralizedUnion(node, arguments);
                }
                case EMPTY_SEQUENCE: 
                case SEQ_ENUMERATION: {
                    return this.translateSeqEnumeration(node, arguments);
                }
                case FIRST: {
                    DatatypeExpr d = (DatatypeExpr)arguments.get(0);
                    Expr[] args = d.getArgs();
                    ArrayExpr array = (ArrayExpr)args[0];
                    ArithExpr size = (ArithExpr)args[1];
                    FormulaToZ3Translator.this.constraintList.add(FormulaToZ3Translator.this.z3Context.mkLe((ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(1), size));
                    return FormulaToZ3Translator.this.z3Context.mkSelect(array, (Expr)FormulaToZ3Translator.this.z3Context.mkInt(1));
                }
                case FUNCTION_CALL: {
                    DatatypeExpr d = (DatatypeExpr)arguments.get(0);
                    Expr[] args = d.getArgs();
                    ArrayExpr array = (ArrayExpr)args[0];
                    ArithExpr size = (ArithExpr)args[1];
                    ArithExpr index = (ArithExpr)arguments.get(1);
                    FormulaToZ3Translator.this.constraintList.add(FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{FormulaToZ3Translator.this.z3Context.mkGe(index, (ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(1)), FormulaToZ3Translator.this.z3Context.mkLe(index, size)}));
                    return FormulaToZ3Translator.this.z3Context.mkSelect(array, (Expr)index);
                }
                case CARD: {
                    break;
                }
                case INSERT_FRONT: 
                case INSERT_TAIL: 
                case OVERWRITE_RELATION: {
                    break;
                }
                case INVERSE_RELATION: {
                    Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
                    Z3TypeInference.Z3CoupleType couple = (Z3TypeInference.Z3CoupleType)setType.getSubtype();
                    Z3TypeInference z3TypeInference = FormulaToZ3Translator.this.z3TypeInference;
                    z3TypeInference.getClass();
                    Z3TypeInference.Z3CoupleType revCouple = new Z3TypeInference.Z3CoupleType(z3TypeInference, couple.getRightType(), couple.getLeftType());
                    TupleSort subSort = (TupleSort)this.getZ3Sort(couple);
                    TupleSort revSort = (TupleSort)this.getZ3Sort(revCouple);
                    Expr tempLeft = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(couple.getLeftType()));
                    Expr tempRight = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(couple.getRightType()));
                    Context context = FormulaToZ3Translator.this.z3Context;
                    String string = FormulaToZ3Translator.createFreshTemporaryVariable();
                    Z3TypeInference z3TypeInference3 = FormulaToZ3Translator.this.z3TypeInference;
                    z3TypeInference3.getClass();
                    ArrayExpr tempConstant = (ArrayExpr)context.mkConst(string, this.getZ3Sort(new Z3TypeInference.Z3SetType(z3TypeInference3, revCouple)));
                    BoolExpr lrInExpr = FormulaToZ3Translator.this.z3Context.mkSetMembership(subSort.mkDecl().apply(new Expr[]{tempLeft, tempRight}), (ArrayExpr)arguments.get(0));
                    BoolExpr rlInTempExpr = FormulaToZ3Translator.this.z3Context.mkSetMembership(revSort.mkDecl().apply(new Expr[]{tempRight, tempLeft}), tempConstant);
                    BoolExpr equality = FormulaToZ3Translator.this.z3Context.mkEq((Expr)lrInExpr, (Expr)rlInTempExpr);
                    Expr[] bound = new Expr[]{tempLeft, tempRight};
                    Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(bound, (Expr)equality, 2, null, null, null, null);
                    FormulaToZ3Translator.this.constraintList.add(q);
                    return tempConstant;
                }
                case RANGE_RESTRICTION: 
                case RANGE_SUBTRATION: 
                case RESTRICT_FRONT: 
                case RESTRICT_TAIL: {
                    break;
                }
                case SEQ: {
                    break;
                }
                case SEQ1: {
                    break;
                }
                case ISEQ: {
                    break;
                }
                case ISEQ1: {
                    break;
                }
                case CARTESIAN_PRODUCT: {
                    Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
                    Z3TypeInference.Z3CoupleType coupleType = (Z3TypeInference.Z3CoupleType)setType.getSubtype();
                    TupleSort bTypeToZ3Sort = (TupleSort)this.getZ3Sort(coupleType);
                    ArithExpr leftExpr = (ArithExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getLeftType()));
                    ArithExpr rightExpr = (ArithExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(coupleType.getRightType()));
                    ArrayExpr tempConstant = (ArrayExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(node));
                    Expr couple = bTypeToZ3Sort.mkDecl().apply(new Expr[]{leftExpr, rightExpr});
                    BoolExpr xInLeft = FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)leftExpr, (ArrayExpr)arguments.get(0));
                    BoolExpr yInRight = FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)rightExpr, (ArrayExpr)arguments.get(1));
                    BoolExpr coupleInCartesian = FormulaToZ3Translator.this.z3Context.mkSetMembership(couple, tempConstant);
                    BoolExpr cartesian = FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{xInLeft, yInRight});
                    BoolExpr equality = FormulaToZ3Translator.this.z3Context.mkEq((Expr)cartesian, (Expr)coupleInCartesian);
                    Expr[] bound = new Expr[]{leftExpr, rightExpr};
                    Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(bound, (Expr)equality, 2, null, null, null, null);
                    FormulaToZ3Translator.this.constraintList.add(q);
                    return tempConstant;
                }
                case MAXINT: {
                    return FormulaToZ3Translator.this.z3Context.mkInt(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT));
                }
                case MININT: {
                    return FormulaToZ3Translator.this.z3Context.mkInt(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MIN_INT));
                }
                case MIN: {
                    return this.translateMinAndMax(ExpressionOperatorNode.ExpressionOperator.MIN, node, arguments);
                }
                case MAX: {
                    return this.translateMinAndMax(ExpressionOperatorNode.ExpressionOperator.MAX, node, arguments);
                }
            }
            throw new OperatorNotImplementedError(node);
        }

        private Expr translateMinAndMax(ExpressionOperatorNode.ExpressionOperator minOrMax, ExpressionOperatorNode node, List<Expr> arguments) {
            ArithExpr replacingConstant = (ArithExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(node));
            ArithExpr member = (ArithExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(node));
            BoolExpr memberInSet = FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)member, (ArrayExpr)arguments.get(0));
            BoolExpr sort = minOrMax == ExpressionOperatorNode.ExpressionOperator.MAX ? FormulaToZ3Translator.this.z3Context.mkLe(member, replacingConstant) : FormulaToZ3Translator.this.z3Context.mkGe(member, replacingConstant);
            BoolExpr implication = FormulaToZ3Translator.this.z3Context.mkImplies(memberInSet, sort);
            Quantifier allSorted = FormulaToZ3Translator.this.z3Context.mkForall(new Expr[]{member}, (Expr)implication, 1, null, null, null, null);
            Quantifier equalToOne = FormulaToZ3Translator.this.z3Context.mkExists(new Expr[]{member}, (Expr)FormulaToZ3Translator.this.z3Context.mkEq((Expr)member, (Expr)replacingConstant), 1, null, null, null, null);
            FormulaToZ3Translator.this.constraintList.add(allSorted);
            FormulaToZ3Translator.this.constraintList.add(equalToOne);
            return replacingConstant;
        }

        private Expr translateGeneralizedUnion(ExpressionOperatorNode node, List<Expr> arguments) {
            Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
            Expr setOfSets = arguments.get(0);
            Expr res = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), FormulaToZ3Translator.this.z3TypeInference.getZ3Sort(setType, FormulaToZ3Translator.this.z3Context));
            Expr setVar = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(setType));
            Expr elementVar = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(setType.getSubtype()));
            BoolExpr eIsInRes = FormulaToZ3Translator.this.z3Context.mkSetMembership(elementVar, (ArrayExpr)res);
            BoolExpr sIsInS = FormulaToZ3Translator.this.z3Context.mkSetMembership(setVar, (ArrayExpr)setOfSets);
            BoolExpr eIsIns = FormulaToZ3Translator.this.z3Context.mkSetMembership(elementVar, (ArrayExpr)setVar);
            Quantifier exists = FormulaToZ3Translator.this.z3Context.mkExists(new Expr[]{setVar}, (Expr)FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{sIsInS, eIsIns}), 1, null, null, null, null);
            Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(new Expr[]{elementVar}, (Expr)FormulaToZ3Translator.this.z3Context.mkEq((Expr)eIsInRes, (Expr)exists), 1, null, null, null, null);
            FormulaToZ3Translator.this.constraintList.add(q);
            return res;
        }

        private Expr translateSeqEnumeration(ExpressionOperatorNode node, List<Expr> arguments) {
            IntSort intType = FormulaToZ3Translator.this.z3Context.getIntSort();
            Z3TypeInference.Z3SequenceType setType = (Z3TypeInference.Z3SequenceType)this.getZ3Type(node);
            Sort rangeType = this.getZ3Sort(setType.getSubtype());
            ArrayExpr a = FormulaToZ3Translator.this.z3Context.mkArrayConst(FormulaToZ3Translator.createFreshTemporaryVariable(), (Sort)intType, rangeType);
            int index = 1;
            for (Expr value : arguments) {
                a = FormulaToZ3Translator.this.z3Context.mkStore(a, (Expr)FormulaToZ3Translator.this.z3Context.mkInt(index++), value);
            }
            TupleSort mkTupleSort = (TupleSort)this.getZ3Sort(node);
            return mkTupleSort.mkDecl().apply(new Expr[]{a, FormulaToZ3Translator.this.z3Context.mkInt(arguments.size())});
        }

        private Quantifier prepareSetQuantifier(ArrayExpr set, IntExpr min, IntExpr max) {
            ArithExpr x = (ArithExpr)FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), (Sort)FormulaToZ3Translator.this.z3Context.getIntSort());
            ArithExpr[] bound = new ArithExpr[]{x};
            BoolExpr membership = FormulaToZ3Translator.this.z3Context.mkSetMembership((Expr)x, set);
            BoolExpr body = min != null && max != null ? FormulaToZ3Translator.this.z3Context.mkEq((Expr)FormulaToZ3Translator.this.z3Context.mkAnd(new BoolExpr[]{FormulaToZ3Translator.this.z3Context.mkGe(x, (ArithExpr)min), FormulaToZ3Translator.this.z3Context.mkLe(x, (ArithExpr)max)}), (Expr)membership) : (min != null ? FormulaToZ3Translator.this.z3Context.mkEq((Expr)FormulaToZ3Translator.this.z3Context.mkGe(x, (ArithExpr)min), (Expr)membership) : (max != null ? FormulaToZ3Translator.this.z3Context.mkEq((Expr)FormulaToZ3Translator.this.z3Context.mkLe(x, (ArithExpr)max), (Expr)membership) : membership));
            return FormulaToZ3Translator.this.z3Context.mkForall((Expr[])bound, (Expr)body, bound.length, null, null, null, null);
        }

        private FuncDecl initPowerOf() {
            FuncDecl powerOf = FormulaToZ3Translator.this.z3Context.mkFuncDecl(ExpressionOperatorNode.ExpressionOperator.POWER_OF.toString(), new Sort[]{FormulaToZ3Translator.this.z3Context.mkIntSort(), FormulaToZ3Translator.this.z3Context.mkIntSort()}, (Sort)FormulaToZ3Translator.this.z3Context.mkIntSort());
            Expr a = FormulaToZ3Translator.this.z3Context.mkConst("a", (Sort)FormulaToZ3Translator.this.z3Context.getIntSort());
            Expr b = FormulaToZ3Translator.this.z3Context.mkConst("b", (Sort)FormulaToZ3Translator.this.z3Context.getIntSort());
            Expr[] bound = new Expr[]{a, b};
            ArithExpr expEven = FormulaToZ3Translator.this.z3Context.mkMul(new ArithExpr[]{(ArithExpr)powerOf.apply(new Expr[]{a, FormulaToZ3Translator.this.z3Context.mkDiv((ArithExpr)b, (ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(2))}), (ArithExpr)powerOf.apply(new Expr[]{a, FormulaToZ3Translator.this.z3Context.mkDiv((ArithExpr)b, (ArithExpr)FormulaToZ3Translator.this.z3Context.mkInt(2))})});
            ArithExpr expOdd = FormulaToZ3Translator.this.z3Context.mkMul(new ArithExpr[]{(ArithExpr)a, (ArithExpr)powerOf.apply(new Expr[]{a, FormulaToZ3Translator.this.z3Context.mkSub(new ArithExpr[]{(ArithExpr)b, FormulaToZ3Translator.this.z3Context.mkInt(1)})})});
            Expr expEvenOdd = FormulaToZ3Translator.this.z3Context.mkITE(FormulaToZ3Translator.this.z3Context.mkEq((Expr)FormulaToZ3Translator.this.z3Context.mkInt(0), (Expr)FormulaToZ3Translator.this.z3Context.mkMod((IntExpr)b, (IntExpr)FormulaToZ3Translator.this.z3Context.mkInt(2))), (Expr)expEven, (Expr)expOdd);
            Expr expZero = FormulaToZ3Translator.this.z3Context.mkITE(FormulaToZ3Translator.this.z3Context.mkEq((Expr)FormulaToZ3Translator.this.z3Context.mkInt(0), b), (Expr)FormulaToZ3Translator.this.z3Context.mkInt(1), expEvenOdd);
            BoolExpr body = FormulaToZ3Translator.this.z3Context.mkEq(powerOf.apply(new Expr[]{a, b}), expZero);
            Pattern[] patterns = new Pattern[]{FormulaToZ3Translator.this.z3Context.mkPattern(new Expr[]{powerOf.apply(new Expr[]{a, b})})};
            StringSymbol recFun = FormulaToZ3Translator.this.z3Context.mkSymbol(":rec-fun");
            Quantifier powConstraint = FormulaToZ3Translator.this.z3Context.mkForall(bound, (Expr)body, bound.length, patterns, null, (Symbol)recFun, null);
            FormulaToZ3Translator.this.constraintList.add(powConstraint);
            return powerOf;
        }

        @Override
        public Expr visitNumberNode(NumberNode node, TranslationOptions ops) {
            return FormulaToZ3Translator.this.z3Context.mkInt(node.getValue().longValueExact());
        }

        @Override
        public Expr visitPredicateOperatorNode(PredicateOperatorNode node, TranslationOptions ops) {
            List<BoolExpr> arguments = node.getPredicateArguments().stream().map(it -> (BoolExpr)this.visitPredicateNode((PredicateNode)it, ops)).collect(Collectors.toList());
            switch (node.getOperator()) {
                case AND: {
                    return FormulaToZ3Translator.this.z3Context.mkAnd(arguments.toArray(new BoolExpr[arguments.size()]));
                }
                case OR: {
                    return FormulaToZ3Translator.this.z3Context.mkOr(arguments.toArray(new BoolExpr[arguments.size()]));
                }
                case IMPLIES: {
                    return FormulaToZ3Translator.this.z3Context.mkImplies((BoolExpr)arguments.get(0), (BoolExpr)arguments.get(1));
                }
                case EQUIVALENCE: {
                    return FormulaToZ3Translator.this.z3Context.mkEq((Expr)arguments.get(0), (Expr)arguments.get(1));
                }
                case NOT: {
                    return FormulaToZ3Translator.this.z3Context.mkNot((BoolExpr)arguments.get(0));
                }
                case TRUE: {
                    return FormulaToZ3Translator.this.z3Context.mkTrue();
                }
                case FALSE: {
                    return FormulaToZ3Translator.this.z3Context.mkFalse();
                }
            }
            throw new OperatorNotImplementedError(node);
        }

        @Override
        public Expr visitQuantifiedExpressionNode(QuantifiedExpressionNode node, TranslationOptions opt) {
            throw new AssertionError((Object)("Implement: " + node.getClass()));
        }

        @Override
        public Expr visitSetComprehensionNode(SetComprehensionNode node, TranslationOptions opt) {
            Expr comprehensionPredicate = (Expr)this.visitPredicateNode(node.getPredicateNode(), opt);
            Expr elementInComprehension = FormulaToZ3Translator.this.z3Context.mkConst(FormulaToZ3Translator.createFreshTemporaryVariable(), this.getZ3Sort(node));
            Expr[] boundVariables = new Expr[node.getDeclarationList().size()];
            for (int i = 0; i < boundVariables.length; ++i) {
                Expr e;
                DeclarationNode decl = node.getDeclarationList().get(i);
                boundVariables[i] = e = FormulaToZ3Translator.this.z3Context.mkConst(decl.getName(), this.getZ3Sort(decl));
            }
            Expr tuple = null;
            if (boundVariables.length > 1) {
                Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
                TupleSort tupleSort = (TupleSort)this.getZ3Sort(setType.getSubtype());
                tuple = tupleSort.mkDecl().apply(boundVariables);
            } else {
                tuple = boundVariables[0];
            }
            BoolExpr a = FormulaToZ3Translator.this.z3Context.mkSetMembership(tuple, (ArrayExpr)elementInComprehension);
            BoolExpr body = FormulaToZ3Translator.this.z3Context.mkEq((Expr)a, comprehensionPredicate);
            Quantifier q = FormulaToZ3Translator.this.z3Context.mkForall(boundVariables, (Expr)body, boundVariables.length, null, null, null, null);
            FormulaToZ3Translator.this.constraintList.add(q);
            return elementInComprehension;
        }

        @Override
        public Expr visitQuantifiedPredicateNode(QuantifiedPredicateNode node, TranslationOptions opt) {
            Expr[] identifiers = (Expr[])node.getDeclarationList().stream().map(declaration -> FormulaToZ3Translator.this.z3Context.mkConst(declaration.getName(), this.getZ3Sort((TypedNode)declaration))).toArray(Expr[]::new);
            Expr predicate = (Expr)this.visitPredicateNode(node.getPredicateNode(), opt);
            switch (node.getOperator()) {
                case EXISTENTIAL_QUANTIFICATION: {
                    return FormulaToZ3Translator.this.z3Context.mkExists(identifiers, predicate, identifiers.length, null, null, null, null);
                }
                case UNIVERSAL_QUANTIFICATION: {
                    return FormulaToZ3Translator.this.z3Context.mkForall(identifiers, predicate, identifiers.length, null, null, null, null);
                }
            }
            throw new AssertionError((Object)("Implement: " + node.getClass()));
        }

        @Override
        public Expr visitEnumerationSetNode(EnumerationSetNode node, TranslationOptions ops) {
            Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
            Z3TypeInference.Z3Type subtype = setType.getSubtype();
            EnumSort enumSort = (EnumSort)this.getZ3Sort(subtype);
            return FormulaToZ3Translator.this.z3Context.mkFullSet((Sort)enumSort);
        }

        @Override
        public Expr visitDeferredSetNode(DeferredSetNode node, TranslationOptions ops) {
            Z3TypeInference.Z3SetType setType = (Z3TypeInference.Z3SetType)this.getZ3Type(node);
            Z3TypeInference.Z3Type subtype = setType.getSubtype();
            Sort defSetSort = this.getZ3Sort(subtype);
            return FormulaToZ3Translator.this.z3Context.mkFullSet(defSetSort);
        }

        @Override
        public Expr visitEnumeratedSetElementNode(EnumeratedSetElementNode node, TranslationOptions ops) {
            Z3TypeInference.Z3Type z3Type = this.getZ3Type(node);
            Z3TypeInference.Z3EnumeratedSetType enumType = (Z3TypeInference.Z3EnumeratedSetType)z3Type;
            String name = node.getName();
            EnumSort enumSort = (EnumSort)this.getZ3Sort(node);
            return enumSort.getConsts()[enumType.getElements().indexOf(name)];
        }

        class OperatorNotImplementedError
        extends AssertionError {
            private static final long serialVersionUID = 4872994563768693737L;

            OperatorNotImplementedError(OperatorNode<?> node) {
                super((Object)("Not implemented: " + node.getOperator()));
            }
        }
    }
}

