/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.backend.z3;

import com.google.common.reflect.ClassPath;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.visitors.ASTTransformation;
import de.bmoth.parser.ast.visitors.ASTTransformationVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AstTransformationsForZ3 {
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static AstTransformationsForZ3 instance;
    private final List<ASTTransformation> transformationList = new ArrayList<ASTTransformation>();

    private AstTransformationsForZ3() {
        try {
            for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)this.loader).getTopLevelClasses()) {
                if (!info.getName().startsWith("de.bmoth.backend.z3.transformation")) continue;
                Class clazz = info.load();
                this.transformationList.add((ASTTransformation)clazz.newInstance());
            }
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error loading LTL transformation rules", e);
        }
    }

    private static AstTransformationsForZ3 getInstance() {
        if (null == instance) {
            instance = new AstTransformationsForZ3();
        }
        return instance;
    }

    public static MachineNode transformMachineNode(MachineNode machineNode) {
        AstTransformationsForZ3 astTransformationForZ3 = AstTransformationsForZ3.getInstance();
        ASTTransformationVisitor visitor = new ASTTransformationVisitor(astTransformationForZ3.transformationList);
        visitor.transformMachine(machineNode);
        return machineNode;
    }

    public static FormulaNode transformFormulaNode(FormulaNode formulaNode) {
        AstTransformationsForZ3 astTransformationForZ3 = AstTransformationsForZ3.getInstance();
        ASTTransformationVisitor visitor = new ASTTransformationVisitor(astTransformationForZ3.transformationList);
        visitor.transformFormula(formulaNode);
        return formulaNode;
    }
}

