/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Model;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Status;
import de.bmoth.app.PrettyPrinter;
import de.bmoth.backend.z3.FormulaToZ3Translator;
import de.bmoth.parser.Parser;
import de.bmoth.parser.ParserException;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.saxsys.mvvmfx.ViewModel;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ReplViewModel
implements ViewModel {
    private StringProperty code = new SimpleStringProperty();
    private Context ctx = new Context();
    private Solver s = this.ctx.mkSolver();

    StringProperty getCode() {
        return this.code;
    }

    void processPredicate() {
        String predicate = ((String)this.code.get()).substring(((String)this.code.get()).lastIndexOf(10) + 1);
        try {
            FormulaNode node = Parser.getFormulaAsSemanticAst(predicate);
            boolean concatFlag = false;
            if (node.getFormulaType() != FormulaNode.FormulaType.PREDICATE_FORMULA) {
                predicate = "x=" + predicate;
                FormulaNode concatNode = Parser.getFormulaAsSemanticAst(predicate);
                if (concatNode.getFormulaType() != FormulaNode.FormulaType.PREDICATE_FORMULA) {
                    throw new IllegalArgumentException("Input can not be extended to a predicate via an additional variable.");
                }
                concatFlag = true;
            }
            BoolExpr constraint = FormulaToZ3Translator.translatePredicate(predicate, this.ctx);
            this.s.add(new BoolExpr[]{constraint});
            Status check = this.s.check();
            if (check == Status.SATISFIABLE) {
                Model model = this.s.getModel();
                String output = new PrettyPrinter(model).getOutput();
                if (model.toString().equals("")) {
                    this.code.set((Object)((String)this.code.get() + "\n" + check + "\n"));
                } else if (concatFlag) {
                    String concatOutput = output.substring(3, output.length() - 1);
                    this.code.set((Object)((String)this.code.get() + "\n" + concatOutput + "\n"));
                } else {
                    this.code.set((Object)((String)this.code.get() + "\n" + output + "\n"));
                }
            } else {
                this.code.set((Object)((String)this.code.get() + "\nUNSATISFIABLE\n"));
            }
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }
}

