/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.FuncInterp;
import com.microsoft.z3.Model;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_sort_kind;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrettyPrinter {
    private final Logger logger = Logger.getLogger(PrettyPrinter.class.getName());
    private StringJoiner output = new StringJoiner(", ", "{", "}");

    public PrettyPrinter(Model model) {
        FuncDecl[] constantDeclarations;
        for (FuncDecl constantDeclaration : constantDeclarations = model.getConstDecls()) {
            this.output.add(constantDeclaration.getName().toString() + "=" + this.processDeclaration(constantDeclaration, model));
        }
    }

    public String processDeclaration(FuncDecl constantDeclaration, Model model) {
        try {
            if (constantDeclaration.getRange().getSortKind() != Z3_sort_kind.Z3_ARRAY_SORT) {
                Expr constantInterpretation = model.getConstInterp(constantDeclaration);
                if (constantInterpretation.getArgs().length == 0) {
                    return model.getConstInterp(constantDeclaration).toString();
                }
                return this.formatCouple(constantInterpretation, model);
            }
            return this.formatSet(model.getFuncInterp(constantDeclaration), model);
        }
        catch (Z3Exception e) {
            this.logger.log(Level.SEVERE, "Z3 exception while solving", e);
            return null;
        }
    }

    public String processInterpretation(Expr interpretation, Model model) {
        if (interpretation.getSort().getSortKind() == Z3_sort_kind.Z3_DATATYPE_SORT) {
            return this.formatCouple(interpretation, model);
        }
        if (interpretation.getSort().getSortKind() == Z3_sort_kind.Z3_ARRAY_SORT) {
            return interpretation.toString();
        }
        return interpretation.toString();
    }

    public String formatCouple(Expr interpretation, Model model) {
        StringJoiner coupleJoiner = new StringJoiner(",", "(", ")");
        for (Expr element : interpretation.getArgs()) {
            if (element.isNumeral()) {
                coupleJoiner.add(element.toString());
                continue;
            }
            coupleJoiner.add(this.processInterpretation(element, model));
        }
        return coupleJoiner.toString();
    }

    public String formatSet(FuncInterp interpretation, Model model) {
        StringJoiner setJoiner = new StringJoiner(",", "{", "}");
        if (interpretation != null) {
            for (FuncInterp.Entry interpretationEntry : interpretation.getEntries()) {
                if (interpretationEntry.getArgs()[0].isNumeral()) {
                    setJoiner.add(interpretationEntry.getArgs()[0].toString());
                    continue;
                }
                setJoiner.add(this.processInterpretation(interpretationEntry.getArgs()[0], model));
            }
        }
        return setJoiner.toString();
    }

    public String getOutput() {
        return this.output.toString();
    }
}

