/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import de.bmoth.preferences.BMothPreferences;
import de.saxsys.mvvmfx.ViewModel;
import javafx.beans.property.SimpleStringProperty;
import org.apache.commons.lang3.math.NumberUtils;

public class OptionViewModel
implements ViewModel {
    private static final String NONNUMERICWARNING = "Not Numeric or out of Integer-Range: ";
    private SimpleStringProperty minInt = new SimpleStringProperty(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MIN_INT)));
    private SimpleStringProperty maxInt = new SimpleStringProperty(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT)));
    private SimpleStringProperty maxInitState = new SimpleStringProperty(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INITIAL_STATE)));
    private SimpleStringProperty maxTrans = new SimpleStringProperty(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_TRANSITIONS)));
    private SimpleStringProperty z3Timeout = new SimpleStringProperty(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.Z3_TIMEOUT)));
    private SimpleStringProperty alertText = new SimpleStringProperty();

    void loadPrefs() {
        this.getMinInt().set(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MIN_INT)));
        this.getMaxInt().set(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INT)));
        this.getMaxInitState().set(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_INITIAL_STATE)));
        this.getMaxTrans().set(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.MAX_TRANSITIONS)));
        this.getZ3Timeout().set(String.valueOf(BMothPreferences.getIntPreference(BMothPreferences.IntPreference.Z3_TIMEOUT)));
    }

    void savePrefs() {
        BMothPreferences.setIntPreference(BMothPreferences.IntPreference.MIN_INT, Integer.parseInt(this.getMinInt().get()));
        BMothPreferences.setIntPreference(BMothPreferences.IntPreference.MAX_INT, Integer.parseInt(this.getMaxInt().get()));
        BMothPreferences.setIntPreference(BMothPreferences.IntPreference.MAX_INITIAL_STATE, Integer.parseInt(this.getMaxInitState().get()));
        BMothPreferences.setIntPreference(BMothPreferences.IntPreference.MAX_TRANSITIONS, Integer.parseInt(this.getMaxTrans().get()));
        BMothPreferences.setIntPreference(BMothPreferences.IntPreference.Z3_TIMEOUT, Integer.parseInt(this.getZ3Timeout().get()));
    }

    public boolean checkPrefs() {
        if (!NumberUtils.isParsable((String)this.getMinInt().get())) {
            this.getAlertText().set(NONNUMERICWARNING + this.getMinInt().get());
            return false;
        }
        if (!NumberUtils.isParsable((String)this.getMaxInt().get())) {
            this.getAlertText().set(NONNUMERICWARNING + this.getMaxInt().get());
            return false;
        }
        if (!NumberUtils.isParsable((String)this.getMaxInitState().get())) {
            this.getAlertText().set(NONNUMERICWARNING + this.getMaxInitState().get());
            return false;
        }
        if (!NumberUtils.isParsable((String)this.getMaxTrans().get())) {
            this.getAlertText().set(NONNUMERICWARNING + this.getMaxTrans().get());
            return false;
        }
        if (!NumberUtils.isParsable((String)this.getZ3Timeout().get())) {
            this.getAlertText().set(NONNUMERICWARNING + this.getZ3Timeout().get());
            return false;
        }
        if (Integer.parseInt(this.getZ3Timeout().get()) < 0) {
            this.getAlertText().set("Timout needs to be a positive Value");
            return false;
        }
        if (Integer.parseInt(this.getMinInt().get()) > Integer.parseInt(this.getMaxInt().get())) {
            this.getAlertText().set("MIN_INT bigger than MAX_INT");
            return false;
        }
        if (Integer.parseInt(this.getMaxInitState().get()) < 1) {
            this.getAlertText().set("InitialStates needs to be bigger than 0");
            return false;
        }
        if (Integer.parseInt(this.getMaxTrans().get()) < 1) {
            this.getAlertText().set("Maximum transitions needs to be bigger than 0");
            return false;
        }
        return true;
    }

    public SimpleStringProperty getMinInt() {
        return this.minInt;
    }

    public SimpleStringProperty getMaxInt() {
        return this.maxInt;
    }

    public SimpleStringProperty getMaxInitState() {
        return this.maxInitState;
    }

    public SimpleStringProperty getMaxTrans() {
        return this.maxTrans;
    }

    public SimpleStringProperty getZ3Timeout() {
        return this.z3Timeout;
    }

    public SimpleStringProperty getAlertText() {
        return this.alertText;
    }
}

