/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.app;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.microsoft.z3.Status;
import de.bmoth.app.AppViewModel;
import de.bmoth.app.ErrorAlert;
import de.bmoth.app.Highlighter;
import de.bmoth.app.OptionView;
import de.bmoth.app.ReplView;
import de.bmoth.checkers.initialstateexists.InitialStateExistsChecker;
import de.bmoth.checkers.initialstateexists.InitialStateExistsCheckingResult;
import de.bmoth.checkers.invariantsatisfiability.InvariantSatisfiabilityChecker;
import de.bmoth.checkers.invariantsatisfiability.InvariantSatisfiabilityCheckingResult;
import de.bmoth.eventbus.ErrorEvent;
import de.bmoth.eventbus.EventBusProvider;
import de.bmoth.modelchecker.ModelChecker;
import de.bmoth.modelchecker.ModelCheckingResult;
import de.bmoth.modelchecker.bmc.BoundedModelChecker;
import de.bmoth.modelchecker.esmc.ExplicitStateModelChecker;
import de.bmoth.modelchecker.kind.KInductionModelChecker;
import de.bmoth.parser.Parser;
import de.bmoth.parser.ParserException;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.preferences.BMothPreferences;
import de.saxsys.mvvmfx.FluentViewLoader;
import de.saxsys.mvvmfx.FxmlView;
import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyledDocument;

public class AppView
implements FxmlView<AppViewModel>,
Initializable {
    private static final String APPNAME = "Bmoth";
    private static final int MAX_STEPS = 20;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    @FXML
    MenuItem kInductCheck;
    @FXML
    MenuItem boundedCheck;
    @FXML
    MenuItem newFile;
    @FXML
    MenuItem open;
    @FXML
    MenuItem save;
    @FXML
    MenuItem saveAs;
    @FXML
    MenuItem options;
    @FXML
    MenuItem presentation;
    @FXML
    MenuItem exit;
    @FXML
    MenuItem modelCheck;
    @FXML
    CodeArea codeArea;
    @FXML
    TextArea infoArea;
    @FXML
    TextArea warningArea;
    @InjectViewModel
    private AppViewModel appViewModel;
    private Stage primaryStage = new Stage();
    private String currentFile;
    private Boolean hasChanged = false;
    private Task<ModelCheckingResult> task;
    private ModelChecker modelChecker;
    private Thread modelCheckingThread;
    private MachineNode machineNode;
    private Boolean presentationMode = false;

    public void initialize(URL location, ResourceBundle resources) {
        this.save.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}));
        this.newFile.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}));
        this.open.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}));
        this.warningArea.setWrapText(true);
        this.presentation.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}));
        this.codeArea.selectRange(0, 0);
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeArea));
        this.codeArea.richChanges().filter(ch -> !((StyledDocument)ch.getInserted()).equals(ch.getRemoved())).subscribe(change -> this.codeArea.setStyleSpans(0, Highlighter.computeHighlighting(this.codeArea.getText())));
        this.codeArea.setStyleSpans(0, Highlighter.computeHighlighting(this.codeArea.getText()));
        this.codeArea.textProperty().addListener((observableValue, s, t1) -> {
            this.hasChanged = true;
            this.infoArea.setText("Unsaved changes");
        });
        this.appViewModel.codeProperty().bind(this.codeArea.textProperty());
        this.warningArea.textProperty().bind((ObservableValue)this.appViewModel.warningsProperty());
        EventBusProvider.getInstance();
        EventBusProvider.getInstance().getEventBus().register((Object)this);
    }

    void setupStage(Stage stage) {
        this.primaryStage = stage;
        this.setupPersonalPreferences();
        this.primaryStage.setOnCloseRequest(event -> {
            event.consume();
            this.handleExit();
        });
    }

    void setupPersonalPreferences() {
        if (!BMothPreferences.getStringPreference(BMothPreferences.StringPreference.LAST_FILE).isEmpty()) {
            this.currentFile = BMothPreferences.getStringPreference(BMothPreferences.StringPreference.LAST_FILE);
            if (new File(this.currentFile).exists()) {
                File file = new File(this.currentFile);
                String fileContent = this.openFile(file);
                this.codeArea.replaceText(fileContent);
                this.primaryStage.setTitle("Bmoth - " + file.getName().substring(0, file.getName().length() - 4));
            }
            this.codeArea.getUndoManager().forgetHistory();
        }
    }

    @FXML
    public void handleNew() {
        int nextStep = -1;
        if (this.hasChanged.booleanValue()) {
            nextStep = this.handleUnsavedChanges();
        }
        if (nextStep != 0) {
            this.codeArea.replaceText("");
            this.codeArea.getUndoManager().forgetHistory();
            this.codeArea.selectRange(0, 0);
            this.currentFile = null;
            this.hasChanged = false;
            this.primaryStage.setTitle("Bmoth - New Machine");
            this.infoArea.clear();
        }
    }

    @FXML
    public void handleOpen() {
        String fileContent;
        int nextStep = -1;
        if (this.hasChanged.booleanValue()) {
            nextStep = this.handleUnsavedChanges();
        }
        if (!(nextStep != -1 && this.hasChanged.booleanValue() || (fileContent = this.openFileChooser()) == null)) {
            this.codeArea.replaceText(fileContent);
            this.codeArea.getUndoManager().forgetHistory();
            this.codeArea.selectRange(0, 0);
            this.hasChanged = false;
            this.machineNode = null;
            this.warningArea.clear();
            this.infoArea.clear();
        }
    }

    @FXML
    public void handleSave() {
        if (this.currentFile != null) {
            try {
                this.saveFile(this.currentFile);
                this.hasChanged = false;
                this.infoArea.clear();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "While Saving", e);
            }
        } else {
            this.handleSaveAs();
        }
    }

    @FXML
    public Boolean handleSaveAs() {
        try {
            Boolean saved = this.saveFileAs();
            if (saved.booleanValue()) {
                this.hasChanged = false;
                this.infoArea.clear();
            }
            return saved;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "While Saving AS", e);
            return false;
        }
    }

    @FXML
    public void handleExit() {
        if (this.hasChanged.booleanValue()) {
            int nextStep = this.handleUnsavedChanges();
            if (nextStep == -1 || !this.hasChanged.booleanValue()) {
                Platform.exit();
            }
        } else {
            Platform.exit();
        }
    }

    @FXML
    public void handleOptions() throws IOException {
        ViewTuple viewOptionViewModelViewTuple = FluentViewLoader.fxmlView(OptionView.class).load();
        Parent root = viewOptionViewModelViewTuple.getView();
        Scene scene = new Scene(root);
        Stage optionStage = new Stage();
        optionStage.setScene(scene);
        optionStage.show();
    }

    @FXML
    public void handleCheck() {
        if (this.codeArea.getText().replaceAll("\\s+", "").length() > 0) {
            this.parseMachineNode();
            this.modelChecker = new ExplicitStateModelChecker(this.machineNode);
            this.checkWithChecker();
        }
    }

    public void handleBounded() {
        if (this.codeArea.getText().replaceAll("\\s+", "").length() > 0) {
            this.parseMachineNode();
            this.modelChecker = new BoundedModelChecker(this.machineNode, 20);
            this.checkWithChecker();
        }
    }

    public void handleKInduct() {
        if (this.codeArea.getText().replaceAll("\\s+", "").length() > 0) {
            this.parseMachineNode();
            this.modelChecker = new KInductionModelChecker(this.machineNode, 20);
            this.checkWithChecker();
        }
    }

    public void checkWithChecker() {
        this.task = new Task<ModelCheckingResult>(){

            protected ModelCheckingResult call() throws Exception {
                AppView.this.infoArea.setText("Model checking started.");
                return AppView.this.modelChecker.check();
            }
        };
        this.task.setOnSucceeded(event -> {
            this.infoArea.setText("Model checking finished.");
            ModelCheckingResult result = (ModelCheckingResult)this.task.getValue();
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Model Checking Result");
            alert.setOnCloseRequest(e -> this.infoArea.clear());
            switch (result.getType()) {
                case VERIFIED: {
                    alert.setHeaderText("The model is...");
                    alert.setContentText("...VERIFIED by " + this.modelChecker.getClass().getSimpleName() + "!\nNo counter-example found.");
                    break;
                }
                case EXCEEDED_MAX_STEPS: {
                    alert.setHeaderText("The model is...");
                    alert.setContentText("...correct for " + result.getSteps() + " steps!\n(Warning: Exceeded max steps)");
                    break;
                }
                case COUNTER_EXAMPLE_FOUND: {
                    alert.setHeaderText("The model is...");
                    alert.setContentText("...not correct!\nCounter-example found in state " + result.getLastState().toString() + ".\nReversed path: " + result.getCounterExamplePath());
                    break;
                }
                case LTL_COUNTER_EXAMPLE_FOUND: {
                    alert.setHeaderText("The LTL-model is...");
                    alert.setContentText("...not correct!\nCounter-example found in state " + result.getLastState().toString() + ".\nReversed path: " + result.getCounterExamplePath());
                    break;
                }
                case UNKNOWN: {
                    alert.setHeaderText("Model checking result unknown...");
                    alert.setContentText("... reason: " + result.getReason());
                    break;
                }
                case ABORTED: {
                    alert.setHeaderText("Model checking aborted...");
                    alert.setContentText("... after " + result.getSteps() + " steps");
                }
            }
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.showAndWait();
        });
        this.task.setOnCancelled(event -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Model Checking Result");
            alert.setHeaderText("Model checking was canceled!");
            alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
            alert.setOnCloseRequest(e -> this.infoArea.clear());
            alert.showAndWait();
        });
        this.modelCheckingThread = new Thread((Runnable)this.task);
        this.modelCheckingThread.start();
    }

    private void parseMachineNode() {
        if (this.hasChanged.booleanValue() || this.machineNode == null) {
            this.handleSave();
            try {
                this.machineNode = Parser.getMachineAsSemanticAst(this.codeArea.getText());
            }
            catch (ParserException e) {
                EventBus eventBus = EventBusProvider.getInstance().getEventBus();
                eventBus.post((Object)new ErrorEvent("Syntax error", e.toString(), e));
                return;
            }
            if (!this.machineNode.getWarnings().isEmpty()) {
                this.warningArea.setText(this.machineNode.getWarnings().toString());
            }
        }
    }

    @FXML
    public void handelCancelModelCheck(ActionEvent actionEvent) {
        this.task.cancel();
        this.modelCheckingThread.interrupt();
    }

    @FXML
    public void handleInvariantSatisfiability() {
        if (this.codeArea.getText().replaceAll("\\s+", "").length() > 0) {
            this.parseMachineNode();
            InvariantSatisfiabilityCheckingResult result = InvariantSatisfiabilityChecker.doInvariantSatisfiabilityCheck(this.machineNode);
            this.showResultAlert(false, result.getResult());
        }
    }

    public void handleInitialStateExists() {
        if (this.codeArea.getText().replaceAll("\\s+", "").length() > 0) {
            if (this.hasChanged.booleanValue() || this.machineNode == null) {
                this.handleSave();
                try {
                    this.machineNode = Parser.getMachineAsSemanticAst(this.codeArea.getText());
                }
                catch (ParserException e) {
                    EventBus eventBus = EventBusProvider.getInstance().getEventBus();
                    eventBus.post((Object)new ErrorEvent("Parse error", e.toString(), e));
                    return;
                }
            }
            InitialStateExistsCheckingResult result = InitialStateExistsChecker.doInitialStateExistsCheck(this.machineNode);
            this.showResultAlert(true, result.getResult());
        }
    }

    private void showResultAlert(boolean initial, Status status) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(initial ? "Check for Initial State" : "Check Invariant Satisfiability");
        alert.setHeaderText(initial ? "Initial state..." : "State satisfying the invariant...");
        switch (status) {
            case UNSATISFIABLE: {
                alert.setContentText("...does not exist!\nThe model is probably not correct.");
                break;
            }
            case UNKNOWN: {
                alert.setContentText("...is unknown!\nThe initialization is too complex for the backend.");
                break;
            }
            case SATISFIABLE: {
                alert.setContentText("...exists!");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled result: " + status.toString());
            }
        }
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.showAndWait();
    }

    @FXML
    public void handleREPL() throws IOException {
        ViewTuple viewReplViewModelViewTuple = FluentViewLoader.fxmlView(ReplView.class).load();
        Parent root = viewReplViewModelViewTuple.getView();
        Scene scene = new Scene(root);
        Stage replStage = new Stage();
        replStage.setTitle("REPL");
        replStage.setScene(scene);
        replStage.show();
    }

    private int handleUnsavedChanges() {
        int nextStep = this.saveChangedDialog();
        switch (nextStep) {
            case 0: {
                break;
            }
            case 1: {
                this.handleSave();
                break;
            }
            case 2: {
                this.handleSaveAs();
                break;
            }
            case -1: {
                break;
            }
        }
        return nextStep;
    }

    private int saveChangedDialog() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("UNSAVED CHANGES!");
        alert.setHeaderText("Unsaved Changes! What do you want to do?");
        alert.setContentText(null);
        ButtonType buttonTypeSave = new ButtonType("Save");
        ButtonType buttonTypeSaveAs = new ButtonType("Save As");
        ButtonType buttonTypeIgnoreChanges = new ButtonType("Ignore");
        ButtonType buttonTypeCancel = new ButtonType("Back", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeSave, buttonTypeSaveAs, buttonTypeIgnoreChanges, buttonTypeCancel});
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        Optional result = alert.showAndWait();
        if (result.isPresent()) {
            if (result.get() == buttonTypeSave) {
                return 1;
            }
            if (result.get() == buttonTypeSaveAs) {
                return 2;
            }
            if (result.get() == buttonTypeCancel) {
                return 0;
            }
            if (result.get() == buttonTypeIgnoreChanges) {
                return -1;
            }
        }
        return 0;
    }

    private void saveFile(String path) throws IOException {
        File file = new File(path);
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(this.codeArea.getText());
            this.currentFile = file.getAbsolutePath();
            this.primaryStage.setTitle("Bmoth - " + file.getName().substring(0, file.getName().length() - 4));
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_FILE, file.getAbsolutePath());
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_DIR, file.getParent());
        }
    }

    private Boolean saveFileAs() throws IOException {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(new File(BMothPreferences.getStringPreference(BMothPreferences.StringPreference.LAST_DIR)));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("MCH File", new String[]{"*.mch"}));
        File file = fileChooser.showSaveDialog((Window)this.primaryStage);
        if (file != null) {
            if (!file.getAbsolutePath().endsWith(".mch")) {
                this.saveFile(file.getAbsolutePath() + ".mch");
            } else {
                this.saveFile(file.getAbsolutePath());
            }
            this.currentFile = file.getAbsolutePath();
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_FILE, file.getAbsolutePath());
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_DIR, file.getParent());
            return true;
        }
        return false;
    }

    private String openFileChooser() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Open MCH File", new String[]{"*.mch"}));
        fileChooser.setTitle("Choose File");
        File f = new File(BMothPreferences.getStringPreference(BMothPreferences.StringPreference.LAST_DIR));
        fileChooser.setInitialDirectory(f.exists() && f.isDirectory() ? f : new File("."));
        File file = fileChooser.showOpenDialog((Window)this.primaryStage);
        if (file != null) {
            this.currentFile = file.getPath();
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_FILE, file.getAbsolutePath());
            BMothPreferences.setStringPreference(BMothPreferences.StringPreference.LAST_DIR, file.getParent());
            this.primaryStage.setTitle("Bmoth - " + file.getName().substring(0, file.getName().length() - 4));
            return this.openFile(file);
        }
        return null;
    }

    private String openFile(File file) {
        String content = null;
        try {
            content = new String(Files.readAllBytes(Paths.get(file.getPath(), new String[0])));
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "While Reading File", e);
        }
        return content;
    }

    @Subscribe
    public void showException(ErrorEvent event) {
        new ErrorAlert(Alert.AlertType.ERROR, event.getErrorType(), event.getMessage());
    }

    public void handlePresentation(ActionEvent actionEvent) {
        if (!this.presentationMode.booleanValue()) {
            this.codeArea.setStyle("-fx-font-size:25");
            this.presentationMode = true;
        } else {
            this.codeArea.setStyle("-fx-font-size:15");
            this.presentationMode = false;
        }
    }
}

