/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.z3;

import com.microsoft.z3.AST;
import com.microsoft.z3.AlgebraicNum;
import com.microsoft.z3.ArrayExpr;
import com.microsoft.z3.BitVecExpr;
import com.microsoft.z3.BitVecNum;
import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.DatatypeExpr;
import com.microsoft.z3.FPExpr;
import com.microsoft.z3.FPNum;
import com.microsoft.z3.FPRMExpr;
import com.microsoft.z3.FPRMNum;
import com.microsoft.z3.FiniteDomainExpr;
import com.microsoft.z3.FiniteDomainNum;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.IntExpr;
import com.microsoft.z3.IntNum;
import com.microsoft.z3.Native;
import com.microsoft.z3.Params;
import com.microsoft.z3.Quantifier;
import com.microsoft.z3.RatNum;
import com.microsoft.z3.ReExpr;
import com.microsoft.z3.RealExpr;
import com.microsoft.z3.SeqExpr;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Z3Exception;
import com.microsoft.z3.enumerations.Z3_ast_kind;
import com.microsoft.z3.enumerations.Z3_decl_kind;
import com.microsoft.z3.enumerations.Z3_lbool;
import com.microsoft.z3.enumerations.Z3_sort_kind;

public class Expr
extends AST {
    public Expr simplify() {
        return this.simplify(null);
    }

    public Expr simplify(Params params) {
        if (params == null) {
            return Expr.create(this.getContext(), Native.simplify(this.getContext().nCtx(), this.getNativeObject()));
        }
        return Expr.create(this.getContext(), Native.simplifyEx(this.getContext().nCtx(), this.getNativeObject(), params.getNativeObject()));
    }

    public FuncDecl getFuncDecl() {
        return new FuncDecl(this.getContext(), Native.getAppDecl(this.getContext().nCtx(), this.getNativeObject()));
    }

    public Z3_lbool getBoolValue() {
        return Z3_lbool.fromInt(Native.getBoolValue(this.getContext().nCtx(), this.getNativeObject()));
    }

    public int getNumArgs() {
        return Native.getAppNumArgs(this.getContext().nCtx(), this.getNativeObject());
    }

    public Expr[] getArgs() {
        int n = this.getNumArgs();
        Expr[] exprArray = new Expr[n];
        for (int i = 0; i < n; ++i) {
            exprArray[i] = Expr.create(this.getContext(), Native.getAppArg(this.getContext().nCtx(), this.getNativeObject(), i));
        }
        return exprArray;
    }

    public Expr update(Expr[] exprArray) {
        this.getContext().checkContextMatch(exprArray);
        if (this.isApp() && exprArray.length != this.getNumArgs()) {
            throw new Z3Exception("Number of arguments does not match");
        }
        return new Expr(this.getContext(), Native.updateTerm(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray)));
    }

    public Expr substitute(Expr[] exprArray, Expr[] exprArray2) {
        this.getContext().checkContextMatch(exprArray);
        this.getContext().checkContextMatch(exprArray2);
        if (exprArray.length != exprArray2.length) {
            throw new Z3Exception("Argument sizes do not match");
        }
        return Expr.create(this.getContext(), Native.substitute(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray), Expr.arrayToNative(exprArray2)));
    }

    public Expr substitute(Expr expr, Expr expr2) {
        return this.substitute(new Expr[]{expr}, new Expr[]{expr2});
    }

    public Expr substituteVars(Expr[] exprArray) {
        this.getContext().checkContextMatch(exprArray);
        return Expr.create(this.getContext(), Native.substituteVars(this.getContext().nCtx(), this.getNativeObject(), exprArray.length, Expr.arrayToNative(exprArray)));
    }

    @Override
    public Expr translate(Context context) {
        if (this.getContext() == context) {
            return this;
        }
        return Expr.create(context, Native.translate(this.getContext().nCtx(), this.getNativeObject(), context.nCtx()));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public boolean isNumeral() {
        return Native.isNumeralAst(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isWellSorted() {
        return Native.isWellSorted(this.getContext().nCtx(), this.getNativeObject());
    }

    public Sort getSort() {
        return Sort.create(this.getContext(), Native.getSort(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isConst() {
        return this.isApp() && this.getNumArgs() == 0 && this.getFuncDecl().getDomainSize() == 0;
    }

    public boolean isIntNum() {
        return this.isNumeral() && this.isInt();
    }

    public boolean isRatNum() {
        return this.isNumeral() && this.isReal();
    }

    public boolean isAlgebraicNumber() {
        return Native.isAlgebraicNumber(this.getContext().nCtx(), this.getNativeObject());
    }

    public boolean isBool() {
        return this.isExpr() && Native.isEqSort(this.getContext().nCtx(), Native.mkBoolSort(this.getContext().nCtx()), Native.getSort(this.getContext().nCtx(), this.getNativeObject()));
    }

    public boolean isTrue() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TRUE;
    }

    public boolean isFalse() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_FALSE;
    }

    public boolean isEq() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EQ;
    }

    public boolean isDistinct() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_DISTINCT;
    }

    public boolean isITE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ITE;
    }

    public boolean isAnd() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_AND;
    }

    public boolean isOr() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_OR;
    }

    public boolean isIff() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IFF;
    }

    public boolean isXor() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_XOR;
    }

    public boolean isNot() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_NOT;
    }

    public boolean isImplies() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IMPLIES;
    }

    public boolean isInt() {
        return Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_INT_SORT.toInt();
    }

    public boolean isReal() {
        return Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_REAL_SORT.toInt();
    }

    public boolean isArithmeticNumeral() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ANUM;
    }

    public boolean isLE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LE;
    }

    public boolean isGE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_GE;
    }

    public boolean isLT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LT;
    }

    public boolean isGT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_GT;
    }

    public boolean isAdd() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ADD;
    }

    public boolean isSub() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SUB;
    }

    public boolean isUMinus() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UMINUS;
    }

    public boolean isMul() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_MUL;
    }

    public boolean isDiv() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_DIV;
    }

    public boolean isIDiv() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IDIV;
    }

    public boolean isRemainder() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_REM;
    }

    public boolean isModulus() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_MOD;
    }

    public boolean isIntToReal() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TO_REAL;
    }

    public boolean isRealToInt() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_TO_INT;
    }

    public boolean isRealIsInt() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_IS_INT;
    }

    public boolean isArray() {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Z3_sort_kind.fromInt(Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject()))) == Z3_sort_kind.Z3_ARRAY_SORT;
    }

    public boolean isStore() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_STORE;
    }

    public boolean isSelect() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SELECT;
    }

    public boolean isConstantArray() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CONST_ARRAY;
    }

    public boolean isDefaultArray() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ARRAY_DEFAULT;
    }

    public boolean isArrayMap() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ARRAY_MAP;
    }

    public boolean isAsArray() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_AS_ARRAY;
    }

    public boolean isSetUnion() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_UNION;
    }

    public boolean isSetIntersect() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_INTERSECT;
    }

    public boolean isSetDifference() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_DIFFERENCE;
    }

    public boolean isSetComplement() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_COMPLEMENT;
    }

    public boolean isSetSubset() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SET_SUBSET;
    }

    public boolean isBV() {
        return Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_BV_SORT.toInt();
    }

    public boolean isBVNumeral() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNUM;
    }

    public boolean isBVBitOne() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BIT1;
    }

    public boolean isBVBitZero() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BIT0;
    }

    public boolean isBVUMinus() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNEG;
    }

    public boolean isBVAdd() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BADD;
    }

    public boolean isBVSub() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSUB;
    }

    public boolean isBVMul() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BMUL;
    }

    public boolean isBVSDiv() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSDIV;
    }

    public boolean isBVUDiv() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUDIV;
    }

    public boolean isBVSRem() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSREM;
    }

    public boolean isBVURem() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUREM;
    }

    public boolean isBVSMod() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSMOD;
    }

    boolean isBVSDiv0() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSDIV0;
    }

    boolean isBVUDiv0() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUDIV0;
    }

    boolean isBVSRem0() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSREM0;
    }

    boolean isBVURem0() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BUREM0;
    }

    boolean isBVSMod0() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSMOD0;
    }

    public boolean isBVULE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ULEQ;
    }

    public boolean isBVSLE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SLEQ;
    }

    public boolean isBVUGE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UGEQ;
    }

    public boolean isBVSGE() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SGEQ;
    }

    public boolean isBVULT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ULT;
    }

    public boolean isBVSLT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SLT;
    }

    public boolean isBVUGT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_UGT;
    }

    public boolean isBVSGT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SGT;
    }

    public boolean isBVAND() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BAND;
    }

    public boolean isBVOR() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BOR;
    }

    public boolean isBVNOT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNOT;
    }

    public boolean isBVXOR() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BXOR;
    }

    public boolean isBVNAND() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNAND;
    }

    public boolean isBVNOR() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BNOR;
    }

    public boolean isBVXNOR() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BXNOR;
    }

    public boolean isBVConcat() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CONCAT;
    }

    public boolean isBVSignExtension() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_SIGN_EXT;
    }

    public boolean isBVZeroExtension() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ZERO_EXT;
    }

    public boolean isBVExtract() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXTRACT;
    }

    public boolean isBVRepeat() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_REPEAT;
    }

    public boolean isBVReduceOR() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BREDOR;
    }

    public boolean isBVReduceAND() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BREDAND;
    }

    public boolean isBVComp() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BCOMP;
    }

    public boolean isBVShiftLeft() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BSHL;
    }

    public boolean isBVShiftRightLogical() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BLSHR;
    }

    public boolean isBVShiftRightArithmetic() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BASHR;
    }

    public boolean isBVRotateLeft() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ROTATE_LEFT;
    }

    public boolean isBVRotateRight() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_ROTATE_RIGHT;
    }

    public boolean isBVRotateLeftExtended() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_LEFT;
    }

    public boolean isBVRotateRightExtended() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_EXT_ROTATE_RIGHT;
    }

    public boolean isIntToBV() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_INT2BV;
    }

    public boolean isBVToInt() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_BV2INT;
    }

    public boolean isBVCarry() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_CARRY;
    }

    public boolean isBVXOR3() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_XOR3;
    }

    public boolean isLabel() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LABEL;
    }

    public boolean isLabelLit() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_LABEL_LIT;
    }

    public boolean isOEQ() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_OEQ;
    }

    public boolean isProofTrue() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRUE;
    }

    public boolean isProofAsserted() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_ASSERTED;
    }

    public boolean isProofGoal() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_GOAL;
    }

    public boolean isProofModusPonens() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS;
    }

    public boolean isProofReflexivity() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REFLEXIVITY;
    }

    public boolean isProofSymmetry() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_SYMMETRY;
    }

    public boolean isProofTransitivity() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY;
    }

    public boolean isProofTransitivityStar() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TRANSITIVITY_STAR;
    }

    public boolean isProofMonotonicity() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MONOTONICITY;
    }

    public boolean isProofQuantIntro() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INTRO;
    }

    public boolean isProofDistributivity() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DISTRIBUTIVITY;
    }

    public boolean isProofAndElimination() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_AND_ELIM;
    }

    public boolean isProofOrElimination() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NOT_OR_ELIM;
    }

    public boolean isProofRewrite() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE;
    }

    public boolean isProofRewriteStar() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_REWRITE_STAR;
    }

    public boolean isProofPullQuant() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT;
    }

    public boolean isProofPullQuantStar() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PULL_QUANT_STAR;
    }

    public boolean isProofPushQuant() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_PUSH_QUANT;
    }

    public boolean isProofElimUnusedVars() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_ELIM_UNUSED_VARS;
    }

    public boolean isProofDER() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DER;
    }

    public boolean isProofQuantInst() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_QUANT_INST;
    }

    public boolean isProofHypothesis() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_HYPOTHESIS;
    }

    public boolean isProofLemma() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_LEMMA;
    }

    public boolean isProofUnitResolution() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_UNIT_RESOLUTION;
    }

    public boolean isProofIFFTrue() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_TRUE;
    }

    public boolean isProofIFFFalse() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_FALSE;
    }

    public boolean isProofCommutativity() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_COMMUTATIVITY;
    }

    public boolean isProofDefAxiom() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_AXIOM;
    }

    public boolean isProofDefIntro() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_DEF_INTRO;
    }

    public boolean isProofApplyDef() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_APPLY_DEF;
    }

    public boolean isProofIFFOEQ() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_IFF_OEQ;
    }

    public boolean isProofNNFPos() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_POS;
    }

    public boolean isProofNNFNeg() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_NEG;
    }

    public boolean isProofNNFStar() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_NNF_STAR;
    }

    public boolean isProofCNFStar() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_CNF_STAR;
    }

    public boolean isProofSkolemize() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_SKOLEMIZE;
    }

    public boolean isProofModusPonensOEQ() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_MODUS_PONENS_OEQ;
    }

    public boolean isProofTheoryLemma() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_PR_TH_LEMMA;
    }

    public boolean isRelation() {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_RELATION_SORT.toInt();
    }

    public boolean isRelationStore() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_STORE;
    }

    public boolean isEmptyRelation() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_EMPTY;
    }

    public boolean isIsEmptyRelation() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_IS_EMPTY;
    }

    public boolean isRelationalJoin() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_JOIN;
    }

    public boolean isRelationUnion() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_UNION;
    }

    public boolean isRelationWiden() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_WIDEN;
    }

    public boolean isRelationProject() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_PROJECT;
    }

    public boolean isRelationFilter() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_FILTER;
    }

    public boolean isRelationNegationFilter() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_NEGATION_FILTER;
    }

    public boolean isRelationRename() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_RENAME;
    }

    public boolean isRelationComplement() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_COMPLEMENT;
    }

    public boolean isRelationSelect() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_SELECT;
    }

    public boolean isRelationClone() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_RA_CLONE;
    }

    public boolean isFiniteDomain() {
        return Native.isApp(this.getContext().nCtx(), this.getNativeObject()) && Native.getSortKind(this.getContext().nCtx(), Native.getSort(this.getContext().nCtx(), this.getNativeObject())) == Z3_sort_kind.Z3_FINITE_DOMAIN_SORT.toInt();
    }

    public boolean isFiniteDomainLT() {
        return this.isApp() && this.getFuncDecl().getDeclKind() == Z3_decl_kind.Z3_OP_FD_LT;
    }

    public int getIndex() {
        if (!this.isVar()) {
            throw new Z3Exception("Term is not a bound variable.");
        }
        return Native.getIndexValue(this.getContext().nCtx(), this.getNativeObject());
    }

    protected Expr(Context context, long l) {
        super(context, l);
    }

    @Override
    void checkNativeObject(long l) {
        if (!Native.isApp(this.getContext().nCtx(), l) && Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_VAR_AST.toInt() && Native.getAstKind(this.getContext().nCtx(), l) != Z3_ast_kind.Z3_QUANTIFIER_AST.toInt()) {
            throw new Z3Exception("Underlying object is not a term");
        }
        super.checkNativeObject(l);
    }

    static Expr create(Context context, FuncDecl funcDecl, Expr ... exprArray) {
        long l = Native.mkApp(context.nCtx(), funcDecl.getNativeObject(), AST.arrayLength(exprArray), AST.arrayToNative(exprArray));
        return Expr.create(context, l);
    }

    static Expr create(Context context, long l) {
        Z3_ast_kind z3_ast_kind = Z3_ast_kind.fromInt(Native.getAstKind(context.nCtx(), l));
        if (z3_ast_kind == Z3_ast_kind.Z3_QUANTIFIER_AST) {
            return new Quantifier(context, l);
        }
        long l2 = Native.getSort(context.nCtx(), l);
        Z3_sort_kind z3_sort_kind = Z3_sort_kind.fromInt(Native.getSortKind(context.nCtx(), l2));
        if (Native.isAlgebraicNumber(context.nCtx(), l)) {
            return new AlgebraicNum(context, l);
        }
        if (Native.isNumeralAst(context.nCtx(), l)) {
            switch (z3_sort_kind) {
                case Z3_INT_SORT: {
                    return new IntNum(context, l);
                }
                case Z3_REAL_SORT: {
                    return new RatNum(context, l);
                }
                case Z3_BV_SORT: {
                    return new BitVecNum(context, l);
                }
                case Z3_FLOATING_POINT_SORT: {
                    return new FPNum(context, l);
                }
                case Z3_ROUNDING_MODE_SORT: {
                    return new FPRMNum(context, l);
                }
                case Z3_FINITE_DOMAIN_SORT: {
                    return new FiniteDomainNum(context, l);
                }
            }
        }
        switch (z3_sort_kind) {
            case Z3_BOOL_SORT: {
                return new BoolExpr(context, l);
            }
            case Z3_INT_SORT: {
                return new IntExpr(context, l);
            }
            case Z3_REAL_SORT: {
                return new RealExpr(context, l);
            }
            case Z3_BV_SORT: {
                return new BitVecExpr(context, l);
            }
            case Z3_ARRAY_SORT: {
                return new ArrayExpr(context, l);
            }
            case Z3_DATATYPE_SORT: {
                return new DatatypeExpr(context, l);
            }
            case Z3_FLOATING_POINT_SORT: {
                return new FPExpr(context, l);
            }
            case Z3_ROUNDING_MODE_SORT: {
                return new FPRMExpr(context, l);
            }
            case Z3_FINITE_DOMAIN_SORT: {
                return new FiniteDomainExpr(context, l);
            }
            case Z3_SEQ_SORT: {
                return new SeqExpr(context, l);
            }
            case Z3_RE_SORT: {
                return new ReExpr(context, l);
            }
        }
        return new Expr(context, l);
    }
}

