/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.util;

import java.time.Duration;
import javafx.beans.value.ObservableBooleanValue;
import org.fxmisc.undo.UndoManager;
import org.reactfx.EventStream;
import org.reactfx.Subscription;
import org.reactfx.value.Val;

final class UndoManagerInactivityWrapper<C>
implements UndoManager<C> {
    private final UndoManager<C> delegate;
    private final Subscription subscription;

    public UndoManagerInactivityWrapper(UndoManager<C> undoManager, EventStream<C> changeSource, Duration preventMergeDelay) {
        this.delegate = undoManager;
        this.subscription = changeSource.successionEnds(preventMergeDelay).subscribe(ignore -> this.preventMerge());
    }

    public boolean undo() {
        return this.delegate.undo();
    }

    public boolean redo() {
        return this.delegate.redo();
    }

    public Val<Boolean> undoAvailableProperty() {
        return this.delegate.undoAvailableProperty();
    }

    public boolean isUndoAvailable() {
        return this.delegate.isUndoAvailable();
    }

    public Val<C> nextToUndoProperty() {
        return this.delegate.nextToUndoProperty();
    }

    public C getNextToUndo() {
        return (C)this.delegate.getNextToUndo();
    }

    public Val<C> nextToRedoProperty() {
        return this.delegate.nextToRedoProperty();
    }

    public C getNextToRedo() {
        return (C)this.delegate.getNextToRedo();
    }

    public Val<Boolean> redoAvailableProperty() {
        return this.delegate.redoAvailableProperty();
    }

    public boolean isRedoAvailable() {
        return this.delegate.isRedoAvailable();
    }

    public ObservableBooleanValue performingActionProperty() {
        return this.delegate.performingActionProperty();
    }

    public boolean isPerformingAction() {
        return this.delegate.isPerformingAction();
    }

    public void preventMerge() {
        this.delegate.preventMerge();
    }

    public void forgetHistory() {
        this.delegate.forgetHistory();
    }

    public UndoManager.UndoPosition getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    public void mark() {
        this.delegate.mark();
    }

    public ObservableBooleanValue atMarkedPositionProperty() {
        return this.delegate.atMarkedPositionProperty();
    }

    public boolean isAtMarkedPosition() {
        return this.delegate.isAtMarkedPosition();
    }

    public void close() {
        this.subscription.unsubscribe();
        this.delegate.close();
    }
}

