/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.internal.SideEffect;
import de.saxsys.mvvmfx.utils.mapping.ImmutablePropertyField;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.Property;

public class ImmutableBeanPropertyField<T, M, R extends Property<T>>
implements ImmutablePropertyField<T, M, R> {
    private T defaultValue;
    private final R targetProperty;
    private final Function<M, T> getter;
    private final BiFunction<M, T, M> immutableSetter;

    public ImmutableBeanPropertyField(SideEffect updateFunction, Function<M, T> getter, BiFunction<M, T, M> immutableSetter, Supplier<R> propertySupplier) {
        this(updateFunction, getter, immutableSetter, null, propertySupplier);
    }

    public ImmutableBeanPropertyField(SideEffect updateFunction, Function<M, T> getter, BiFunction<M, T, M> immutableSetter, T defaultValue, Supplier<R> propertySupplier) {
        this.getter = getter;
        this.immutableSetter = immutableSetter;
        this.defaultValue = defaultValue;
        this.targetProperty = (Property)propertySupplier.get();
        this.targetProperty.addListener((observable, oldValue, newValue) -> updateFunction.call());
    }

    @Override
    public void commit(M wrappedObject) {
    }

    @Override
    public M commitImmutable(M wrappedObject) {
        return this.immutableSetter.apply(wrappedObject, this.targetProperty.getValue());
    }

    @Override
    public void reload(M wrappedObject) {
        this.targetProperty.setValue(this.getter.apply(wrappedObject));
    }

    @Override
    public void resetToDefault() {
        this.targetProperty.setValue(this.defaultValue);
    }

    @Override
    public void updateDefault(M wrappedObject) {
        this.defaultValue = this.getter.apply(wrappedObject);
    }

    @Override
    public R getProperty() {
        return this.targetProperty;
    }

    @Override
    public boolean isDifferent(M wrappedObject) {
        Object wrapperValue;
        T modelValue = this.getter.apply(wrappedObject);
        return !Objects.equals(modelValue, wrapperValue = this.targetProperty.getValue());
    }
}

