/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.cst;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.antlr.BMoThParserBaseVisitor;
import de.bmoth.parser.cst.ScopeException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class ScopeChecker
extends BMoThParserBaseVisitor<Void> {
    final LinkedList<LinkedHashMap<String, TerminalNode>> scopeTable = new LinkedList();
    final LinkedHashMap<TerminalNode, TerminalNode> declarationReferences = new LinkedHashMap();

    @Override
    public Void visitIdentifierExpression(BMoThParser.IdentifierExpressionContext ctx) {
        this.lookUpTerminalNode(ctx.IDENTIFIER());
        return null;
    }

    @Override
    public Void visitPredicateIdentifier(BMoThParser.PredicateIdentifierContext ctx) {
        this.lookUpTerminalNode(ctx.IDENTIFIER());
        return null;
    }

    @Override
    public Void visitSetComprehensionExpression(BMoThParser.SetComprehensionExpressionContext ctx) {
        this.visitQuantifiedFormula(ctx.identifier_list().IDENTIFIER(), ctx.predicate());
        return null;
    }

    @Override
    public Void visitQuantifiedExpression(BMoThParser.QuantifiedExpressionContext ctx) {
        this.visitQuantifiedFormula(ctx.quantified_variables_list().identifier_list().IDENTIFIER(), ctx.predicate(), ctx.expression());
        return null;
    }

    @Override
    public Void visitQuantifiedPredicate(BMoThParser.QuantifiedPredicateContext ctx) {
        this.visitQuantifiedFormula(ctx.quantified_variables_list().identifier_list().IDENTIFIER(), ctx.predicate());
        return null;
    }

    private void visitQuantifiedFormula(List<TerminalNode> identifiers, ParserRuleContext ... contexts) {
        LinkedHashMap<String, TerminalNode> localIdentifiers = new LinkedHashMap<String, TerminalNode>();
        for (TerminalNode terminalNode : identifiers) {
            localIdentifiers.put(terminalNode.getSymbol().getText(), terminalNode);
        }
        this.scopeTable.add(localIdentifiers);
        for (ParserRuleContext node : contexts) {
            node.accept((ParseTreeVisitor)this);
        }
        this.scopeTable.removeLast();
    }

    @Override
    public Void visitAssignSubstitution(BMoThParser.AssignSubstitutionContext ctx) {
        ctx.identifier_list().IDENTIFIER().stream().forEach(this::lookUpTerminalNode);
        ctx.expression_list().accept(this);
        return null;
    }

    @Override
    public Void visitBecomesElementOfSubstitution(BMoThParser.BecomesElementOfSubstitutionContext ctx) {
        ctx.identifier_list().IDENTIFIER().stream().forEach(this::lookUpTerminalNode);
        ctx.expression().accept(this);
        return null;
    }

    @Override
    public Void visitBecomesSuchThatSubstitution(BMoThParser.BecomesSuchThatSubstitutionContext ctx) {
        ctx.identifier_list().IDENTIFIER().stream().forEach(this::lookUpTerminalNode);
        ctx.predicate().accept(this);
        return null;
    }

    public void lookUpTerminalNode(TerminalNode terminalNode) {
        Token identifierToken = terminalNode.getSymbol();
        String name = identifierToken.getText();
        for (int i = this.scopeTable.size() - 1; i >= 0; --i) {
            LinkedHashMap<String, TerminalNode> map = this.scopeTable.get(i);
            if (!map.containsKey(name)) continue;
            TerminalNode declarationToken = map.get(name);
            this.addDeclarationReference(terminalNode, declarationToken);
            return;
        }
        this.identifierNodeNotFound(terminalNode);
    }

    @Override
    public Void visitAnySubstitution(BMoThParser.AnySubstitutionContext ctx) {
        LinkedHashMap<String, TerminalNode> localIdentifiers = new LinkedHashMap<String, TerminalNode>();
        for (TerminalNode terminalNode : ctx.identifier_list().IDENTIFIER()) {
            localIdentifiers.put(terminalNode.getSymbol().getText(), terminalNode);
        }
        this.scopeTable.add(localIdentifiers);
        ctx.predicate().accept(this);
        ctx.substitution().accept(this);
        this.scopeTable.removeLast();
        return null;
    }

    public void addDeclarationReference(TerminalNode identifierToken, TerminalNode declarationToken) {
        this.declarationReferences.put(identifierToken, declarationToken);
    }

    public void identifierNodeNotFound(TerminalNode terminalNode) {
        throw new ScopeCheckerVisitorException(new ScopeException("Unknown identifier: " + terminalNode.getSymbol().getText()));
    }

    public class ScopeCheckerVisitorException
    extends RuntimeException {
        private static final long serialVersionUID = 5003348008806300117L;
        final ScopeException scopeException;

        public ScopeCheckerVisitorException(ScopeException e) {
            this.scopeException = e;
        }

        public ScopeException getScopeException() {
            return this.scopeException;
        }
    }
}

