/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.cst;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.antlr.BMoThParserBaseVisitor;
import de.bmoth.parser.ParseErrorException;
import de.bmoth.parser.Parser;
import de.bmoth.parser.cst.BDefinition;
import de.bmoth.parser.cst.ScopeChecker;
import de.bmoth.parser.cst.ScopeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;

public class MachineAnalyser {
    private final BMoThParser.StartContext parseTree;
    private final MachineScopeChecker machineScopeChecker;
    final LinkedHashMap<String, TerminalNode> constantsDeclarations = new LinkedHashMap();
    final LinkedHashMap<String, TerminalNode> variablesDeclarations = new LinkedHashMap();
    final LinkedHashMap<String, TerminalNode> setsDeclarations = new LinkedHashMap();
    final List<BMoThParser.EnumeratedSetContext> enumeratedSetContexts = new ArrayList<BMoThParser.EnumeratedSetContext>();
    final List<BMoThParser.DeferredSetContext> deferredSetContexts = new ArrayList<BMoThParser.DeferredSetContext>();
    final LinkedHashMap<String, TerminalNode> definitionsDeclarations = new LinkedHashMap();
    final LinkedHashMap<TerminalNode, BDefinition> definitions = new LinkedHashMap();
    final LinkedHashMap<String, BMoThParser.OperationContext> operationsDeclarations = new LinkedHashMap();
    final LinkedHashMap<String, BMoThParser.EnumeratedSetContext> enumeratedSetElementsDeclarations = new LinkedHashMap();
    private BMoThParser.PredicateClauseContext propertiesClause;
    private BMoThParser.PredicateClauseContext invariantClause;
    private BMoThParser.InitialisationClauseContext initialisationClause;
    private LinkedHashMap<TerminalNode, TerminalNode> declarationReferences;
    private final Map<ParserRuleContext, BDefinition> definitionCallReplacements = new HashMap<ParserRuleContext, BDefinition>();
    final LinkedHashMap<String, BMoThParser.StringExpressionContext> unparsedLTLFormulas = new LinkedHashMap();
    final LinkedHashMap<String, BMoThParser.LtlStartContext> ltlFormulas = new LinkedHashMap();

    public MachineAnalyser(BMoThParser.StartContext start) throws ScopeException, ParseErrorException {
        this.parseTree = start;
        this.machineScopeChecker = new MachineScopeChecker();
        try {
            new DeclarationFinder();
            this.checkScope();
        }
        catch (ScopeChecker.ScopeCheckerVisitorException e) {
            Logger logger = Logger.getLogger(e.getClass().getName());
            logger.log(Level.SEVERE, "SCOPE_ERROR", e);
            throw e.getScopeException();
        }
    }

    public Map<String, BMoThParser.LtlStartContext> getLTLFormulaMap() {
        return this.ltlFormulas;
    }

    public BMoThParser.PredicateClauseContext getPropertiesClause() {
        return this.propertiesClause;
    }

    public BMoThParser.PredicateClauseContext getInvariantClause() {
        return this.invariantClause;
    }

    public BMoThParser.InitialisationClauseContext getInitialisationClause() {
        return this.initialisationClause;
    }

    public Map<ParserRuleContext, BDefinition> getDefinitionCallReplacements() {
        return this.definitionCallReplacements;
    }

    public List<TerminalNode> getConstants() {
        return new ArrayList<TerminalNode>(this.constantsDeclarations.values());
    }

    public List<TerminalNode> getVariables() {
        return new ArrayList<TerminalNode>(this.variablesDeclarations.values());
    }

    public List<BMoThParser.EnumeratedSetContext> getEnumeratedSets() {
        return new ArrayList<BMoThParser.EnumeratedSetContext>(this.enumeratedSetContexts);
    }

    public List<BMoThParser.DeferredSetContext> getDeferredSetContexts() {
        return new ArrayList<BMoThParser.DeferredSetContext>(this.deferredSetContexts);
    }

    public List<BMoThParser.OperationContext> getOperations() {
        return new ArrayList<BMoThParser.OperationContext>(this.operationsDeclarations.values());
    }

    public Map<TerminalNode, TerminalNode> getDeclarationReferences() {
        return this.declarationReferences;
    }

    private void checkScope() throws ParseErrorException {
        this.machineScopeChecker.check();
        this.declarationReferences = this.machineScopeChecker.declarationReferences;
    }

    class MachineScopeChecker
    extends ScopeChecker {
        MachineScopeChecker() {
        }

        void check() throws ParseErrorException {
            if (MachineAnalyser.this.propertiesClause != null) {
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                MachineAnalyser.this.propertiesClause.accept(this);
                this.scopeTable.clear();
            }
            if (MachineAnalyser.this.invariantClause != null) {
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.variablesDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                MachineAnalyser.this.invariantClause.accept(this);
                this.scopeTable.clear();
            }
            if (MachineAnalyser.this.initialisationClause != null) {
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.variablesDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                MachineAnalyser.this.initialisationClause.accept(this);
                this.scopeTable.clear();
            }
            for (Map.Entry<String, BMoThParser.OperationContext> entry : MachineAnalyser.this.operationsDeclarations.entrySet()) {
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.variablesDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                BMoThParser.OperationContext operation = entry.getValue();
                if (operation.outputParams != null) {
                    LinkedHashMap<String, TerminalNode> outputMap = new LinkedHashMap<String, TerminalNode>();
                    for (TerminalNode terminalNode : operation.outputParams.IDENTIFIER()) {
                        outputMap.put(terminalNode.getSymbol().getText(), terminalNode);
                    }
                    this.scopeTable.add(outputMap);
                }
                if (operation.params != null) {
                    LinkedHashMap paramsMap = new LinkedHashMap();
                    for (TerminalNode terminalNode : operation.params.IDENTIFIER()) {
                        paramsMap.put(terminalNode.getSymbol().getText(), terminalNode);
                    }
                    this.scopeTable.add(paramsMap);
                }
                operation.substitution().accept(this);
                this.scopeTable.clear();
            }
            for (BDefinition bDefinition : MachineAnalyser.this.definitions.values()) {
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.variablesDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                LinkedHashMap<String, TerminalNode> localIdentifiers = new LinkedHashMap<String, TerminalNode>();
                for (TerminalNode terminalNode : bDefinition.getParameters()) {
                    localIdentifiers.put(terminalNode.getSymbol().getText(), terminalNode);
                }
                this.scopeTable.add(localIdentifiers);
                bDefinition.getDefinitionContext().definition_body().accept(this);
                this.scopeTable.clear();
            }
            for (Map.Entry entry : MachineAnalyser.this.unparsedLTLFormulas.entrySet()) {
                String name = (String)entry.getKey();
                BMoThParser.StringExpressionContext value = (BMoThParser.StringExpressionContext)((Object)entry.getValue());
                String string = value.getText();
                string = string.startsWith("\"") ? string.substring(1, string.length() - 1) : string.substring(3, string.length() - 3);
                this.scopeTable.clear();
                this.scopeTable.add(MachineAnalyser.this.setsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.constantsDeclarations);
                this.scopeTable.add(MachineAnalyser.this.variablesDeclarations);
                this.scopeTable.add(MachineAnalyser.this.definitionsDeclarations);
                BMoThParser.LtlStartContext ltlStart = Parser.getLTLFormulaAsCST(string);
                MachineAnalyser.this.ltlFormulas.put(name, ltlStart);
                ltlStart.accept(this);
                this.scopeTable.clear();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void visitIdentifierExpression(BMoThParser.IdentifierExpressionContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.lookUpTerminalNode(terminalNode);
            TerminalNode declarationNode = (TerminalNode)this.declarationReferences.get(terminalNode);
            if (!MachineAnalyser.this.definitions.containsKey(declarationNode)) return null;
            BDefinition bDefinition = MachineAnalyser.this.definitions.get(declarationNode);
            if (bDefinition.getKind() == BDefinition.KIND.SUBSTITUTION || bDefinition.getKind() == BDefinition.KIND.PREDICATE) {
                throw new ScopeChecker.ScopeCheckerVisitorException(this, new ScopeException("Expected a EXPRESSION definition but found a " + (Object)((Object)bDefinition.getKind()) + " at definition " + bDefinition.getName()));
            }
            if (bDefinition.getArity() > 0) {
                if (!(ctx.parent instanceof BMoThParser.FunctionCallExpressionContext)) throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition));
                BMoThParser.FunctionCallExpressionContext funcCall = (BMoThParser.FunctionCallExpressionContext)ctx.parent;
                if (funcCall.exprs.size() - 1 != bDefinition.getArity()) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition, funcCall.exprs.size() - 1));
                }
                MachineAnalyser.this.definitionCallReplacements.put(funcCall, bDefinition);
                return null;
            } else {
                MachineAnalyser.this.definitionCallReplacements.put(ctx, bDefinition);
            }
            return null;
        }

        @Override
        public Void visitPredicateDefinitionCall(BMoThParser.PredicateDefinitionCallContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.lookUpTerminalNode(terminalNode);
            TerminalNode declarationTNode = (TerminalNode)this.declarationReferences.get(terminalNode);
            if (MachineAnalyser.this.definitions.containsKey(declarationTNode)) {
                BDefinition bDefinition = MachineAnalyser.this.definitions.get(declarationTNode);
                if (ctx.exprs.size() != bDefinition.getArity()) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition, ctx.exprs.size()));
                }
                MachineAnalyser.this.definitionCallReplacements.put(ctx, bDefinition);
            }
            return null;
        }

        @Override
        public Void visitDefinitionAmbiguousCall(BMoThParser.DefinitionAmbiguousCallContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.lookUpTerminalNode(terminalNode);
            TerminalNode declarationTNode = (TerminalNode)this.declarationReferences.get(terminalNode);
            if (MachineAnalyser.this.definitions.containsKey(declarationTNode)) {
                BDefinition bDefinition = MachineAnalyser.this.definitions.get(declarationTNode);
                if (bDefinition.getArity() > 0 && null == ctx.expression_list()) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition));
                }
                if (null != ctx.expression_list() && bDefinition.getArity() != ctx.expression_list().exprs.size()) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition, ctx.expression_list().exprs.size()));
                }
                MachineAnalyser.this.definitionCallReplacements.put(ctx, bDefinition);
            }
            return null;
        }

        @Override
        public Void visitPredicateIdentifier(BMoThParser.PredicateIdentifierContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.lookUpTerminalNode(terminalNode);
            TerminalNode declarationTNode = (TerminalNode)this.declarationReferences.get(terminalNode);
            if (MachineAnalyser.this.definitions.containsKey(declarationTNode)) {
                BDefinition bDefinition = MachineAnalyser.this.definitions.get(declarationTNode);
                if (bDefinition.getKind() == BDefinition.KIND.SUBSTITUTION || bDefinition.getKind() == BDefinition.KIND.EXPRESSION) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new ScopeException("Expected a PREDICATE definition but found a " + (Object)((Object)bDefinition.getKind()) + " at definition " + bDefinition.getName()));
                }
                if (bDefinition.getArity() > 0) {
                    throw new ScopeChecker.ScopeCheckerVisitorException(this, new UnmatchedArgumentsQuantityException(bDefinition));
                }
                MachineAnalyser.this.definitionCallReplacements.put(ctx, bDefinition);
            }
            return null;
        }
    }

    class UnmatchedArgumentsQuantityException
    extends ScopeException {
        private static final long serialVersionUID = -2894774140796162549L;

        UnmatchedArgumentsQuantityException(BDefinition definition, int actual) {
            super("The number of parameters does not match the number of arguments of definition '" + definition.getName() + "': " + actual + " vs " + definition.getArity());
        }

        UnmatchedArgumentsQuantityException(BDefinition definition) {
            super("Expecting " + definition.getArity() + " argument(s) for definition " + definition.getName());
        }
    }

    class DeclarationFinder
    extends BMoThParserBaseVisitor<Void> {
        DeclarationFinder() {
            MachineAnalyser.this.parseTree.accept(this);
        }

        @Override
        public Void visitDeclarationClause(BMoThParser.DeclarationClauseContext ctx) {
            LinkedHashMap<String, TerminalNode> declarations = new LinkedHashMap<String, TerminalNode>();
            for (TerminalNode terminalNode : ctx.identifier_list().IDENTIFIER()) {
                this.checkGlobalIdentifiers(terminalNode);
                declarations.put(terminalNode.getSymbol().getText(), terminalNode);
            }
            switch (ctx.clauseName.getType()) {
                case 4: {
                    MachineAnalyser.this.constantsDeclarations.putAll(declarations);
                    break;
                }
                case 6: {
                    MachineAnalyser.this.variablesDeclarations.putAll(declarations);
                    break;
                }
                default: {
                    this.unreachable();
                }
            }
            return null;
        }

        @Override
        public Void visitOrdinaryDefinition(BMoThParser.OrdinaryDefinitionContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.checkGlobalIdentifiers(terminalNode);
            String name = terminalNode.getSymbol().getText();
            MachineAnalyser.this.definitionsDeclarations.put(name, terminalNode);
            BDefinition.KIND kind = null;
            if (ctx.definition_body() instanceof BMoThParser.DefinitionExpressionContext) {
                BMoThParser.Definition_bodyContext definitionBody;
                kind = BDefinition.KIND.EXPRESSION;
                if (name.startsWith("ASSERT_LTL_") && (definitionBody = ctx.definition_body()) instanceof BMoThParser.DefinitionExpressionContext && ((BMoThParser.DefinitionExpressionContext)definitionBody).expression() instanceof BMoThParser.StringExpressionContext) {
                    BMoThParser.StringExpressionContext sCtx = (BMoThParser.StringExpressionContext)((BMoThParser.DefinitionExpressionContext)definitionBody).expression();
                    MachineAnalyser.this.unparsedLTLFormulas.put(name, sCtx);
                }
            } else if (ctx.definition_body() instanceof BMoThParser.DefinitionPredicateContext) {
                kind = BDefinition.KIND.PREDICATE;
            } else if (ctx.definition_body() instanceof BMoThParser.DefinitionSubstitutionContext) {
                kind = BDefinition.KIND.SUBSTITUTION;
            } else if (ctx.definition_body() instanceof BMoThParser.DefinitionAmbiguousCallContext) {
                kind = BDefinition.KIND.UNKNOWN;
            }
            BDefinition bDefinition = new BDefinition(name, ctx, kind);
            MachineAnalyser.this.definitions.put(terminalNode, bDefinition);
            return null;
        }

        @Override
        public Void visitEnumeratedSet(BMoThParser.EnumeratedSetContext ctx) {
            MachineAnalyser.this.enumeratedSetContexts.add(ctx);
            TerminalNode terminalNode = ctx.IDENTIFIER();
            Token nameToken = ctx.IDENTIFIER().getSymbol();
            this.checkGlobalIdentifiers(terminalNode);
            String name = nameToken.getText();
            MachineAnalyser.this.setsDeclarations.put(name, terminalNode);
            for (TerminalNode enumValue : ctx.identifier_list().IDENTIFIER()) {
                this.checkGlobalIdentifiers(enumValue);
                MachineAnalyser.this.setsDeclarations.put(enumValue.getSymbol().getText(), enumValue);
            }
            return null;
        }

        @Override
        public Void visitDeferredSet(BMoThParser.DeferredSetContext ctx) {
            MachineAnalyser.this.deferredSetContexts.add(ctx);
            Token nameToken = ctx.IDENTIFIER().getSymbol();
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.checkGlobalIdentifiers(terminalNode);
            String name = nameToken.getText();
            MachineAnalyser.this.setsDeclarations.put(name, terminalNode);
            return null;
        }

        private void checkGlobalIdentifiers(TerminalNode terminalNode) {
            String name = terminalNode.getSymbol().getText();
            if (MachineAnalyser.this.constantsDeclarations.containsKey(name) || MachineAnalyser.this.variablesDeclarations.containsKey(name) || MachineAnalyser.this.operationsDeclarations.containsKey(name) || MachineAnalyser.this.setsDeclarations.containsKey(name)) {
                MachineScopeChecker machineScopeChecker = MachineAnalyser.this.machineScopeChecker;
                machineScopeChecker.getClass();
                throw new ScopeChecker.ScopeCheckerVisitorException(machineScopeChecker, new ScopeException("Duplicate declaration of identifier: " + name));
            }
        }

        private void unreachable() {
            throw new AssertionError((Object)"Should not be reachable due to the antlr grammar.");
        }

        @Override
        public Void visitOperation(BMoThParser.OperationContext ctx) {
            TerminalNode terminalNode = ctx.IDENTIFIER();
            this.checkGlobalIdentifiers(terminalNode);
            String name = terminalNode.getSymbol().getText();
            MachineAnalyser.this.operationsDeclarations.put(name, ctx);
            return null;
        }

        @Override
        public Void visitPredicateClause(BMoThParser.PredicateClauseContext ctx) {
            switch (ctx.clauseName.getType()) {
                case 7: {
                    if (MachineAnalyser.this.invariantClause == null) {
                        MachineAnalyser.this.invariantClause = ctx;
                        break;
                    }
                    MachineScopeChecker machineScopeChecker = MachineAnalyser.this.machineScopeChecker;
                    machineScopeChecker.getClass();
                    throw new ScopeChecker.ScopeCheckerVisitorException(machineScopeChecker, new ScopeException("Duplicate INVARIANT clause."));
                }
                case 5: {
                    if (MachineAnalyser.this.propertiesClause == null) {
                        MachineAnalyser.this.propertiesClause = ctx;
                        break;
                    }
                    MachineScopeChecker machineScopeChecker = MachineAnalyser.this.machineScopeChecker;
                    machineScopeChecker.getClass();
                    throw new ScopeChecker.ScopeCheckerVisitorException(machineScopeChecker, new ScopeException("Duplicate PROPERTIES clause."));
                }
                default: {
                    this.unreachable();
                }
            }
            return null;
        }

        @Override
        public Void visitInitialisationClause(BMoThParser.InitialisationClauseContext ctx) {
            if (MachineAnalyser.this.initialisationClause != null) {
                MachineScopeChecker machineScopeChecker = MachineAnalyser.this.machineScopeChecker;
                machineScopeChecker.getClass();
                throw new ScopeChecker.ScopeCheckerVisitorException(machineScopeChecker, new ScopeException("Duplicate PROPERTIES clause."));
            }
            MachineAnalyser.this.initialisationClause = ctx;
            return null;
        }
    }
}

