/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.cst;

import de.bmoth.antlr.BMoThParser;
import de.bmoth.antlr.BMoThParserBaseVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;

public class CSTAnalyser {
    private List<String> warnings = new ArrayList<String>();

    public static List<String> analyseConcreteSyntaxTree(ParserRuleContext tree) {
        CSTAnalyser cstAnalyser = new CSTAnalyser();
        CSTVisitor cstVisitor = cstAnalyser.new CSTVisitor();
        cstVisitor.visit((ParseTree)tree);
        return cstAnalyser.warnings;
    }

    class CSTVisitor
    extends BMoThParserBaseVisitor<Void> {
        CSTVisitor() {
        }

        @Override
        public Void visitPredicateOperator(BMoThParser.PredicateOperatorContext ctx) {
            this.checkForAmbiguousOperatorCombination(ctx, 64, 65);
            this.checkForAmbiguousOperatorCombination(ctx, 65, 64);
            return null;
        }

        private void checkForAmbiguousOperatorCombination(BMoThParser.PredicateOperatorContext ctx, int op1, int op2) {
            if (ctx.operator.getType() == op1) {
                for (BMoThParser.PredicateContext predicateContext : ctx.predicate()) {
                    if (!(predicateContext instanceof BMoThParser.PredicateOperatorContext)) continue;
                    BMoThParser.PredicateOperatorContext predicateOperator = (BMoThParser.PredicateOperatorContext)predicateContext;
                    if (predicateOperator.operator.getType() != op2) continue;
                    Token operator1 = ctx.operator;
                    Token operator2 = predicateOperator.operator;
                    this.addWarning(String.format("Ambiguous combination of operators '%s' (line %s, pos %s) and '%s' (line %s, pos %s). Use parentheses to avoid this.", operator2.getText(), operator2.getLine(), operator2.getCharPositionInLine(), operator1.getText(), operator1.getLine(), operator1.getCharPositionInLine()));
                }
            }
        }

        private void addWarning(String s) {
            CSTAnalyser.this.warnings.add(s);
        }
    }
}

