/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.cst;

import de.bmoth.parser.cst.ScopeChecker;
import de.bmoth.parser.cst.ScopeException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public abstract class AbstractFormulaAnalyser {
    private final LinkedHashMap<String, TerminalNode> implicitDeclarations = new LinkedHashMap();
    private final LinkedHashMap<TerminalNode, TerminalNode> declarationReferences;

    public AbstractFormulaAnalyser(ParserRuleContext node) throws ScopeException {
        try {
            FormulaScopeChecker scopeChecker = new FormulaScopeChecker();
            node.accept((ParseTreeVisitor)scopeChecker);
            this.declarationReferences = scopeChecker.declarationReferences;
        }
        catch (ScopeChecker.ScopeCheckerVisitorException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "SCOPE_ERROR", e);
            throw e.getScopeException();
        }
    }

    public Map<String, TerminalNode> getImplicitDeclarations() {
        return new LinkedHashMap<String, TerminalNode>(this.implicitDeclarations);
    }

    public Map<TerminalNode, TerminalNode> getDeclarationReferences() {
        return this.declarationReferences;
    }

    class FormulaScopeChecker
    extends ScopeChecker {
        FormulaScopeChecker() {
        }

        @Override
        public void identifierNodeNotFound(TerminalNode terminalNode) {
            String name = terminalNode.getSymbol().getText();
            if (AbstractFormulaAnalyser.this.implicitDeclarations.containsKey(name)) {
                this.declarationReferences.put(terminalNode, AbstractFormulaAnalyser.this.implicitDeclarations.get(name));
            } else {
                AbstractFormulaAnalyser.this.implicitDeclarations.put(name, terminalNode);
                this.declarationReferences.put(terminalNode, terminalNode);
            }
        }
    }
}

