/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.visitors;

import de.bmoth.parser.ast.TypeChecker;
import de.bmoth.parser.ast.TypeErrorException;
import de.bmoth.parser.ast.nodes.AbstractIfAndSelectSubstitutionsNode;
import de.bmoth.parser.ast.nodes.AnySubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesElementOfSubstitutionNode;
import de.bmoth.parser.ast.nodes.BecomesSuchThatSubstitutionNode;
import de.bmoth.parser.ast.nodes.CastPredicateExpressionNode;
import de.bmoth.parser.ast.nodes.ConditionSubstitutionNode;
import de.bmoth.parser.ast.nodes.DeferredSetNode;
import de.bmoth.parser.ast.nodes.EnumeratedSetElementNode;
import de.bmoth.parser.ast.nodes.EnumerationSetNode;
import de.bmoth.parser.ast.nodes.ExprNode;
import de.bmoth.parser.ast.nodes.ExpressionOperatorNode;
import de.bmoth.parser.ast.nodes.FormulaNode;
import de.bmoth.parser.ast.nodes.IdentifierExprNode;
import de.bmoth.parser.ast.nodes.IdentifierPredicateNode;
import de.bmoth.parser.ast.nodes.IfSubstitutionNode;
import de.bmoth.parser.ast.nodes.MachineNode;
import de.bmoth.parser.ast.nodes.Node;
import de.bmoth.parser.ast.nodes.NumberNode;
import de.bmoth.parser.ast.nodes.ParallelSubstitutionNode;
import de.bmoth.parser.ast.nodes.PredicateNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorNode;
import de.bmoth.parser.ast.nodes.PredicateOperatorWithExprArgsNode;
import de.bmoth.parser.ast.nodes.QuantifiedExpressionNode;
import de.bmoth.parser.ast.nodes.QuantifiedPredicateNode;
import de.bmoth.parser.ast.nodes.SelectSubstitutionNode;
import de.bmoth.parser.ast.nodes.SetComprehensionNode;
import de.bmoth.parser.ast.nodes.SingleAssignSubstitutionNode;
import de.bmoth.parser.ast.nodes.SkipSubstitutionNode;
import de.bmoth.parser.ast.nodes.SubstitutionNode;
import de.bmoth.parser.ast.nodes.ltl.LTLBPredicateNode;
import de.bmoth.parser.ast.nodes.ltl.LTLFormula;
import de.bmoth.parser.ast.nodes.ltl.LTLInfixOperatorNode;
import de.bmoth.parser.ast.nodes.ltl.LTLKeywordNode;
import de.bmoth.parser.ast.nodes.ltl.LTLNode;
import de.bmoth.parser.ast.nodes.ltl.LTLPrefixOperatorNode;
import de.bmoth.parser.ast.visitors.ASTTransformation;
import de.bmoth.parser.ast.visitors.AbstractVisitor;
import java.util.List;
import java.util.stream.Collectors;

public class ASTTransformationVisitor {
    private final List<ASTTransformation> modifierList;

    public ASTTransformationVisitor(List<ASTTransformation> modifierList) {
        this.modifierList = modifierList;
    }

    public void transformLTLFormula(LTLFormula ltlFormula) {
        ASTVisitor astVisitor = new ASTVisitor();
        ltlFormula.setFormula((LTLNode)astVisitor.startTransformation(ltlFormula.getLTLNode()));
        ltlFormula.getLTLNode();
        try {
            TypeChecker.typecheckLTLFormulaNode(ltlFormula);
        }
        catch (TypeErrorException e) {
            throw new AssertionError((Object)e);
        }
    }

    public LTLNode transformLTLNode(LTLNode ltlNode) {
        ASTVisitor astVisitor = new ASTVisitor();
        return (LTLNode)astVisitor.startTransformation(ltlNode);
    }

    public void transformMachine(MachineNode machineNode) {
        ASTVisitor astVisitor = new ASTVisitor();
        if (machineNode.getProperties() != null) {
            machineNode.setProperties((PredicateNode)astVisitor.startTransformation(machineNode.getProperties()));
        }
        if (machineNode.getInvariant() != null) {
            machineNode.setInvariant((PredicateNode)astVisitor.startTransformation(machineNode.getInvariant()));
        }
        if (machineNode.getInitialisation() != null) {
            machineNode.setInitialisation((SubstitutionNode)astVisitor.startTransformation(machineNode.getInitialisation()));
        }
        machineNode.getOperations().forEach(op -> op.setSubstitution((SubstitutionNode)astVisitor.startTransformation(op.getSubstitution())));
        try {
            TypeChecker.typecheckMachineNode(machineNode);
        }
        catch (TypeErrorException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void transformFormula(FormulaNode formulaNode) {
        ASTVisitor astVisitor = new ASTVisitor();
        Node visitPredicateNode = astVisitor.startTransformation((PredicateNode)formulaNode.getFormula());
        formulaNode.setFormula(visitPredicateNode);
        try {
            TypeChecker.typecheckFormulaNode(formulaNode);
        }
        catch (TypeErrorException e) {
            throw new AssertionError((Object)e);
        }
    }

    private class ASTVisitor
    implements AbstractVisitor<Node, Void> {
        boolean hasChanged = false;

        private ASTVisitor() {
        }

        Node startTransformation(Node node) {
            this.hasChanged = true;
            Node temp = node;
            while (this.hasChanged) {
                this.hasChanged = false;
                temp = this.modifyNode(temp);
            }
            return temp;
        }

        private Node modifyNode(Node node) {
            for (ASTTransformation astModifier : ASTTransformationVisitor.this.modifierList) {
                Node temp;
                if (!astModifier.canHandleNode(node) || (temp = astModifier.transformNode(node)).equalAst(node)) continue;
                this.hasChanged = true;
                return this.modifyNode(temp);
            }
            return (Node)this.visitNode(node, null);
        }

        @Override
        public Node visitPredicateOperatorNode(PredicateOperatorNode node, Void unused) {
            List<PredicateNode> list = node.getPredicateArguments().stream().map(predNode -> (PredicateNode)this.modifyNode((Node)predNode)).collect(Collectors.toList());
            node.setPredicateList(list);
            return node;
        }

        @Override
        public Node visitPredicateOperatorWithExprArgs(PredicateOperatorWithExprArgsNode node, Void unused) {
            List<ExprNode> argumentList = node.getExpressionNodes().stream().map(exprNode -> (ExprNode)this.modifyNode((Node)exprNode)).collect(Collectors.toList());
            node.setArgumentsList(argumentList);
            return node;
        }

        @Override
        public Node visitExprOperatorNode(ExpressionOperatorNode node, Void unused) {
            List<ExprNode> arguments = node.getExpressionNodes().stream().map(exprNode -> (ExprNode)this.modifyNode((Node)exprNode)).collect(Collectors.toList());
            node.setExpressionList(arguments);
            return node;
        }

        @Override
        public Node visitIdentifierExprNode(IdentifierExprNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitCastPredicateExpressionNode(CastPredicateExpressionNode node, Void unused) {
            Node arg = this.modifyNode(node.getPredicate());
            node.setArg((PredicateNode)arg);
            return node;
        }

        @Override
        public Node visitNumberNode(NumberNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitSelectSubstitutionNode(SelectSubstitutionNode node, Void unused) {
            return this.visitIfOrSelectNode(node);
        }

        @Override
        public Node visitIfSubstitutionNode(IfSubstitutionNode node, Void unused) {
            return this.visitIfOrSelectNode(node);
        }

        private Node visitIfOrSelectNode(AbstractIfAndSelectSubstitutionsNode node) {
            node.setConditions(node.getConditions().stream().map(t -> (PredicateNode)this.modifyNode((Node)t)).collect(Collectors.toList()));
            node.setSubstitutions(node.getSubstitutions().stream().map(t -> (SubstitutionNode)this.modifyNode((Node)t)).collect(Collectors.toList()));
            if (null != node.getElseSubstitution()) {
                SubstitutionNode elseSub = (SubstitutionNode)this.modifyNode(node.getElseSubstitution());
                node.setElseSubstitution(elseSub);
            }
            return node;
        }

        @Override
        public Node visitConditionSubstitutionNode(ConditionSubstitutionNode node, Void unused) {
            node.setCondition((PredicateNode)this.modifyNode(node.getCondition()));
            node.setSubstitution((SubstitutionNode)this.modifyNode(node.getSubstitution()));
            return node;
        }

        @Override
        public Node visitSingleAssignSubstitution(SingleAssignSubstitutionNode node, Void unused) {
            node.setValue((ExprNode)this.modifyNode(node.getValue()));
            return node;
        }

        @Override
        public Node visitAnySubstitution(AnySubstitutionNode node, Void unused) {
            node.setPredicate((PredicateNode)this.modifyNode(node.getWherePredicate()));
            node.setSubstitution((SubstitutionNode)this.modifyNode(node.getThenSubstitution()));
            return node;
        }

        @Override
        public Node visitParallelSubstitutionNode(ParallelSubstitutionNode node, Void unused) {
            List<SubstitutionNode> substitutions = node.getSubstitutions().stream().map(sub -> (SubstitutionNode)this.modifyNode((Node)sub)).collect(Collectors.toList());
            node.setSubstitutions(substitutions);
            return node;
        }

        @Override
        public Node visitIdentifierPredicateNode(IdentifierPredicateNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitQuantifiedExpressionNode(QuantifiedExpressionNode node, Void unused) {
            PredicateNode visitPredicateNode = (PredicateNode)this.modifyNode(node.getPredicateNode());
            node.setPredicate(visitPredicateNode);
            ExprNode expr = (ExprNode)this.modifyNode(node.getExpressionNode());
            node.setExpr(expr);
            return node;
        }

        @Override
        public Node visitSetComprehensionNode(SetComprehensionNode node, Void unused) {
            PredicateNode visitPredicateNode = (PredicateNode)this.modifyNode(node.getPredicateNode());
            node.setPredicate(visitPredicateNode);
            return node;
        }

        @Override
        public Node visitQuantifiedPredicateNode(QuantifiedPredicateNode node, Void unused) {
            PredicateNode pred = (PredicateNode)this.modifyNode(node.getPredicateNode());
            node.setPredicate(pred);
            return node;
        }

        @Override
        public Node visitBecomesSuchThatSubstitutionNode(BecomesSuchThatSubstitutionNode node, Void unused) {
            node.setPredicate((PredicateNode)this.modifyNode(node.getPredicate()));
            return node;
        }

        @Override
        public Node visitBecomesElementOfSubstitutionNode(BecomesElementOfSubstitutionNode node, Void unused) {
            node.setExpression((ExprNode)this.modifyNode(node.getExpression()));
            return node;
        }

        @Override
        public Node visitSkipSubstitutionNode(SkipSubstitutionNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitEnumerationSetNode(EnumerationSetNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitDeferredSetNode(DeferredSetNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitEnumeratedSetElementNode(EnumeratedSetElementNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitLTLPrefixOperatorNode(LTLPrefixOperatorNode node, Void unused) {
            node.setLTLNode((LTLNode)this.modifyNode(node.getArgument()));
            return node;
        }

        @Override
        public Node visitLTLKeywordNode(LTLKeywordNode node, Void unused) {
            return node;
        }

        @Override
        public Node visitLTLInfixOperatorNode(LTLInfixOperatorNode node, Void unused) {
            node.setLeft((LTLNode)this.modifyNode(node.getLeft()));
            node.setRight((LTLNode)this.modifyNode(node.getRight()));
            return node;
        }

        @Override
        public Node visitLTLBPredicateNode(LTLBPredicateNode node, Void unused) {
            node.setPredicateNode((PredicateNode)this.modifyNode(node.getPredicate()));
            return node;
        }
    }
}

