/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.types;

import de.bmoth.parser.ast.types.BType;
import de.bmoth.parser.ast.types.IntegerOrSetOfPairs;
import de.bmoth.parser.ast.types.SetOrIntegerType;
import de.bmoth.parser.ast.types.UnificationException;
import de.bmoth.parser.ast.types.UntypedType;
import java.util.Observable;
import java.util.Observer;

public class SetType
extends Observable
implements BType,
Observer {
    private BType subType;

    public SetType(BType subType) {
        this.setSubType(subType);
    }

    private void setSubType(BType subType) {
        this.subType = subType;
        if (subType instanceof Observable) {
            ((Observable)((Object)subType)).addObserver(this);
        }
    }

    public BType getSubType() {
        return this.subType;
    }

    @Override
    public boolean unifiable(BType otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType instanceof UntypedType && !this.contains(otherType)) {
            return true;
        }
        if (otherType instanceof SetOrIntegerType) {
            return true;
        }
        if (otherType instanceof SetType) {
            SetType setType = (SetType)otherType;
            return this.getSubType().unifiable(setType.getSubType());
        }
        return otherType instanceof IntegerOrSetOfPairs;
    }

    @Override
    public boolean contains(BType other) {
        return this.subType == other || this.subType.contains(other);
    }

    @Override
    public BType unify(BType otherType) throws UnificationException {
        if (this.unifiable(otherType)) {
            if (otherType instanceof UntypedType) {
                ((UntypedType)otherType).replaceBy(this);
                return this;
            }
            if (otherType instanceof SetOrIntegerType) {
                return otherType.unify(this);
            }
            if (otherType instanceof IntegerOrSetOfPairs) {
                return otherType.unify(this);
            }
            SetType otherSetType = (SetType)otherType;
            otherSetType.replaceBy(this);
            this.subType.unify(otherSetType.subType);
            return this;
        }
        throw new UnificationException();
    }

    public void replaceBy(BType otherType) {
        if (this.subType instanceof Observable) {
            ((Observable)((Object)this.subType)).deleteObserver(this);
        }
        this.setChanged();
        this.notifyObservers(otherType);
    }

    @Override
    public void update(Observable o, Object arg) {
        o.deleteObserver(this);
        this.setSubType((BType)arg);
    }

    public String toString() {
        return "POW(" + this.getSubType().toString() + ")";
    }

    @Override
    public boolean isUntyped() {
        return this.subType.isUntyped();
    }
}

