/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.types;

import de.bmoth.parser.ast.types.BType;
import de.bmoth.parser.ast.types.CoupleType;
import de.bmoth.parser.ast.types.IntegerType;
import de.bmoth.parser.ast.types.SetOrIntegerType;
import de.bmoth.parser.ast.types.SetType;
import de.bmoth.parser.ast.types.UnificationException;
import de.bmoth.parser.ast.types.UntypedType;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IntegerOrSetOfPairs
extends Observable
implements BType,
Observer {
    private BType left;
    private BType right;

    public IntegerOrSetOfPairs(BType left, BType right) {
        this.setLeftType(left);
        this.setRightType(right);
    }

    private void setLeftType(BType left) {
        this.left = left;
        if (left instanceof Observable) {
            ((Observable)((Object)left)).addObserver(this);
        }
    }

    private void setRightType(BType right) {
        this.right = right;
        if (right instanceof Observable) {
            ((Observable)((Object)right)).addObserver(this);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        o.deleteObserver(this);
        BType newType = (BType)arg;
        try {
            if (newType instanceof IntegerType) {
                this.setChanged();
                this.notifyObservers(newType);
                if (o == this.getLeft()) {
                    this.getRight().unify(IntegerType.getInstance());
                } else {
                    this.getLeft().unify(IntegerType.getInstance());
                }
            } else if (newType instanceof SetType && o == this.getLeft() && o == this.getRight()) {
                this.setChanged();
                BType subType = ((SetType)newType).getSubType();
                SetType cartesianProductType = new SetType(new CoupleType(subType, subType));
                this.notifyObservers(cartesianProductType);
            } else if (newType instanceof SetType && o == this.getLeft()) {
                this.setChanged();
                if (this.right instanceof Observable) {
                    ((Observable)((Object)this.right)).deleteObserver(this);
                }
                SetType r = (SetType)this.right.unify(new SetType(new UntypedType()));
                this.notifyObservers(new SetType(new CoupleType(((SetType)newType).getSubType(), r.getSubType())));
            } else if (newType instanceof SetType && o != this.getLeft()) {
                this.setChanged();
                if (this.left instanceof Observable) {
                    ((Observable)((Object)this.left)).deleteObserver(this);
                }
                SetType l = (SetType)this.left.unify(new SetType(new UntypedType()));
                this.notifyObservers(new SetType(new CoupleType(l.getSubType(), ((SetType)newType).getSubType())));
            } else if (o == this.getLeft() && o == this.getRight()) {
                this.setLeftType(newType);
                this.setRightType(newType);
            } else if (o == this.getLeft()) {
                this.setLeftType(newType);
            } else {
                this.setRightType(newType);
            }
        }
        catch (UnificationException e) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "unification failed in update", e);
        }
    }

    @Override
    public BType unify(BType otherType) throws UnificationException {
        if (otherType instanceof SetType) {
            if (this.left instanceof Observable) {
                ((Observable)((Object)this.left)).deleteObserver(this);
            }
            if (this.right instanceof Observable) {
                ((Observable)((Object)this.right)).deleteObserver(this);
            }
            SetType l = (SetType)this.left.unify(new SetType(new UntypedType()));
            SetType r = (SetType)this.right.unify(new SetType(new UntypedType()));
            SetType found = new SetType(new CoupleType(l.getSubType(), r.getSubType()));
            found = (SetType)found.unify(otherType);
            this.setChanged();
            this.notifyObservers(found);
            return found;
        }
        if (otherType instanceof UntypedType) {
            ((UntypedType)otherType).replaceBy(this);
            return this;
        }
        if (otherType instanceof IntegerOrSetOfPairs) {
            IntegerOrSetOfPairs other = (IntegerOrSetOfPairs)otherType;
            other.replaceBy(this);
            this.getLeft().unify(other.getLeft());
            this.getRight().unify(other.getRight());
            return this;
        }
        if (otherType instanceof SetOrIntegerType) {
            SetOrIntegerType other = (SetOrIntegerType)otherType;
            other.replaceBy(this);
            return this;
        }
        if (otherType instanceof IntegerType) {
            this.replaceBy(IntegerType.getInstance());
            this.left.unify(IntegerType.getInstance());
            this.right.unify(IntegerType.getInstance());
            return IntegerType.getInstance();
        }
        throw new UnificationException();
    }

    private void replaceBy(BType otherType) {
        if (this.getLeft() instanceof Observable) {
            ((Observable)((Object)this.getLeft())).deleteObserver(this);
        }
        if (this.getRight() instanceof Observable) {
            ((Observable)((Object)this.getRight())).deleteObserver(this);
        }
        this.setChanged();
        this.notifyObservers(otherType);
    }

    @Override
    public boolean unifiable(BType otherType) {
        if (otherType instanceof SetOrIntegerType || otherType instanceof IntegerType || otherType instanceof IntegerOrSetOfPairs || otherType instanceof UntypedType) {
            return true;
        }
        if (otherType instanceof SetType) {
            SetType setType = (SetType)otherType;
            return setType.getSubType() instanceof CoupleType;
        }
        return false;
    }

    @Override
    public boolean contains(BType other) {
        return other == this.getLeft() || other == this.getRight();
    }

    @Override
    public boolean isUntyped() {
        return true;
    }

    public BType getLeft() {
        return this.left;
    }

    public BType getRight() {
        return this.right;
    }
}

