/*
 * Decompiled with CFR 0.152.
 */
package de.bmoth.parser.ast.types;

import de.bmoth.parser.ast.types.BType;
import de.bmoth.parser.ast.types.UnificationException;
import de.bmoth.parser.ast.types.UntypedType;
import java.util.Observable;
import java.util.Observer;

public class CoupleType
extends Observable
implements BType,
Observer {
    private BType left;
    private BType right;

    public CoupleType(BType left, BType right) {
        this.setLeftType(left);
        this.setRightType(right);
    }

    private void setLeftType(BType leftType) {
        this.left = leftType;
        if (this.left instanceof Observable) {
            ((Observable)((Object)this.left)).addObserver(this);
        }
    }

    private void setRightType(BType rightType) {
        this.right = rightType;
        if (this.right instanceof Observable) {
            ((Observable)((Object)this.right)).addObserver(this);
        }
    }

    public BType getLeft() {
        return this.left;
    }

    public BType getRight() {
        return this.right;
    }

    @Override
    public void update(Observable o, Object arg) {
        o.deleteObserver(this);
        if (this.left == o && this.right == o) {
            this.setLeftType((BType)arg);
            this.setRightType((BType)arg);
        } else if (this.left == o) {
            this.setLeftType((BType)arg);
        } else {
            this.setRightType((BType)arg);
        }
    }

    @Override
    public CoupleType unify(BType otherType) throws UnificationException {
        if (this.unifiable(otherType)) {
            if (otherType instanceof UntypedType) {
                ((UntypedType)otherType).replaceBy(this);
                return this;
            }
            if (otherType instanceof CoupleType) {
                CoupleType other = (CoupleType)otherType;
                other.replaceBy(this);
                this.left.unify(other.left);
                this.right.unify(other.right);
                return this;
            }
        }
        throw new UnificationException();
    }

    public void replaceBy(BType otherType) {
        if (this.left instanceof Observable) {
            ((Observable)((Object)this.left)).deleteObserver(this);
        }
        if (this.right instanceof Observable) {
            ((Observable)((Object)this.right)).deleteObserver(this);
        }
        this.setChanged();
        this.notifyObservers(otherType);
    }

    @Override
    public boolean unifiable(BType otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType instanceof UntypedType && !this.contains(otherType)) {
            return true;
        }
        if (otherType instanceof CoupleType) {
            CoupleType pair = (CoupleType)otherType;
            return this.left.unifiable(pair.left) && this.right.unifiable(pair.right);
        }
        return false;
    }

    @Override
    public boolean contains(BType other) {
        return this.left == other || this.right == other || this.left.contains(other) || this.right.contains(other);
    }

    @Override
    public boolean isUntyped() {
        return this.left.isUntyped() || this.right.isUntyped();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.left.toString());
        sb.append("*");
        if (this.right instanceof CoupleType) {
            sb.append("(").append(this.right).append(")");
        } else {
            sb.append(this.right);
        }
        return sb.toString();
    }
}

